/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DividerBorder;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.TextSelectionListener;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;
import workbench.util.WbNumberFormatter;

public class SelectionDisplay
extends JLabel
implements TextSelectionListener {
    private JTable table;
    private Border activeBorder = new CompoundBorder(new DividerBorder(1), new EmptyBorder(0, 3, 0, 3));
    private ListSelectionListener rowListener = this::rowSelectionChanged;
    private ListSelectionListener columnListener = this::columnSelectionChanged;

    public SelectionDisplay() {
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
    }

    public void removeClient(JTable jTable) {
        if (jTable != null) {
            TableColumnModel tableColumnModel;
            ListSelectionModel listSelectionModel;
            ListSelectionModel listSelectionModel2 = jTable.getSelectionModel();
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this.rowListener);
            }
            ListSelectionModel listSelectionModel3 = listSelectionModel = (tableColumnModel = jTable.getColumnModel()) != null ? tableColumnModel.getSelectionModel() : null;
            if (listSelectionModel != null) {
                listSelectionModel.removeListSelectionListener(this.columnListener);
            }
            this.setText("");
        }
    }

    public void setClient(JTable jTable) {
        this.removeClient(this.table);
        this.table = jTable;
        if (jTable != null) {
            TableColumnModel tableColumnModel;
            ListSelectionModel listSelectionModel;
            ListSelectionModel listSelectionModel2 = jTable.getSelectionModel();
            if (listSelectionModel2 != null) {
                listSelectionModel2.addListSelectionListener(this.rowListener);
            }
            ListSelectionModel listSelectionModel3 = listSelectionModel = (tableColumnModel = jTable.getColumnModel()) != null ? tableColumnModel.getSelectionModel() : null;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this.columnListener);
            }
        }
    }

    public void setTextClient(EditorPanel editorPanel) {
        if (editorPanel != null) {
            editorPanel.addSelectionListener(this);
        }
    }

    public void removeTextClient(EditorPanel editorPanel) {
        if (editorPanel != null) {
            editorPanel.removeSelectionListener(this);
        }
    }

    @Override
    public void selectionChanged(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 1) {
            this.setText(n3 + " characters selected");
        } else {
            this.setText("");
        }
    }

    protected void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.showSelection();
    }

    protected void rowSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.showSelection();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (StringUtil.isEmptyString(string)) {
            this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        } else {
            this.setBorder(this.activeBorder);
        }
    }

    protected void showSelection() {
        Object object;
        boolean bl;
        if (this.table == null) {
            this.setText("");
            return;
        }
        int[] nArray = this.table.getSelectedColumns();
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = 0.0;
        boolean bl2 = false;
        boolean bl3 = bl = nArray != null && nArray.length > 0 && this.table.getColumnSelectionAllowed();
        if (this.table.getSelectedRowCount() == 1 && nArray.length == 1) {
            bl = false;
        }
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        if (bl) {
            object = this.table.getSelectedRows();
            for (int i = 0; i < ((int[])object).length; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    Object object2 = this.table.getValueAt(object[i], nArray[j]);
                    if (!(object2 instanceof Number)) continue;
                    double d5 = ((Number)object2).doubleValue();
                    d += d5;
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d5 < d2) {
                        d2 = d5;
                    }
                    bl2 = true;
                    ++n2;
                }
            }
            d4 = d / (double)n2;
        }
        object = null;
        if (bl2) {
            WbNumberFormatter wbNumberFormatter = Settings.getInstance().createDefaultDecimalFormatter();
            WbNumberFormatter wbNumberFormatter2 = Settings.getInstance().createDefaultIntegerFormatter();
            object = ResourceMgr.getFormattedString("MsgSelectStats", this.format(d, wbNumberFormatter, wbNumberFormatter2), this.format(d4, wbNumberFormatter, wbNumberFormatter2), this.format(d2, wbNumberFormatter, wbNumberFormatter2), this.format(d3, wbNumberFormatter, wbNumberFormatter2), this.format(n2, wbNumberFormatter, wbNumberFormatter2), this.format(n, wbNumberFormatter, wbNumberFormatter2));
        } else if (n > 0) {
            object = ResourceMgr.getFormattedString("MsgRowsSelected", n);
        }
        if (object == null) {
            this.setText("");
        } else {
            this.setText((String)object);
        }
    }

    private String format(double d, WbNumberFormatter wbNumberFormatter, WbNumberFormatter wbNumberFormatter2) {
        if (wbNumberFormatter2 != null && d == Math.rint(d)) {
            return wbNumberFormatter2.format(d);
        }
        return wbNumberFormatter.format(d);
    }
}

