/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import workbench.db.ConnectionProfile;
import workbench.db.DbSwitcher;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.interfaces.MainPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.WbThread;

public class SwitchDbComboBox
extends JComboBox<String>
implements ItemListener,
PropertyChangeListener {
    private boolean switchAll = false;
    private boolean ignoreItemChange = false;
    private WbConnection connection;
    private DbSwitcher switcher;

    public SwitchDbComboBox() {
        this.addItemListener(this);
    }

    public SwitchDbComboBox(WbConnection wbConnection) {
        this.setConnection(wbConnection);
        this.addItemListener(this);
    }

    public void setConnection(WbConnection wbConnection) {
        if (this.connection != null) {
            this.connection.removeChangeListener(this);
        }
        this.connection = wbConnection;
        this.switcher = DbSwitcher.Factory.createDatabaseSwitcher(wbConnection);
        if (wbConnection == null) {
            this.clear();
        } else {
            this.connection.addChangeListener(this);
            this.retrieve();
            if (wbConnection.isShared()) {
                this.setSwitchWindow(true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.connection && "catalog-list".equals(propertyChangeEvent.getPropertyName())) {
            WbSwingUtilities.invokeLater(this::startRetrieve);
        }
    }

    private void startRetrieve() {
        WbThread wbThread = new WbThread("Retrieve catalogs"){

            @Override
            public void run() {
                SwitchDbComboBox.this.retrieve();
            }
        };
        wbThread.start();
    }

    public void retrieve() {
        if (this.switcher == null) {
            return;
        }
        if (this.connection == null) {
            return;
        }
        this.clear();
        int n = WbSwingUtilities.calculateCharWidth(this, 20);
        Dimension dimension = this.getPreferredSize();
        dimension.setSize(n, dimension.height);
        this.setMaximumSize(dimension);
        List<String> list = this.connection.getObjectCache().getAvailableDatabases();
        if (list != null) {
            WbSwingUtilities.invoke(() -> this.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0]))));
            this.selectCurrentDatabase(this.connection);
        }
    }

    public void selectCurrentDatabase(WbConnection wbConnection) {
        try {
            this.ignoreItemChange = true;
            String string = this.switcher.getCurrentDatabase(wbConnection);
            if (string != null) {
                this.setSelectedItem(string);
            }
        }
        finally {
            this.ignoreItemChange = false;
        }
    }

    public void setSwitchWindow(boolean bl) {
        this.switchAll = bl;
    }

    public void clear() {
        this.setModel(new DefaultComboBoxModel());
    }

    private boolean isConnectInProgress() {
        MainWindow mainWindow = WbSwingUtilities.getMainWindow(this);
        if (mainWindow == null) {
            return false;
        }
        return mainWindow.isConnectInProgress();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreItemChange) {
            return;
        }
        if (itemEvent == null) {
            return;
        }
        if (itemEvent.getSource() == this && itemEvent.getStateChange() == 1) {
            if (this.isConnectInProgress()) {
                WbSwingUtilities.invokeLater(this::changeDatabase);
            } else {
                this.changeDatabase();
            }
        }
    }

    public String getSelectedDatabase() {
        return (String)this.getSelectedItem();
    }

    private void changeDatabase() {
        String string = this.getSelectedDatabase();
        if (string == null) {
            return;
        }
        if (this.switcher == null) {
            return;
        }
        if (this.switchAll) {
            this.switchAll(this.switcher, string);
        } else if (this.connection != null) {
            try {
                this.switcher.switchDatabase(this.connection, string);
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not switch database", sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchAll(DbSwitcher dbSwitcher, String string) {
        MainWindow mainWindow = WbSwingUtilities.getMainWindow(this);
        if (mainWindow == null) {
            return;
        }
        if (dbSwitcher.needsReconnect()) {
            ConnectionProfile connectionProfile = mainWindow.getCurrentProfile();
            if (connectionProfile == null) {
                return;
            }
            String string2 = dbSwitcher.getUrlForDatabase(connectionProfile.getUrl(), string);
            connectionProfile.switchToTemporaryUrl(string2);
            try {
                this.ignoreItemChange = true;
                mainWindow.connectTo(connectionProfile, false, false);
            }
            finally {
                this.ignoreItemChange = false;
            }
        } else {
            this.switchAllConnections(mainWindow, string);
        }
    }

    private void switchAllConnections(MainWindow mainWindow, String string) {
        CallerInfo callerInfo = new CallerInfo(){};
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        int n = mainWindow.getTabCount();
        for (int i = 0; i < n; ++i) {
            MainPanel mainPanel;
            WbConnection wbConnection;
            Optional<MainPanel> optional = mainWindow.getPanel(i);
            if (!optional.isPresent() || (wbConnection = (mainPanel = optional.get()).getConnection()) == null) continue;
            if (wbConnection.isBusy()) {
                LogMgr.logDebug(callerInfo, "Skipping database switch for panel " + mainPanel.getTabTitle() + " (" + mainPanel.getId() + ") because the connection is busy");
            }
            if (set.contains(wbConnection.getId()) || !wbConnection.isShared()) continue;
            LogMgr.logDebug(callerInfo, "Switching database for panel " + mainPanel.getTabTitle() + " (" + mainPanel.getId() + ")");
            try {
                this.switcher.switchDatabase(wbConnection, string);
                set.add(wbConnection.getId());
                continue;
            }
            catch (SQLException sQLException) {
                LogMgr.logError(callerInfo, "Could not switch database for panel " + mainPanel.getTabTitle() + " (" + mainPanel.getId() + ")", sQLException);
            }
        }
    }
}

