/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.FindDataAction;
import workbench.gui.actions.FindDataAgainAction;
import workbench.gui.actions.ReplaceDataAction;
import workbench.gui.components.ReplacePanel;
import workbench.gui.components.SearchCriteriaPanel;
import workbench.gui.components.WbTable;
import workbench.gui.editor.SearchResult;
import workbench.interfaces.Replaceable;
import workbench.interfaces.Searchable;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.DataStoreReplacer;
import workbench.storage.Position;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.RegExComparator;
import workbench.util.ConverterException;
import workbench.util.ExceptionUtil;

public class TableReplacer
implements Searchable,
Replaceable,
TableModelListener {
    private WbTable client;
    private FindDataAction findAction;
    private FindDataAgainAction findAgainAction;
    private ReplaceDataAction replaceAction;
    private DataStoreReplacer replacer;
    private boolean tableChanging;

    public TableReplacer(WbTable wbTable) {
        this.client = wbTable;
        this.client.addTableModelListener(this);
        this.replacer = new DataStoreReplacer();
        this.findAction = new FindDataAction(this);
        this.findAction.setEnabled(false);
        this.findAction.setCreateMenuSeparator(true);
        this.findAgainAction = new FindDataAgainAction(this);
        this.findAgainAction.setEnabled(false);
        this.replaceAction = new ReplaceDataAction(this);
        this.replaceAction.setEnabled(false);
    }

    public FindDataAction getFindAction() {
        return this.findAction;
    }

    public FindDataAgainAction getFindAgainAction() {
        return this.findAgainAction;
    }

    public ReplaceDataAction getReplaceAction() {
        return this.replaceAction;
    }

    @Override
    public void setWrapSearch(boolean bl) {
    }

    @Override
    public int findPrevious() {
        return -1;
    }

    @Override
    public int find() {
        boolean bl = true;
        String string = this.replacer.getLastCriteria();
        SearchCriteriaPanel searchCriteriaPanel = new SearchCriteriaPanel(string, "workbench.data", true);
        Window window = SwingUtilities.getWindowAncestor(this.client);
        Position position = Position.NO_POSITION;
        boolean bl2 = false;
        while (bl) {
            boolean bl3 = searchCriteriaPanel.showFindDialog(window, ResourceMgr.getString("TxtWindowTitleSearchDataText"));
            if (!bl3) {
                return -1;
            }
            String string2 = searchCriteriaPanel.getCriteria();
            boolean bl4 = searchCriteriaPanel.getIgnoreCase();
            boolean bl5 = searchCriteriaPanel.getWholeWordOnly();
            boolean bl6 = searchCriteriaPanel.getUseRegex();
            try {
                this.findAgainAction.setEnabled(false);
                if (searchCriteriaPanel.getHighlightAll()) {
                    this.initTableHighlighter(string2, bl4, bl6);
                    position = this.replacer.find(string2, bl4, bl5, bl6);
                    bl2 = true;
                } else {
                    this.client.clearHighlightExpression();
                    position = this.replacer.find(string2, bl4, bl5, bl6);
                }
                bl = false;
                this.findAgainAction.setEnabled(position.isValid());
            }
            catch (Exception exception) {
                position = Position.NO_POSITION;
                WbSwingUtilities.showErrorMessage(window, ExceptionUtil.getDisplay(exception));
                bl = true;
            }
        }
        if (bl2 && position.isValid()) {
            this.client.scrollToRow(position.getRow());
        } else {
            this.highlightPosition(position);
        }
        return position.getRow();
    }

    protected void initTableHighlighter(String string, boolean bl, boolean bl2) {
        ColumnComparator columnComparator = null;
        columnComparator = bl2 ? new RegExComparator() : new ContainsComparator();
        ColumnExpression columnExpression = new ColumnExpression(columnComparator, string);
        columnExpression.setIgnoreCase(bl);
        this.client.applyHighlightExpression(columnExpression);
    }

    protected void scrollTo(Position position) {
        int n = position.getRow();
        EventQueue.invokeLater(() -> this.client.scrollToRow(n));
    }

    protected void highlightPosition(Position position) {
        int n = position.getRow();
        int n2 = position.getColumn();
        int n3 = this.client.isStatusColumnVisible() ? n2 + 1 : n2;
        EventQueue.invokeLater(() -> {
            this.client.clearSelection();
            if (position.isValid()) {
                this.client.selectCell(n, n3);
            }
        });
    }

    @Override
    public int findNext() {
        Position position = this.replacer.findNext();
        this.highlightPosition(position);
        return position.getRow();
    }

    @Override
    public void replace() {
        if (this.client == null) {
            return;
        }
        if (!this.client.checkPkColumns(true)) {
            return;
        }
        ReplacePanel replacePanel = new ReplacePanel(this, "workbench.data.replace", ResourceMgr.getString("LblSelectedRowsOnly"));
        String string = ResourceMgr.getString("TxtWindowTitleReplaceDataText");
        replacePanel.showReplaceDialog(this.client, this.replacer.getLastCriteria(), string);
    }

    @Override
    public int findFirst(String string, boolean bl, boolean bl2, boolean bl3) {
        this.replacer.reset();
        Position position = this.replacer.find(string, bl, bl2, bl3);
        this.highlightPosition(position);
        return position.getRow();
    }

    @Override
    public boolean replaceCurrent(String string, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.replacer.replaceCurrent(string);
            if (bl2) {
                this.fireTableChanged();
            }
        }
        catch (ConverterException converterException) {
            WbSwingUtilities.showErrorMessage(this.client, converterException.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean replaceNext(String string, boolean bl) {
        boolean bl2 = false;
        bl2 = this.replaceCurrent(string, bl);
        if (bl2) {
            Position position = this.replacer.findNext();
            this.highlightPosition(position);
        }
        return bl2;
    }

    private void fireTableChanged() {
        try {
            this.tableChanging = true;
            this.client.showStatusColumn();
            this.client.getDataStoreTableModel().fireTableDataChanged();
        }
        finally {
            this.tableChanging = false;
        }
    }

    @Override
    public void replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int[] nArray = null;
        if (bl) {
            nArray = this.client.getSelectedRows();
        }
        try {
            int n = this.replacer.replaceAll(string, string2, nArray, bl2, bl3, bl4);
            if (n > 0) {
                this.fireTableChanged();
            }
        }
        catch (ConverterException converterException) {
            WbSwingUtilities.showErrorMessage(this.client, converterException.getMessage());
        }
    }

    @Override
    public boolean isTextSelected() {
        return this.client.getSelectedColumnCount() > 0;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.tableChanging) {
            return;
        }
        this.replacer.setDataStore(this.client.getDataStore());
        DataStore dataStore = this.client.getDataStore();
        WbConnection wbConnection = dataStore != null ? dataStore.getOriginalConnection() : null;
        boolean bl = wbConnection == null ? true : wbConnection.isSessionReadOnly();
        boolean bl2 = this.client.getRowCount() > 0;
        EventQueue.invokeLater(() -> {
            this.findAction.setEnabled(bl2);
            this.replaceAction.setEnabled(bl2 && !bl);
        });
    }

    @Override
    public List<SearchResult> findAll(String string, boolean bl, boolean bl2, boolean bl3, int n) {
        return Collections.emptyList();
    }
}

