/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ClipboardWrapper;
import workbench.gui.components.WbMenu;
import workbench.gui.menu.TextPopup;
import workbench.resource.PlatformShortcuts;
import workbench.resource.Settings;

public class TextComponentMouseListener
implements MouseListener,
CaretListener {
    private List<JMenuItem> additionalItems = new ArrayList<JMenuItem>();
    private TextPopup popup;
    private JTextComponent text;
    private int originalComponentCount = -1;

    public TextComponentMouseListener() {
    }

    public static void addListener(JTextComponent ... jTextComponentArray) {
        if (jTextComponentArray == null || jTextComponentArray.length == 0) {
            return;
        }
        for (JTextComponent jTextComponent : jTextComponentArray) {
            new TextComponentMouseListener(jTextComponent);
        }
    }

    public TextComponentMouseListener(JTextComponent jTextComponent) {
        this.text = jTextComponent;
        this.popup = this.createPopup(jTextComponent);
        this.originalComponentCount = this.popup.getComponentCount();
        this.popup.getCutAction().addToInputMap(this.text);
        this.popup.getClearAction().addToInputMap(this.text);
        this.popup.getPasteAction().addToInputMap(this.text);
        this.popup.getCopyAction().addToInputMap(this.text);
        this.text.addCaretListener(this);
        jTextComponent.addMouseListener(this);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.editor.extended.cutcopypaste", true);
        if (bl) {
            this.setExtendedCopyAndPasteKeys();
        }
    }

    private void setExtendedCopyAndPasteKeys() {
        InputMap inputMap = this.text.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, PlatformShortcuts.getDefaultModifier());
        Object object = inputMap.get(this.popup.getCopyAction().getAccelerator());
        inputMap.put(keyStroke, object);
        keyStroke = KeyStroke.getKeyStroke(155, 1);
        object = inputMap.get(this.popup.getPasteAction().getAccelerator());
        inputMap.put(keyStroke, object);
        keyStroke = KeyStroke.getKeyStroke(127, 1);
        object = inputMap.get(this.popup.getCutAction().getAccelerator());
        inputMap.put(keyStroke, object);
    }

    public void addActionAtStart(WbAction wbAction, boolean bl) {
        if (this.popup != null) {
            this.popup.add((Component)wbAction.getMenuItem(), 0);
            if (bl) {
                this.popup.add((Component)new JPopupMenu.Separator(), 1);
            }
        }
    }

    public void addAction(WbAction wbAction) {
        this.addMenuItem(wbAction.getMenuItem());
        if (this.text != null) {
            wbAction.addToInputMap(this.text);
        }
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        if (this.popup != null) {
            if (this.originalComponentCount > -1 && this.popup.getComponentCount() == this.originalComponentCount) {
                this.popup.addSeparator();
            }
            this.popup.add(jMenuItem);
        } else {
            this.additionalItems.add(jMenuItem);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && mouseEvent.getSource() instanceof JTextComponent) {
            try {
                JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
                TextPopup textPopup = this.popup;
                if (textPopup == null) {
                    textPopup = this.createPopup(jTextComponent);
                }
                this.checkActions(jTextComponent, textPopup);
                textPopup.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private TextPopup createPopup(JTextComponent jTextComponent) {
        ClipboardWrapper clipboardWrapper = new ClipboardWrapper(jTextComponent);
        TextPopup textPopup = new TextPopup(clipboardWrapper);
        if (this.additionalItems.size() > 0) {
            textPopup.addSeparator();
            for (JMenuItem jMenuItem : this.additionalItems) {
                textPopup.add(jMenuItem);
            }
        }
        return textPopup;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.text != null && this.popup != null) {
            this.checkActions(this.text, this.popup);
        }
    }

    private void checkActions(JTextComponent jTextComponent, TextPopup textPopup) {
        if (jTextComponent == null || textPopup == null) {
            return;
        }
        boolean bl = jTextComponent.isEditable();
        boolean bl2 = jTextComponent.getSelectionEnd() > jTextComponent.getSelectionStart();
        textPopup.getCutAction().setEnabled(bl && bl2);
        textPopup.getClearAction().setEnabled(bl && bl2);
        textPopup.getPasteAction().setEnabled(bl);
        textPopup.getCopyAction().setEnabled(bl2);
    }

    public void dispose() {
        WbMenu.disposeMenu(this.popup);
        if (this.text != null) {
            this.text.removeMouseListener(this);
        }
        this.text = null;
        this.additionalItems.clear();
    }
}

