/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import workbench.gui.renderer.ColorUtils;

public class ToggleIndicator
extends JPanel
implements MouseListener {
    private static final int UP = 1;
    private static final int DOWN = 2;
    private int height;
    private final int halfArrowWidth;
    private int direction;
    private Color arrowColor = Color.BLACK;
    boolean mouseOver = false;
    private final int[] yPointsUp = new int[3];
    private final int[] yPointsDown = new int[3];

    public ToggleIndicator() {
        this.addMouseListener(this);
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        this.height = Math.round((float)n / 16.0f);
        this.halfArrowWidth = this.height * 2;
        int n2 = 1;
        this.height += n2 * 2;
        this.direction = 2;
        this.yPointsDown[0] = n2;
        this.yPointsDown[1] = this.height - n2;
        this.yPointsDown[2] = n2;
        this.yPointsUp[0] = this.height - n2;
        this.yPointsUp[1] = n2;
        this.yPointsUp[2] = this.height - n2;
        Dimension dimension = new Dimension((int)((double)this.halfArrowWidth * 2.5), this.height);
        this.setMinimumSize(dimension);
        Dimension dimension2 = new Dimension(Integer.MAX_VALUE, this.height);
        this.setMaximumSize(dimension2);
    }

    public void setDirectionUp() {
        this.direction = 1;
        this.repaint();
    }

    public void setDirectionDown() {
        this.direction = 2;
        this.repaint();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.arrowColor = ColorUtils.blend(color, Color.BLACK, 132);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int[] nArray = new int[3];
        int n2 = n / 2;
        nArray[0] = n2 - this.halfArrowWidth;
        nArray[1] = n2;
        nArray[2] = n2 + this.halfArrowWidth;
        int[] nArray2 = this.direction == 2 ? this.yPointsDown : this.yPointsUp;
        Color color = this.getBackground();
        Color color2 = this.arrowColor;
        if (this.mouseOver) {
            color = color.darker();
            color2 = Color.BLACK;
        }
        graphics.setColor(color);
        graphics.fillRect(insets.left, insets.top, n - insets.right, this.height - insets.bottom);
        graphics.setColor(color2);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }
}

