/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class WbLineBorder
extends AbstractBorder {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    protected int type;
    protected int thickness;
    protected Color color;
    private Insets insets = new Insets(1, 1, 1, 1);

    public WbLineBorder(int n) {
        this(n, Color.LIGHT_GRAY);
    }

    public WbLineBorder(int n, Color color) {
        this.type = n;
        this.color = color;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.color);
        if ((this.type & 4) == 4) {
            graphics.drawLine(n, n2, n + n3, n2);
        }
        if ((this.type & 8) == 8) {
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
        if ((this.type & 1) == 1) {
            graphics.drawLine(n, n2, n, n2 + n4);
        }
        if ((this.type & 2) == 2) {
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return this.insets;
    }
}

