/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbMenuItem;
import workbench.interfaces.Disposable;
import workbench.util.NumberStringCache;

public class WbMenu
extends JMenu
implements Disposable {
    private String parentMenuId;
    private boolean createSeparator;

    public WbMenu(String string) {
        super(string);
    }

    public WbMenu(String string, int n) {
        String string2 = string;
        if (n < 10) {
            string2 = "&" + NumberStringCache.getNumberString(n) + " - " + string;
        }
        this.setText(string2);
    }

    public void setParentMenuId(String string) {
        this.parentMenuId = string;
    }

    public String getParentMenuId() {
        return this.parentMenuId;
    }

    public void setCreateMenuSeparator(boolean bl) {
        this.createSeparator = bl;
    }

    public boolean getCreateMenuSeparator() {
        return this.createSeparator;
    }

    @Override
    public void setText(String string) {
        int n = string.indexOf(38);
        if (n > -1) {
            char c = string.charAt(n + 1);
            string = string.substring(0, n) + string.substring(n + 1);
            this.setMnemonic(c);
        }
        super.setText(string);
    }

    @Override
    public void removeAll() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem instanceof WbMenuItem) {
                ((WbMenuItem)jMenuItem).dispose();
            }
            jMenuItem.removeAll();
        }
        super.removeAll();
    }

    @Override
    public void dispose() {
        WbSwingUtilities.removeAllListeners(this);
        this.itemListener = null;
        this.actionListener = null;
        this.changeListener = null;
        this.removeAll();
    }

    public static void disposeMenu(JPopupMenu jPopupMenu) {
        if (jPopupMenu == null) {
            return;
        }
        for (Component component : jPopupMenu.getComponents()) {
            if (component instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)component;
                Action action = jMenuItem.getAction();
                if (!(action instanceof WbAction)) continue;
                ((WbAction)action).dispose();
                continue;
            }
            if (!(component instanceof Container)) continue;
            ((Container)component).removeAll();
        }
        jPopupMenu.removeAll();
    }

    public List<WbAction> getAllActions() {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>();
        arrayList.addAll(this.getAllActions(this));
        return arrayList;
    }

    private List<WbAction> getAllActions(JMenuItem jMenuItem) {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>();
        for (Component component : jMenuItem.getComponents()) {
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem2 = (JMenuItem)component;
            Action action = jMenuItem2.getAction();
            if (action instanceof WbAction) {
                arrayList.add((WbAction)action);
                continue;
            }
            arrayList.addAll(this.getAllActions(jMenuItem2));
        }
        return arrayList;
    }
}

