/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbSplitPaneUI;
import workbench.gui.lnf.LnFHelper;
import workbench.gui.sql.SplitPaneExpander;
import workbench.resource.IconMgr;

public class WbSplitPane
extends JSplitPane {
    private SplitPaneExpander expander;

    public WbSplitPane() {
        this.initDefaults();
    }

    public WbSplitPane(int n) {
        super(n);
        this.initDefaults();
    }

    public WbSplitPane(int n, boolean bl) {
        super(n, bl);
        this.initDefaults();
    }

    public WbSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.initDefaults();
    }

    public WbSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        this.initDefaults();
    }

    @Override
    public void updateUI() {
        int n = this.getDividerSize();
        this.setDividerSize(n);
        super.setUI(this.getSplitPaneUI());
        this.revalidate();
    }

    private SplitPaneUI getSplitPaneUI() {
        if (LnFHelper.isWebLaf()) {
            try {
                Class<?> clazz = Class.forName("com.alee.laf.splitpane.WebSplitPaneUI");
                return (SplitPaneUI)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new WbSplitPaneUI();
    }

    @Override
    public void setUI(ComponentUI componentUI) {
        int n = this.getDividerSize();
        super.setUI(componentUI);
        this.setDividerSize(n);
    }

    public void setOneTouchTooltip(String string) {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof WbSplitPaneUI) {
            ((WbSplitPaneUI)splitPaneUI).setOneTouchTooltip(string);
        }
    }

    private void initDefaults() {
        int n;
        int n2 = IconMgr.getInstance().getSizeForLabel();
        switch (n2) {
            case 24: {
                n = 12;
                break;
            }
            case 32: {
                n = 14;
                break;
            }
            default: {
                n = 8;
            }
        }
        this.setDividerSize(n);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setContinuousLayout(true);
        this.expander = new SplitPaneExpander(this);
    }

    public SplitPaneExpander getExpander() {
        return this.expander;
    }

    public void setDividerBorder(Border border) {
        int n = this.getDividerSize();
        if (LnFHelper.isWebLaf()) {
            this.setDividerSize(this.dividerSize);
        } else {
            try {
                BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.getUI();
                BasicSplitPaneDivider basicSplitPaneDivider = basicSplitPaneUI.getDivider();
                basicSplitPaneDivider.setBorder(border);
                this.setDividerSize(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

