/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CopyAction;
import workbench.gui.actions.CopyAllColumnNamesAction;
import workbench.gui.actions.CopyAsDbUnitXMLAction;
import workbench.gui.actions.CopyAsSqlDeleteAction;
import workbench.gui.actions.CopyAsSqlDeleteInsertAction;
import workbench.gui.actions.CopyAsSqlInsertAction;
import workbench.gui.actions.CopyAsSqlMergeAction;
import workbench.gui.actions.CopyAsSqlUpdateAction;
import workbench.gui.actions.CopyAsTextAction;
import workbench.gui.actions.CopyColumnNameAction;
import workbench.gui.actions.CopySelectedAsDbUnitXMLAction;
import workbench.gui.actions.CopySelectedAsSqlDeleteAction;
import workbench.gui.actions.CopySelectedAsSqlDeleteInsertAction;
import workbench.gui.actions.CopySelectedAsSqlInsertAction;
import workbench.gui.actions.CopySelectedAsSqlMergeAction;
import workbench.gui.actions.CopySelectedAsSqlUpdateAction;
import workbench.gui.actions.CopySelectedAsTextAction;
import workbench.gui.actions.DisplayDataFormAction;
import workbench.gui.actions.FilterDataAction;
import workbench.gui.actions.OptimizeAllColumnsAction;
import workbench.gui.actions.OptimizeColumnWidthAction;
import workbench.gui.actions.OptimizeRowHeightAction;
import workbench.gui.actions.PrintAction;
import workbench.gui.actions.PrintPreviewAction;
import workbench.gui.actions.ResetColOrderAction;
import workbench.gui.actions.ResetFilterAction;
import workbench.gui.actions.ResetHighlightAction;
import workbench.gui.actions.SaveColOrderAction;
import workbench.gui.actions.SaveDataAsAction;
import workbench.gui.actions.ScrollToColumnAction;
import workbench.gui.actions.SetColumnWidthAction;
import workbench.gui.actions.SortAscendingAction;
import workbench.gui.actions.SortDescendingAction;
import workbench.gui.actions.TransposeRowAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.DbUnitHelper;
import workbench.gui.components.EmptyTableModel;
import workbench.gui.components.FocusIndicator;
import workbench.gui.components.KeyColumnSelectorPanel;
import workbench.gui.components.MultiLineToolTip;
import workbench.gui.components.RowHeightOptimizer;
import workbench.gui.components.RowHeightResizer;
import workbench.gui.components.RowHighlighter;
import workbench.gui.components.TableReplacer;
import workbench.gui.components.TableRowHeader;
import workbench.gui.components.UpdateTableSelector;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbCellEditor;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbPopupMenu;
import workbench.gui.components.WbTextCellEditor;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.fontzoom.DecreaseFontSize;
import workbench.gui.fontzoom.FontZoomProvider;
import workbench.gui.fontzoom.FontZoomer;
import workbench.gui.fontzoom.IncreaseFontSize;
import workbench.gui.fontzoom.ResetFontSize;
import workbench.gui.renderer.BlobColumnRenderer;
import workbench.gui.renderer.DateColumnRenderer;
import workbench.gui.renderer.HstoreEditor;
import workbench.gui.renderer.HstoreRenderer;
import workbench.gui.renderer.MapColumnRenderer;
import workbench.gui.renderer.NumberColumnRenderer;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.renderer.RequiredFieldHighlighter;
import workbench.gui.renderer.RowStatusRenderer;
import workbench.gui.renderer.SortHeaderRenderer;
import workbench.gui.renderer.StringColumnRenderer;
import workbench.gui.renderer.TextAreaRenderer;
import workbench.gui.renderer.ToolTipRenderer;
import workbench.gui.sql.DwStatusBar;
import workbench.interfaces.Disposable;
import workbench.interfaces.FontChangedListener;
import workbench.interfaces.ListSelectionControl;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.PlatformShortcuts;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataConverter;
import workbench.storage.DataStore;
import workbench.storage.NamedSortDefinition;
import workbench.storage.PkMapping;
import workbench.storage.ResultInfo;
import workbench.storage.SortDefinition;
import workbench.storage.filter.FilterExpression;
import workbench.storage.reader.RowDataReader;
import workbench.util.FileDialogUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbTable
extends JTable
implements ActionListener,
MouseListener,
FontChangedListener,
ListSelectionListener,
PropertyChangeListener,
Resettable,
FontZoomProvider {
    protected WbPopupMenu popup;
    private DataStoreTableModel dwModel;
    private int lastFoundRow = -1;
    protected WbTextCellEditor defaultEditor;
    private WbCellEditor multiLineEditor;
    private TableCellRenderer multiLineRenderer;
    private SortHeaderRenderer sortRenderer;
    private WbTextCellEditor defaultNumberEditor;
    private JTextField numberEditorTextField;
    protected SortAscendingAction sortAscending;
    protected SortDescendingAction sortDescending;
    protected OptimizeColumnWidthAction optimizeCol;
    protected OptimizeAllColumnsAction optimizeAllCol;
    private SetColumnWidthAction setColWidth;
    private TableReplacer replacer;
    private SaveDataAsAction saveDataAsAction;
    private CopyAsTextAction copyAsTextAction;
    private CopyAsSqlInsertAction copyInsertAction;
    private CopyAsDbUnitXMLAction copyDbUnitXMLAction;
    private CopyAsSqlMergeAction copyMergeAction;
    private CopyAsSqlDeleteInsertAction copyDeleteInsertAction;
    private CopyAsSqlDeleteAction copyDeleteAction;
    private CopyAsSqlUpdateAction copyUpdateAction;
    private CopySelectedAsTextAction copySelectedAsTextAction;
    private CopySelectedAsSqlMergeAction copySelectedAsMergeAction;
    private CopySelectedAsDbUnitXMLAction copySelectedAsDBUnitXMLAction;
    private CopySelectedAsSqlInsertAction copySelectedAsInsertAction;
    private CopySelectedAsSqlDeleteInsertAction copySelectedAsDeleteInsertAction;
    private CopySelectedAsSqlUpdateAction copySelectedAsUpdateAction;
    private CopySelectedAsSqlDeleteAction copySelectedDeleteAction;
    private ResetHighlightAction resetHighlightAction;
    private RowHighlighter highlightExpression;
    private TransposeRowAction transposeRow;
    private FilterDataAction filterAction;
    private ResetFilterAction resetFilterAction;
    private PrintAction printDataAction;
    private PrintPreviewAction printPreviewAction;
    private boolean adjustToColumnLabel;
    private int headerPopupX = -1;
    private Map<String, Integer> savedColumnSizes;
    private RowHeightResizer rowResizer;
    private List<TableModelListener> changeListener = new ArrayList<TableModelListener>();
    private JScrollPane scrollPane;
    private DwStatusBar statusBar;
    private String defaultPrintHeader;
    private boolean showPopup = true;
    private boolean selectOnRightButtonClick;
    private boolean highlightRequiredFields;
    private boolean useMultilineTooltip = true;
    private boolean rowHeightWasOptimized;
    private Color requiredColor;
    private boolean allowColumnOrderSaving;
    private boolean autoAdjustColumnWidths = GuiSettings.getAutomaticOptimalWidth();
    private boolean showFocusPending;
    private FocusIndicator focusIndicator;
    private ListSelectionControl selectionController;
    private boolean readOnly;
    protected FontZoomer zoomer;
    private RendererSetup rendererSetup = new RendererSetup();
    private boolean sortIgnoreCase;
    private FilterExpression lastFilter;
    private FilterExpression currentFilter;
    private Boolean lastRowHeaderState;

    public WbTable() {
        this(true, true, false);
    }

    public WbTable(boolean bl) {
        this(bl, true, false);
    }

    public WbTable(boolean bl, boolean bl2, boolean bl3) {
        super(EmptyTableModel.EMPTY_MODEL);
        Serializable serializable;
        Serializable serializable2;
        this.sortAscending = new SortAscendingAction(this);
        this.sortAscending.setEnabled(false);
        this.sortDescending = new SortDescendingAction(this);
        this.sortDescending.setEnabled(false);
        this.optimizeCol = new OptimizeColumnWidthAction(this);
        this.optimizeAllCol = new OptimizeAllColumnsAction(this);
        this.optimizeAllCol.setEnabled(true);
        this.setColWidth = new SetColumnWidthAction(this);
        this.setAutoCreateColumnsFromModel(true);
        this.defaultEditor = WbTextCellEditor.createInstance(this);
        this.numberEditorTextField = new JTextField();
        this.numberEditorTextField.setHorizontalAlignment(4);
        this.defaultNumberEditor = new WbTextCellEditor(this, this.numberEditorTextField);
        Font font = Settings.getInstance().getDataFont();
        if (font != null) {
            this.defaultEditor.setFont(font);
            this.numberEditorTextField.setFont(font);
            super.setFont(font);
        }
        this.multiLineEditor = new WbCellEditor(this);
        this.multiLineRenderer = new TextAreaRenderer();
        this.sortRenderer = new SortHeaderRenderer();
        this.setAutoResizeMode(0);
        this.replacer = new TableReplacer(this);
        this.copyAsTextAction = new CopyAsTextAction(this);
        this.saveDataAsAction = new SaveDataAsAction(this);
        this.saveDataAsAction.setEnabled(true);
        this.filterAction = new FilterDataAction(this, FilterDefinitionManager.getDefaultInstance());
        this.resetFilterAction = new ResetFilterAction(this);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.addPopupAction(this.saveDataAsAction, false);
        this.addPopupAction(this.copyAsTextAction, true);
        if (bl2) {
            serializable2 = WbTable.createCopyAsSQLMenu();
            this.copyInsertAction = new CopyAsSqlInsertAction(this);
            this.copyDeleteInsertAction = new CopyAsSqlDeleteInsertAction(this);
            this.copyDeleteAction = new CopyAsSqlDeleteAction(this);
            this.copyUpdateAction = new CopyAsSqlUpdateAction(this);
            this.copyMergeAction = new CopyAsSqlMergeAction(this);
            ((JMenu)serializable2).add(this.copyInsertAction);
            ((JMenu)serializable2).add(this.copyUpdateAction);
            ((JMenu)serializable2).add(this.copyMergeAction);
            ((JMenu)serializable2).add(this.copyDeleteInsertAction);
            ((JMenu)serializable2).add(this.copyDeleteAction);
            if (DbUnitHelper.isDbUnitAvailable()) {
                this.copyDbUnitXMLAction = new CopyAsDbUnitXMLAction(this);
                ((JMenu)serializable2).add(this.copyDbUnitXMLAction);
            }
            this.addPopupSubMenu((WbMenu)serializable2, false);
            serializable = this.getCopySelectedMenu();
            this.addPopupSubMenu((WbMenu)serializable, false);
        } else {
            this.copySelectedAsTextAction = new CopySelectedAsTextAction(this, "MnuTxtCopySelectedAsTextSingle");
            this.addPopupAction(this.copySelectedAsTextAction, false);
        }
        this.addPopupAction(this.replacer.getFindAction(), true);
        this.addPopupAction(this.replacer.getFindAgainAction(), false);
        this.resetHighlightAction = new ResetHighlightAction(this);
        if (bl3) {
            this.addPopupAction(this.replacer.getReplaceAction(), false);
        }
        this.addPopupAction(this.resetHighlightAction, false);
        serializable2 = this.getInputMap(0);
        serializable = this.getActionMap();
        this.zoomer = new FontZoomer(this);
        IncreaseFontSize increaseFontSize = new IncreaseFontSize(this.zoomer);
        increaseFontSize.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        DecreaseFontSize decreaseFontSize = new DecreaseFontSize(this.zoomer);
        decreaseFontSize.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        ResetFontSize resetFontSize = new ResetFontSize(this.zoomer);
        resetFontSize.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("TxtZoom"));
        wbMenu.add(increaseFontSize);
        wbMenu.add(decreaseFontSize);
        wbMenu.add(resetFontSize);
        this.addPopupSubMenu(wbMenu, true);
        if (bl) {
            this.printDataAction = new PrintAction(this);
            this.printPreviewAction = new PrintPreviewAction(this);
            this.popup.addSeparator();
            this.popup.add(this.printDataAction);
            this.popup.add(this.printPreviewAction);
        }
        this.addMouseListener(this);
        this.replacer.getFindAgainAction().addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        this.copyAsTextAction.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        this.saveDataAsAction.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        this.optimizeAllCol.addToInputMap((InputMap)serializable2, (ActionMap)serializable);
        Settings.getInstance().addFontChangedListener(this);
        Settings.getInstance().registerDateFormatChangeListener(this);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.fontzoom.mousewheel", new String[0]);
        this.initDefaultRenderers();
        this.initDefaultEditors();
        this.configureEnterKey();
        this.fixCopyShortcut();
    }

    public void setAutoAdjustColumnWidths(boolean bl) {
        this.autoAdjustColumnWidths = bl;
    }

    private void configureEnterKey() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WbTable.this.stopEditing();
            }
        };
        this.configureEnterKeyAction(abstractAction);
    }

    public void setShowDataTypeInHeader(boolean bl) {
        if (this.sortRenderer != null) {
            this.sortRenderer.setShowDatatype(bl);
        }
    }

    public void setShowRemarksInHeader(boolean bl) {
        if (this.sortRenderer != null) {
            this.sortRenderer.setShowRemarks(bl);
        }
    }

    public SortHeaderRenderer getHeaderRenderer() {
        return this.sortRenderer;
    }

    public boolean getSortIgnoreCase() {
        return this.sortIgnoreCase;
    }

    public void setSortIgnoreCase(boolean bl) {
        this.sortIgnoreCase = bl;
    }

    public void configureEnterKeyAction(Action action) {
        this.getInputMap(0).put(WbSwingUtilities.ENTER, "wbtable-stop-editing");
        this.getInputMap(1).put(WbSwingUtilities.ENTER, "wbtable-stop-editing");
        this.getActionMap().put("wbtable-stop-editing", action);
    }

    private void fixCopyShortcut() {
        CopyAction copyAction;
        KeyStroke keyStroke;
        InputMap inputMap = this.getInputMap(1);
        Object object = inputMap.get(keyStroke = (copyAction = new CopyAction(null)).getAccelerator());
        if (object != null) {
            return;
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 2);
        object = inputMap.get(keyStroke2);
        if (object != null) {
            inputMap.put(keyStroke, object);
        }
    }

    public int getColumnIndex(String string) {
        int n = this.getDataStoreTableModel().findColumn(string);
        if (n < 0) {
            return -1;
        }
        return this.convertColumnIndexToView(n);
    }

    public void setTransposeRowEnabled(boolean bl) {
        if (bl && this.transposeRow == null) {
            this.transposeRow = new TransposeRowAction(this);
            this.addPopupActionAfter(this.transposeRow, this.resetHighlightAction);
        }
        if (!bl && this.transposeRow != null) {
            int n = this.findPopupItem(this.transposeRow);
            if (n > -1) {
                this.popup.remove(n);
            }
            this.transposeRow = null;
        }
    }

    @Override
    public FontZoomer getFontZoomer() {
        return this.zoomer;
    }

    public void setAllowEditMode(boolean bl) {
        DataStoreTableModel dataStoreTableModel = this.getDataStoreTableModel();
        if (dataStoreTableModel != null) {
            dataStoreTableModel.setAllowEditMode(bl);
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        DataStoreTableModel dataStoreTableModel = this.getDataStoreTableModel();
        if (dataStoreTableModel != null) {
            dataStoreTableModel.setAllowEditing(!this.readOnly);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RendererSetup getRendererSetup() {
        return this.rendererSetup;
    }

    public void setRendererSetup(RendererSetup rendererSetup) {
        this.rendererSetup = rendererSetup;
    }

    public void setModifiedColor(Color color) {
        this.rendererSetup.setModifiedColor(color);
    }

    public void setColumnOrderSavingEnabled(boolean bl) {
        this.allowColumnOrderSaving = bl;
    }

    public void showInputFormAction() {
        if (this.popup == null) {
            return;
        }
        DisplayDataFormAction displayDataFormAction = new DisplayDataFormAction(this);
        this.popup.insert(displayDataFormAction.getMenuItem(), 0);
        displayDataFormAction.addToInputMap(this);
    }

    public void setListSelectionControl(ListSelectionControl listSelectionControl) {
        this.selectionController = listSelectionControl;
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (this.selectionController != null) {
            bl3 = this.selectionController.canChangeSelection();
        }
        if (bl3) {
            super.changeSelection(n, n2, bl, bl2);
        }
    }

    public void showFocusBorder() {
        if (this.scrollPane == null) {
            this.showFocusPending = true;
        } else if (this.focusIndicator != null) {
            this.focusIndicator.dispose();
        } else {
            this.focusIndicator = new FocusIndicator(this, this.scrollPane);
        }
    }

    public void setShowPopupMenu(boolean bl) {
        this.showPopup = bl;
    }

    public void setRowResizeAllowed(boolean bl) {
        if (bl && this.rowResizer == null) {
            this.rowResizer = new RowHeightResizer(this);
        } else if (!bl) {
            if (this.rowResizer != null) {
                this.rowResizer.done();
            }
            this.rowResizer = null;
        }
    }

    public void setStatusBar(DwStatusBar dwStatusBar) {
        this.statusBar = dwStatusBar;
    }

    @Override
    public void setFont(Font font) {
        TableRowHeader tableRowHeader;
        super.setFont(font);
        if (this.tableHeader != null) {
            this.tableHeader.setFont(font);
        }
        if (this.defaultEditor != null) {
            this.defaultEditor.setFont(font);
        }
        if (this.multiLineEditor != null) {
            this.multiLineEditor.setFont(font);
        }
        if (this.defaultNumberEditor != null) {
            this.defaultNumberEditor.setFont(font);
        }
        if ((tableRowHeader = TableRowHeader.getRowHeader(this)) != null) {
            tableRowHeader.setFont(font);
        }
        this.adjustRowsAndColumns();
    }

    public void adjustRowHeight() {
        if (this.rowHeightWasOptimized || GuiSettings.getAutomaticOptimalRowHeight()) {
            this.optimizeRowHeight();
        } else {
            this.calculateGlobalRowHeight();
        }
    }

    private void calculateGlobalRowHeight() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = null;
        if (graphics != null) {
            try {
                fontMetrics = graphics.getFontMetrics(font);
            }
            catch (Throwable throwable) {
                fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            }
        } else {
            fontMetrics = this.getFontMetrics(font);
        }
        if (fontMetrics != null) {
            this.setRowHeight(fontMetrics.getHeight() + 2);
            TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(this);
            if (tableRowHeader != null) {
                tableRowHeader.rowHeightChanged();
            }
        }
    }

    public void useMultilineTooltip(boolean bl) {
        this.useMultilineTooltip = bl;
    }

    @Override
    public JToolTip createToolTip() {
        if (this.useMultilineTooltip) {
            MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
            multiLineToolTip.setComponent(this);
            return multiLineToolTip;
        }
        return super.createToolTip();
    }

    public FilterDataAction getFilterAction() {
        return this.filterAction;
    }

    public ResetFilterAction getResetFilterAction() {
        return this.resetFilterAction;
    }

    public void populateCopySelectedMenu(WbMenu wbMenu) {
        if (this.copySelectedAsTextAction == null) {
            this.copySelectedAsTextAction = new CopySelectedAsTextAction(this);
        }
        if (this.copySelectedAsDBUnitXMLAction == null && DbUnitHelper.isDbUnitAvailable()) {
            this.copySelectedAsDBUnitXMLAction = new CopySelectedAsDbUnitXMLAction(this);
        }
        if (this.copySelectedAsInsertAction == null && this.copyInsertAction != null) {
            this.copySelectedAsInsertAction = new CopySelectedAsSqlInsertAction(this);
        }
        if (this.copySelectedAsMergeAction == null && this.copyMergeAction != null) {
            this.copySelectedAsMergeAction = new CopySelectedAsSqlMergeAction(this);
        }
        if (this.copySelectedAsDeleteInsertAction == null && this.copyDeleteInsertAction != null) {
            this.copySelectedAsDeleteInsertAction = new CopySelectedAsSqlDeleteInsertAction(this);
        }
        if (this.copySelectedDeleteAction == null && this.copyDeleteAction != null) {
            this.copySelectedDeleteAction = new CopySelectedAsSqlDeleteAction(this);
        }
        if (this.copySelectedAsUpdateAction == null && this.copyUpdateAction != null) {
            this.copySelectedAsUpdateAction = new CopySelectedAsSqlUpdateAction(this);
        }
        wbMenu.add(this.copySelectedAsTextAction);
        if (this.copySelectedAsInsertAction != null) {
            wbMenu.add(this.copySelectedAsInsertAction);
        }
        if (this.copySelectedAsUpdateAction != null) {
            wbMenu.add(this.copySelectedAsUpdateAction);
        }
        if (this.copySelectedAsMergeAction != null) {
            wbMenu.add(this.copySelectedAsMergeAction);
        }
        if (this.copySelectedAsDeleteInsertAction != null) {
            wbMenu.add(this.copySelectedAsDeleteInsertAction);
        }
        if (this.copySelectedDeleteAction != null) {
            wbMenu.add(this.copySelectedDeleteAction);
        }
        if (this.copySelectedAsDBUnitXMLAction != null) {
            wbMenu.add(this.copySelectedAsDBUnitXMLAction);
        }
    }

    public final WbMenu getCopySelectedMenu() {
        WbMenu wbMenu = WbTable.createCopySelectedMenu();
        this.populateCopySelectedMenu(wbMenu);
        return wbMenu;
    }

    public static WbMenu createCopyAsSQLMenu() {
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtCopyAsSQL"));
        wbMenu.setParentMenuId("MnuTxtData");
        return wbMenu;
    }

    public static WbMenu createCopySelectedMenu() {
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtCopySelected"));
        wbMenu.setParentMenuId("MnuTxtData");
        return wbMenu;
    }

    public CopyAsSqlInsertAction getCopyAsInsertAction() {
        return this.copyInsertAction;
    }

    public CopyAsSqlDeleteInsertAction getCopyAsDeleteInsertAction() {
        return this.copyDeleteInsertAction;
    }

    public CopyAsSqlDeleteAction getCopyAsDeleteAction() {
        return this.copyDeleteAction;
    }

    public CopyAsSqlMergeAction getCopyAsSqlMergeAction() {
        return this.copyMergeAction;
    }

    public CopyAsSqlUpdateAction getCopyAsUpdateAction() {
        return this.copyUpdateAction;
    }

    public SaveDataAsAction getExportAction() {
        return this.saveDataAsAction;
    }

    public CopyAsTextAction getDataToClipboardAction() {
        return this.copyAsTextAction;
    }

    public TableReplacer getReplacer() {
        return this.replacer;
    }

    public void setSelectOnRightButtonClick(boolean bl) {
        this.selectOnRightButtonClick = bl;
    }

    public void dispose() {
        if (this.changeListener != null && this.dwModel != null) {
            for (TableModelListener tableModelListener : this.changeListener) {
                this.dwModel.removeTableModelListener(tableModelListener);
            }
            this.changeListener.clear();
        }
        WbSwingUtilities.removeAllListeners(this);
        this.reset();
        if (this.rowResizer != null) {
            this.rowResizer.done();
            this.rowResizer = null;
        }
        if (this.popup != null) {
            this.popup.removeAll();
            this.popup = null;
        }
        WbAction.dispose(this.copySelectedAsTextAction, this.copySelectedAsInsertAction, this.copySelectedAsMergeAction, this.copySelectedAsUpdateAction, this.copySelectedAsDeleteInsertAction, this.copySelectedDeleteAction, this.copySelectedAsDBUnitXMLAction, this.copyDbUnitXMLAction, this.copyInsertAction, this.copyDeleteInsertAction, this.copyDeleteAction, this.copyMergeAction, this.copyUpdateAction, this.saveDataAsAction, this.copyAsTextAction, this.filterAction, this.resetFilterAction, this.resetHighlightAction, this.optimizeAllCol, this.optimizeCol, this.printDataAction, this.printPreviewAction, this.setColWidth, this.sortAscending, this.sortDescending, this.transposeRow);
        Settings.getInstance().removePropertyChangeListener(this.sortRenderer);
        WbSwingUtilities.removeAllListeners(this);
        this.defaultEditor.dispose();
        this.multiLineEditor.dispose();
        this.defaultNumberEditor.dispose();
    }

    @Override
    public void reset() {
        this.cancelEditing();
        this.rowHeightWasOptimized = false;
        TableRowHeader.removeRowHeader(this);
        if (this.getModel() == EmptyTableModel.EMPTY_MODEL) {
            return;
        }
        this.setModel(EmptyTableModel.EMPTY_MODEL, false);
    }

    public void addMacroMenu(WbMenu wbMenu) {
        WbSwingUtilities.invoke(() -> this._addMacroMenu(wbMenu));
    }

    private void _addMacroMenu(WbMenu wbMenu) {
        if (wbMenu == null) {
            return;
        }
        if (this.popup == null) {
            return;
        }
        this.removeMacroMenu();
        int n = this.findPopupItem(this.transposeRow);
        if (n > -1) {
            this.popup.add((Component)wbMenu, n + 1);
        } else {
            this.popup.addSeparator();
            this.popup.add(wbMenu);
        }
    }

    private void removeMacroMenu() {
        if (this.popup == null) {
            return;
        }
        int n = this.popup.getComponentCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenuItem) || !StringUtil.equalString((jMenuItem = (JMenuItem)component).getName(), "macroDataMenu")) continue;
            n2 = i;
            break;
        }
        if (n2 > -1) {
            this.popup.remove(n2);
        }
    }

    private void addPopupSubMenu(WbMenu wbMenu, boolean bl) {
        WbSwingUtilities.invoke(() -> {
            if (this.popup == null) {
                this.popup = new WbPopupMenu();
            }
            if (bl) {
                this.popup.addSeparator();
            }
            this.popup.add(wbMenu);
        });
    }

    private int findPopupItem(WbAction wbAction) {
        if (wbAction == null) {
            return -1;
        }
        if (this.popup == null) {
            return -1;
        }
        int n = this.popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenuItem) || (jMenuItem = (JMenuItem)component).getAction() != wbAction) continue;
            return i;
        }
        return -1;
    }

    public void addPopupActionAfter(WbAction wbAction, WbAction wbAction2) {
        if (this.popup == null) {
            return;
        }
        int n = this.findPopupItem(wbAction2);
        if (n == -1) {
            return;
        }
        WbSwingUtilities.invoke(() -> this.popup.add((Component)wbAction.getMenuItem(), n + 1));
    }

    public void removeSubmenu(JMenuItem jMenuItem) {
        int n = this.popup.getComponentIndex(jMenuItem);
        if (n > 0) {
            Component component;
            Component component2 = component = n > 0 ? this.popup.getComponent(n - 1) : null;
            if (component instanceof JSeparator) {
                this.popup.remove(component);
            }
            this.popup.remove(jMenuItem);
        }
    }

    public void removePopupAction(WbAction wbAction) {
        if (this.popup == null) {
            return;
        }
        int n = this.findPopupItem(wbAction);
        if (n > -1) {
            Component component;
            Component component2 = this.popup.getComponent(n);
            Component component3 = component = n > 0 ? this.popup.getComponent(n - 1) : null;
            if (component instanceof JSeparator) {
                this.popup.remove(component);
            }
            this.popup.remove(component2);
        }
    }

    public final void addPopupAction(WbAction wbAction, boolean bl) {
        this.addPopupMenu(wbAction.getMenuItem(), bl);
    }

    public void addPopupMenu(JMenuItem jMenuItem, boolean bl) {
        WbSwingUtilities.invoke(() -> {
            if (this.popup == null) {
                this.popup = new WbPopupMenu();
            }
            if (this.printDataAction != null) {
                if (bl) {
                    this.popup.add((Component)new JPopupMenu.Separator(), this.popup.getComponentCount() - 3);
                }
                this.popup.add((Component)jMenuItem, this.popup.getComponentCount() - 3);
            } else {
                if (bl) {
                    this.popup.addSeparator();
                }
                this.popup.add(jMenuItem);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl2 = bl = this.getSelectedRowCount() > 0;
        if (this.copySelectedAsTextAction != null) {
            this.copySelectedAsTextAction.setEnabled(bl);
        }
        if (this.copySelectedAsDBUnitXMLAction != null) {
            this.copySelectedAsDBUnitXMLAction.setEnabled(bl);
        }
        if (this.copySelectedAsInsertAction != null) {
            this.copySelectedAsInsertAction.setEnabled(bl);
        }
        if (this.copySelectedAsMergeAction != null) {
            this.copySelectedAsMergeAction.setEnabled(bl);
        }
        if (this.copySelectedAsUpdateAction != null) {
            this.copySelectedAsUpdateAction.setEnabled(bl);
        }
        if (this.copySelectedAsDeleteInsertAction != null) {
            this.copySelectedAsDeleteInsertAction.setEnabled(bl);
        }
        if (this.copySelectedDeleteAction != null) {
            this.copySelectedDeleteAction.setEnabled(bl);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)container;
            JViewport jViewport = this.scrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                this.scrollPane = null;
            }
        }
        if (this.showFocusPending && this.scrollPane != null) {
            this.showFocusPending = false;
            this.showFocusBorder();
        }
        this.checkMouseListener();
        this.initWheelZoom();
    }

    private void initWheelZoom() {
        if (this.scrollPane == null || this.zoomer == null) {
            return;
        }
        if (GuiSettings.getZoomFontWithMouseWheel()) {
            this.scrollPane.addMouseWheelListener(this.zoomer);
        } else {
            this.scrollPane.removeMouseWheelListener(this.zoomer);
        }
    }

    private void checkMouseListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        MouseListener[] mouseListenerArray = jTableHeader.getMouseListeners();
        if (mouseListenerArray == null) {
            jTableHeader.addMouseListener(this);
            return;
        }
        for (MouseListener mouseListener : mouseListenerArray) {
            if (mouseListener != this) continue;
            return;
        }
        jTableHeader.addMouseListener(this);
    }

    public void setPrintHeader(String string) {
        this.defaultPrintHeader = string;
    }

    public String getPrintHeader() {
        return this.defaultPrintHeader;
    }

    @Override
    public Color getBackground() {
        Color color = Settings.getInstance().getColor("workbench.gui.table.background", null);
        return color == null ? super.getBackground() : color;
    }

    @Override
    public Color getForeground() {
        Color color = Settings.getInstance().getColor("workbench.gui.table.foreground", null);
        return color == null ? super.getForeground() : color;
    }

    @Override
    public Color getSelectionBackground() {
        Color color = Settings.getInstance().getColor("workbench.gui.table.selection.background", null);
        return color == null ? super.getSelectionBackground() : color;
    }

    @Override
    public Color getSelectionForeground() {
        Color color = Settings.getInstance().getColor("workbench.gui.table.selection.foreground", null);
        return color == null ? super.getSelectionForeground() : color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = true;
        try {
            boolean bl3;
            int n2 = PlatformShortcuts.getDefaultModifier();
            int n3 = keyEvent.getModifiers();
            boolean bl4 = bl3 = (n3 & 8) == 8 || (n3 & n2) == n2;
            if (bl3) {
                this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            } else if (keyStroke.getKeyCode() == 127 && GuiSettings.enableMultiColumnDelete()) {
                int[] nArray = this.getSelectedColumns();
                int[] nArray2 = this.getSelectedRows();
                if (nArray2 != null && nArray != null && nArray.length > 1) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        for (int j = 0; j < nArray.length; ++j) {
                            this.setValueAt(null, nArray2[i], nArray[j]);
                        }
                    }
                }
            }
            bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        finally {
            this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        }
        return bl2;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (!this.highlightRequiredFields) {
            return component;
        }
        ResultInfo resultInfo = this.getDataStore().getResultInfo();
        int n3 = n2;
        if (this.dwModel.isStatusColumnVisible()) {
            n3 = n2 - 1;
        }
        boolean bl = resultInfo.isNullable(n3);
        if (tableCellEditor == this.defaultEditor || tableCellEditor == this.defaultNumberEditor) {
            WbTextCellEditor wbTextCellEditor = (WbTextCellEditor)tableCellEditor;
            if (bl) {
                wbTextCellEditor.setBackground(wbTextCellEditor.getDefaultBackground());
            } else {
                wbTextCellEditor.setBackground(this.requiredColor);
            }
        }
        return component;
    }

    public void selectCell(int n, int n2) {
        this.scrollToRow(n);
        Rectangle rectangle = this.getCellRect(n, n2, true);
        this.setColumnSelectionAllowed(true);
        this.scrollRectToVisible(rectangle);
        this.setRowSelectionInterval(n, n);
        this.setColumnSelectionInterval(n2, n2);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            if (this.highlightRequiredFields) {
                this.initRendererHighlight(n);
            }
            EventQueue.invokeLater(this::clearSelection);
        }
        return bl;
    }

    protected void initRendererHighlight(int n) {
        int n2;
        ResultInfo resultInfo = this.getDataStore().getResultInfo();
        int n3 = 0;
        int n4 = this.getColumnCount();
        if (this.dwModel.isStatusColumnVisible()) {
            n3 = 1;
        }
        boolean[] blArray = new boolean[n4];
        for (n2 = 0; n2 < resultInfo.getColumnCount(); ++n2) {
            boolean bl = resultInfo.isNullable(n2);
            blArray[n2 + n3] = !bl;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
            if (!(tableCellRenderer instanceof RequiredFieldHighlighter)) continue;
            RequiredFieldHighlighter requiredFieldHighlighter = (RequiredFieldHighlighter)((Object)tableCellRenderer);
            requiredFieldHighlighter.setHighlightBackground(this.requiredColor);
            requiredFieldHighlighter.setEditingRow(n);
            requiredFieldHighlighter.setHighlightColumns(blArray);
        }
    }

    @Override
    public void removeEditor() {
        int n = this.getEditingRow();
        int n2 = this.getEditingColumn();
        TableCellEditor tableCellEditor = this.getCellEditor();
        super.removeEditor();
        if (tableCellEditor instanceof Disposable) {
            ((Disposable)((Object)tableCellEditor)).dispose();
        }
        this.resetHighlightRenderers(n);
        this.requestFocusInWindow();
        this.changeSelection(n, -1, false, false);
        this.changeSelection(n, n2, false, false);
    }

    private void resetHighlightRenderers(int n) {
        if (!this.highlightRequiredFields) {
            return;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n, i);
            if (!(tableCellRenderer instanceof RequiredFieldHighlighter)) continue;
            RequiredFieldHighlighter requiredFieldHighlighter = (RequiredFieldHighlighter)((Object)tableCellRenderer);
            requiredFieldHighlighter.setEditingRow(-1);
            requiredFieldHighlighter.setHighlightBackground(null);
            requiredFieldHighlighter.setHighlightColumns(null);
        }
    }

    private void removeListeners() {
        if (this.dwModel == null) {
            return;
        }
        for (TableModelListener tableModelListener : this.changeListener) {
            this.dwModel.removeTableModelListener(tableModelListener);
        }
    }

    private void addListeners() {
        if (this.dwModel == null) {
            return;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.dwModel);
        for (TableModelListener tableModelListener : this.changeListener) {
            tableModelListener.tableChanged(tableModelEvent);
            this.dwModel.addTableModelListener(tableModelListener);
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.setModel(tableModel, false);
    }

    public void setModel(TableModel tableModel, boolean bl) {
        Serializable serializable;
        if (!SwingUtilities.isEventDispatchThread()) {
            serializable = new Exception("Wrong thread!");
            LogMgr.logWarning(new CallerInfo(){}, "setModel() not called in EDT!", (Throwable)serializable);
        }
        this.removeListeners();
        this.rowHeightWasOptimized = false;
        serializable = this.getTableHeader();
        if (serializable != null) {
            ((Component)serializable).removeMouseListener(this);
        }
        if (this.dwModel != null) {
            this.dwModel.dispose();
            this.dwModel = null;
        }
        try {
            super.setModel(tableModel);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error setting table model", throwable);
        }
        this.currentFilter = null;
        if (tableModel instanceof DataStoreTableModel) {
            this.dwModel = (DataStoreTableModel)tableModel;
            if (bl && serializable != null) {
                ((Component)serializable).addMouseListener(this);
            }
            this.dwModel.setSortIgnoreCase(this.sortIgnoreCase);
        }
        if (tableModel != EmptyTableModel.EMPTY_MODEL) {
            if (this.sortAscending != null) {
                this.sortAscending.setEnabled(bl);
            }
            if (this.sortDescending != null) {
                this.sortDescending.setEnabled(bl);
            }
            this.initDefaultRenderers();
            this.initDefaultEditors();
        }
        this.addListeners();
        this.adjustRowsAndColumns();
        this.updateSortRenderer();
        this.checkCopyActions();
    }

    public boolean isColumnOrderChanged() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = tableColumnModel.getColumn(i).getModelIndex();
            if (n2 >= n || i == n2) continue;
            return true;
        }
        return false;
    }

    public void clearLastFilter(boolean bl) {
        if (bl && this.lastFilter != null && !this.lastFilter.isColumnSpecific()) {
            return;
        }
        this.lastFilter = null;
    }

    protected boolean saveRowHeaderState() {
        this.lastRowHeaderState = TableRowHeader.isRowHeaderVisible(this);
        if (this.lastRowHeaderState.booleanValue()) {
            TableRowHeader.removeRowHeader(this);
        }
        return this.lastRowHeaderState;
    }

    protected void restoreRowHeaderState() {
        if (this.lastRowHeaderState == null) {
            return;
        }
        if (this.lastRowHeaderState.booleanValue()) {
            TableRowHeader.showRowHeader(this);
        }
        this.lastRowHeaderState = null;
    }

    public void resetFilter() {
        this.currentFilter = null;
        if (this.dwModel == null) {
            return;
        }
        try {
            this.saveRowHeaderState();
            this.dwModel.resetFilter();
            this.adjustRowsAndColumns();
        }
        finally {
            this.restoreRowHeaderState();
        }
    }

    public FilterExpression getLastFilter() {
        return this.lastFilter;
    }

    public boolean isFiltered() {
        return this.currentFilter != null;
    }

    public void applyFilter(FilterExpression filterExpression) {
        this.applyFilter(filterExpression, true);
    }

    public void applyFilter(FilterExpression filterExpression, boolean bl) {
        if (this.dwModel == null) {
            return;
        }
        this.cancelEditing();
        this.lastFilter = filterExpression;
        this.currentFilter = filterExpression;
        this.dwModel.applyFilter(filterExpression);
        if (bl) {
            this.adjustRowsAndColumns();
        }
        WbSwingUtilities.repaintLater(this.getParent());
    }

    public SortDefinition getCurrentSortColumns() {
        if (this.dwModel == null) {
            return null;
        }
        return this.dwModel.getSortColumns();
    }

    public NamedSortDefinition getCurrentSort() {
        if (this.dwModel == null) {
            return null;
        }
        return this.dwModel.getSortDefinition();
    }

    public DataStoreTableModel getDataStoreTableModel() {
        return this.dwModel;
    }

    public DataStore getDataStore() {
        if (this.dwModel != null) {
            return this.dwModel.getDataStore();
        }
        return null;
    }

    public Object restoreColumnValue(int n, int n2) {
        int n3 = n2 - this.getDataStoreTableModel().getRealColumnStart();
        return this.getDataStore().restoreColumnValue(n, n3);
    }

    public void restoreOriginalValues() {
        if (this.dwModel == null) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            boolean bl = this.dwModel.getDataStore().restoreOriginalValues();
            if (bl) {
                this.dwModel.fireTableDataChanged();
            }
        });
    }

    public PrintPreviewAction getPrintPreviewAction() {
        return this.printPreviewAction;
    }

    public PrintAction getPrintAction() {
        return this.printDataAction;
    }

    public String getValueAsString(int n, int n2) throws IndexOutOfBoundsException {
        Object object = this.getValueAt(n, this.convertColumnIndexToView(n2));
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Object getUserObject(int n) {
        if (this.dwModel == null) {
            return null;
        }
        return this.dwModel.getDataStore().getRow(n).getUserObject();
    }

    public boolean isStatusColumnVisible() {
        if (this.dwModel == null) {
            return false;
        }
        return this.dwModel.isStatusColumnVisible();
    }

    public void setAdjustToColumnLabel(boolean bl) {
        this.adjustToColumnLabel = bl;
    }

    public void showStatusColumn() {
        this.setStatusColumnVisible(true);
    }

    public void hideStatusColumn() {
        this.setStatusColumnVisible(false);
    }

    public void addColumn(ColumnIdentifier columnIdentifier, int n) {
        if (this.getColumnIndex(columnIdentifier.getColumnName()) > -1) {
            return;
        }
        WbSwingUtilities.invoke(() -> this._addColumn(columnIdentifier, n));
    }

    private void _addColumn(ColumnIdentifier columnIdentifier, int n) {
        if (this.dwModel == null) {
            return;
        }
        this.saveColumnSizes();
        NamedSortDefinition namedSortDefinition = this.dwModel.getSortDefinition();
        this.dwModel.addColumn(columnIdentifier, n);
        this.afterColumnChange();
        this.dwModel.setSortDefinition(namedSortDefinition);
    }

    private boolean isContinous(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        return n + nArray.length - 1 == n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSelection(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.getSelectedRows();
        if (Arrays.equals(nArray, nArray2)) {
            return;
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        try {
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel.clearSelection();
            if (this.isContinous(nArray)) {
                listSelectionModel.addSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            } else {
                for (int n : nArray) {
                    listSelectionModel.addSelectionInterval(n, n);
                }
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private void setStatusColumnVisible(boolean bl) {
        if (bl == this.dwModel.isStatusColumnVisible()) {
            return;
        }
        WbSwingUtilities.invoke(() -> this._setShowStatusColumn(bl));
    }

    private void _setShowStatusColumn(boolean bl) {
        Object object;
        if (this.dwModel == null) {
            return;
        }
        int n = this.getSelectedColumn();
        int n2 = this.getSelectedRow();
        this.saveColumnSizes();
        this.dwModel.setStatusColumnVisible(bl);
        if (bl) {
            object = this.getColumnModel().getColumn(0);
            ((TableColumn)object).setCellRenderer(new RowStatusRenderer());
            ((TableColumn)object).setMaxWidth(20);
            ((TableColumn)object).setMinWidth(20);
            ((TableColumn)object).setPreferredWidth(20);
        } else {
            object = this.getTableHeader().getColumnModel();
            if (object.getColumnCount() > this.dwModel.getColumnCount()) {
                TableColumn tableColumn = object.getColumn(0);
                object.removeColumn(tableColumn);
            }
        }
        int n3 = bl ? n + 1 : n - 1;
        this.afterColumnChange();
        if (n2 >= 0 && n3 >= 0) {
            EventQueue.invokeLater(() -> {
                this.changeSelection(n2, -1, false, false);
                this.changeSelection(n2, n3, false, true);
            });
        }
    }

    private void afterColumnChange() {
        this.initTypeSpecificRenderer();
        this.initDefaultEditors();
        this.restoreColumnSizes();
        this.adjustRowHeight();
        this.updateSortRenderer();
    }

    public boolean isPrimarySortColumn(int n) {
        if (this.dwModel == null) {
            return false;
        }
        int n2 = this.convertColumnIndexToModel(n);
        return this.dwModel.isPrimarySortColumn(n2);
    }

    public boolean isViewColumnSorted(int n) {
        if (this.dwModel == null) {
            return false;
        }
        int n2 = this.convertColumnIndexToModel(n);
        return this.dwModel.isSortColumn(n2);
    }

    public boolean isViewColumnSortAscending(int n) {
        if (this.dwModel == null) {
            return true;
        }
        int n2 = this.convertColumnIndexToModel(n);
        return this.dwModel.isSortAscending(n2);
    }

    public void sortingStarted() {
        JComponent jComponent = this.scrollPane == null ? this : this.scrollPane;
        WbSwingUtilities.invoke(() -> {
            this.updateSortRenderer();
            WbSwingUtilities.showWaitCursor(jComponent.getParent());
        });
    }

    protected void updateSortRenderer() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel == null) {
            return;
        }
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            try {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn == null) continue;
                tableColumn.setHeaderRenderer(this.sortRenderer);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void sortingFinished() {
        JComponent jComponent = this.scrollPane == null ? this : this.scrollPane;
        EventQueue.invokeLater(() -> {
            this.adjustRowHeight();
            if (GuiSettings.getAutomaticOptimalWidth() && GuiSettings.getIncludeHeaderInOptimalWidth()) {
                ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this);
                columnWidthOptimizer.optimizeHeader();
            }
            WbSwingUtilities.showDefaultCursor(jComponent.getParent());
            WbSwingUtilities.showDefaultCursor(this.getTableHeader());
            this.getTableHeader().repaint();
        });
    }

    public boolean canSearchAgain() {
        return this.lastFoundRow >= 0;
    }

    public void saveColumnSizes() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        this.savedColumnSizes = new HashMap<String, Integer>();
        int n2 = 0;
        if (this.dwModel.isStatusColumnVisible()) {
            n2 = 1;
        }
        for (int i = n2; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            String string = this.getColumnName(i);
            this.savedColumnSizes.put(string, tableColumn.getPreferredWidth());
        }
    }

    public void applyColumnWidths(int[] nArray) {
        if (nArray == null) {
            return;
        }
        if (nArray.length != this.getColumnCount()) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setWidth(nArray[i]);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    public void restoreColumnSizes() {
        if (this.savedColumnSizes == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.savedColumnSizes.entrySet()) {
            TableColumn tableColumn = this.getColumn(entry.getKey());
            if (tableColumn == null) continue;
            int n = entry.getValue();
            tableColumn.setPreferredWidth(n);
        }
        this.savedColumnSizes = null;
    }

    private void initDateRenderers() {
        Settings settings = Settings.getInstance();
        boolean bl = settings.useVariableLengthTimeFractions();
        DateColumnRenderer dateColumnRenderer = new DateColumnRenderer(settings.getDefaultDateFormat(), false);
        this.setDefaultRenderer(java.sql.Date.class, dateColumnRenderer);
        this.setDefaultRenderer(Date.class, dateColumnRenderer);
        DateColumnRenderer dateColumnRenderer2 = new DateColumnRenderer(settings.getDefaultTimestampFormat(), bl);
        this.setDefaultRenderer(Timestamp.class, dateColumnRenderer2);
        this.setDefaultRenderer(LocalDateTime.class, dateColumnRenderer2);
        this.setDefaultRenderer(ZonedDateTime.class, dateColumnRenderer2);
        this.setDefaultRenderer(Time.class, new DateColumnRenderer(settings.getDefaultTimeFormat(), bl));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("workbench.gui.fontzoom.mousewheel")) {
            this.initWheelZoom();
        } else if (Settings.getInstance().isDateFormatProperty(propertyChangeEvent.getPropertyName())) {
            this.initDateRenderers();
        }
    }

    @Override
    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.initDefaultRenderers();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = null;
        tableCellRenderer = this.isBlobColumn(n2) ? new BlobColumnRenderer() : super.getCellRenderer(n, n2);
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(Object.class);
        }
        return tableCellRenderer;
    }

    public boolean isBlobColumn(int n) {
        if (this.dwModel == null) {
            return false;
        }
        int n2 = this.dwModel.getColumnType(n);
        if (SqlUtil.isBlobType(n2)) {
            String string = this.dwModel.getDbmsType(n);
            try {
                DataConverter dataConverter = RowDataReader.getConverterInstance(this.getDataStore().getOriginalConnection());
                return dataConverter == null || !dataConverter.convertsType(n2, string);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error checking for converted blob", throwable);
                return true;
            }
        }
        return false;
    }

    private void initDefaultRenderers() {
        if (this.defaultRenderersByColumnClass == null) {
            this.createDefaultRenderers();
        }
        this.initDateRenderers();
        Settings settings = Settings.getInstance();
        int n = settings.getMaxFractionDigits();
        boolean bl = settings.getUsedFixedDigits();
        String string = settings.getDecimalFormatString();
        String string2 = settings.getIntegerFormatString();
        char c = settings.getDecimalSymbol().charAt(0);
        char c2 = settings.getDecimalGroupCharacter().charAt(0);
        this.setDefaultRenderer(Object.class, new ToolTipRenderer());
        this.setDefaultRenderer(byte[].class, new BlobColumnRenderer());
        NumberColumnRenderer numberColumnRenderer = StringUtil.isNonBlank(string) ? new NumberColumnRenderer(string, c, c2) : new NumberColumnRenderer(n, c, bl);
        this.setDefaultRenderer(Number.class, numberColumnRenderer);
        this.setDefaultRenderer(Double.class, numberColumnRenderer);
        this.setDefaultRenderer(Float.class, numberColumnRenderer);
        this.setDefaultRenderer(BigDecimal.class, numberColumnRenderer);
        NumberColumnRenderer numberColumnRenderer2 = StringUtil.isNonBlank(string2) ? new NumberColumnRenderer(string2, c, c2) : new NumberColumnRenderer();
        this.setDefaultRenderer(BigInteger.class, numberColumnRenderer2);
        this.setDefaultRenderer(Integer.class, numberColumnRenderer2);
        this.setDefaultRenderer(Long.class, numberColumnRenderer2);
        this.setDefaultRenderer(String.class, new StringColumnRenderer());
        this.initTypeSpecificRenderer();
    }

    public ResetHighlightAction getResetHighlightAction() {
        return this.resetHighlightAction;
    }

    public boolean isHighlightEnabled() {
        return this.highlightExpression != null;
    }

    public void clearHighlightExpression() {
        this.applyHighlightExpression(null);
    }

    public RowHighlighter getHighlightExpression() {
        return this.highlightExpression;
    }

    public void applyHighlightExpression(RowHighlighter rowHighlighter) {
        this.highlightExpression = rowHighlighter;
        this.resetHighlightAction.setEnabled(rowHighlighter != null);
        WbSwingUtilities.repaintLater(this);
    }

    public void setMultiLine(int n) {
        if (this.dwModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellRenderer(this.multiLineRenderer);
        }
    }

    private void initTypeSpecificRenderer() {
        if (this.dwModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn == null) continue;
                int n = this.dwModel.getColumnType(i);
                if (this.isMultiLineColumn(i)) {
                    tableColumn.setCellRenderer(this.multiLineRenderer);
                    continue;
                }
                if (this.isHstoreColumn(i)) {
                    tableColumn.setCellRenderer(new HstoreRenderer());
                    continue;
                }
                if (this.isMapColumn(i)) {
                    tableColumn.setCellRenderer(new MapColumnRenderer());
                    continue;
                }
                if (n != 2014) continue;
                boolean bl = Settings.getInstance().useVariableLengthTimeFractions();
                tableColumn.setCellRenderer(new DateColumnRenderer(Settings.getInstance().getDefaultTimestampFormat(), bl));
            }
        }
    }

    private boolean isMapColumn(int n) {
        if (this.dwModel == null) {
            return false;
        }
        Class clazz = this.dwModel.getColumnClass(n);
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    private boolean isHstoreColumn(int n) {
        ColumnIdentifier columnIdentifier = this.getColumnDefinition(n);
        if (columnIdentifier == null) {
            return false;
        }
        return "hstore".equals(columnIdentifier.getDbmsType());
    }

    private boolean isMultiLineColumn(int n) {
        ColumnIdentifier columnIdentifier = this.getColumnDefinition(n);
        if (columnIdentifier == null) {
            return false;
        }
        return SqlUtil.isMultiLineColumn(columnIdentifier);
    }

    private ColumnIdentifier getColumnDefinition(int n) {
        int n2;
        if (this.dwModel == null) {
            return null;
        }
        int n3 = n2 = this.dwModel.isStatusColumnVisible() ? 1 : 0;
        if (n - n2 < 0) {
            return null;
        }
        ColumnIdentifier columnIdentifier = this.dwModel.getDataStore().getResultInfo().getColumn(n - n2);
        return columnIdentifier;
    }

    private void initDefaultEditors() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn == null) continue;
            Class clazz = null;
            if (this.dwModel != null) {
                clazz = this.dwModel.getColumnClass(i);
            }
            if (clazz != null && Number.class.isAssignableFrom(clazz)) {
                tableColumn.setCellEditor(this.defaultNumberEditor);
                continue;
            }
            if (this.isBlobColumn(i)) {
                tableColumn.setCellEditor(new BlobColumnRenderer());
                continue;
            }
            if (this.isHstoreColumn(i)) {
                tableColumn.setCellEditor(new HstoreEditor());
                continue;
            }
            if (this.isMapColumn(i)) {
                tableColumn.setCellEditor(new MapColumnRenderer());
                continue;
            }
            if (this.isMultiLineColumn(i)) {
                tableColumn.setCellEditor(this.multiLineEditor);
                continue;
            }
            tableColumn.setCellEditor(this.defaultEditor);
        }
    }

    public void adjustRowsAndColumns() {
        this.adjustColumns();
        this.adjustRowHeight();
    }

    public void adjustColumns() {
        ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this);
        boolean bl = GuiSettings.getIncludeHeaderInOptimalWidth();
        if (this.autoAdjustColumnWidths) {
            columnWidthOptimizer.optimizeAllColWidth(bl);
        } else {
            columnWidthOptimizer.adjustColumns(this.adjustToColumnLabel);
        }
    }

    public void optimizeRowHeight() {
        RowHeightOptimizer rowHeightOptimizer = new RowHeightOptimizer(this);
        rowHeightOptimizer.optimizeAllRows();
        this.rowHeightWasOptimized = true;
    }

    public void cancelEditing() {
        TableCellEditor tableCellEditor;
        if (this.isEditing() && (tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    public boolean stopEditing() {
        TableCellEditor tableCellEditor;
        boolean bl = false;
        if (this.isEditing() && (tableCellEditor = this.getCellEditor()) != null) {
            bl = tableCellEditor.stopCellEditing();
        }
        return bl;
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        if (this.changeListener.add(tableModelListener) && this.dwModel != null) {
            this.dwModel.addTableModelListener(tableModelListener);
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.changeListener.remove(tableModelListener);
        if (this.dwModel != null) {
            this.dwModel.removeTableModelListener(tableModelListener);
        }
    }

    public int getFirstVisibleRow() {
        if (this.getRowCount() == 0) {
            return -1;
        }
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        Point point = new Point(0, rectangle.y);
        int n = this.rowAtPoint(point);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int getLastVisibleRow() {
        Point point;
        int n;
        Rectangle rectangle;
        int n2 = this.getRowCount();
        if (n2 <= 0) {
            return -1;
        }
        Rectangle rectangle2 = this.scrollPane.getViewport().getViewRect();
        if (!rectangle2.contains(rectangle = this.getCellRect(n = this.rowAtPoint(point = new Point(0, rectangle2.y + rectangle2.height - 1)), 0, true))) {
            --n;
        }
        if (n <= 0 || n >= n2) {
            n = n2 - 1;
        }
        return n;
    }

    public void scrollToRow(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        this.scrollRectToVisible(rectangle);
    }

    protected JPopupMenu createLimitedHeaderPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.sortAscending.getMenuItem());
        jPopupMenu.add(this.sortDescending.getMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.optimizeCol.getMenuItem());
        jPopupMenu.add(this.optimizeAllCol.getMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createZoomSubmenu());
        return jPopupMenu;
    }

    protected JMenu createZoomSubmenu() {
        JMenu jMenu = new JMenu(ResourceMgr.getString("TxtZoom"));
        jMenu.add(new JMenuItem(new IncreaseFontSize("TxtFntInc", this.zoomer)));
        jMenu.add(new JMenuItem(new DecreaseFontSize("TxtFntDecr", this.zoomer)));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new ResetFontSize("TxtFntReset", this.zoomer)));
        return jMenu;
    }

    protected JPopupMenu getHeaderPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.sortAscending.getMenuItem());
        jPopupMenu.add(this.sortDescending.getMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.optimizeCol.getMenuItem());
        jPopupMenu.add(this.optimizeAllCol.getMenuItem());
        jPopupMenu.add(this.setColWidth.getMenuItem());
        jPopupMenu.add(new CopyColumnNameAction(this));
        jPopupMenu.add(new CopyAllColumnNamesAction(this));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ScrollToColumnAction(this));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new OptimizeRowHeightAction(this));
        if (this.allowColumnOrderSaving) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ResetColOrderAction(this));
            jPopupMenu.add(new SaveColOrderAction(this));
        }
        jPopupMenu.add(this.createZoomSubmenu());
        return jPopupMenu;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            if (mouseEvent.getSource() instanceof JTableHeader) {
                this.headerPopupX = mouseEvent.getX();
                EventQueue.invokeLater(() -> {
                    JPopupMenu jPopupMenu = this.getHeaderPopup();
                    jPopupMenu.show(this.getTableHeader(), mouseEvent.getX(), mouseEvent.getY());
                });
            } else if (this.showPopup && this.popup != null) {
                int n;
                int n2 = this.rowAtPoint(mouseEvent.getPoint());
                int n3 = this.getSelectedRowCount();
                if (n3 <= 1 && n2 >= 0 && this.selectOnRightButtonClick && n2 != (n = this.getSelectedRow())) {
                    ListSelectionModel listSelectionModel = this.getSelectionModel();
                    EventQueue.invokeLater(() -> listSelectionModel.setSelectionInterval(n2, n2));
                }
                n = mouseEvent.getX();
                int n4 = mouseEvent.getY();
                EventQueue.invokeLater(() -> this.popup.show(this, n, n4));
            }
        } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && this.dwModel != null && mouseEvent.getSource() instanceof JTableHeader) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n5 = this.convertColumnIndexToModel(n);
            boolean bl = mouseEvent.isControlDown();
            boolean bl2 = mouseEvent.isAltDown();
            if (n5 >= 0) {
                if (mouseEvent.isShiftDown()) {
                    this.dwModel.removeSortColumn(n5);
                    this.repaint();
                } else {
                    this.dwModel.startBackgroundSort(this, n5, bl, bl2);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            boolean bl = (mouseEvent.getModifiersEx() & 0x200) == 512;
            this.setColumnSelectionAllowed(bl);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public int getPopupViewColumnIndex() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        return tableColumnModel.getColumnIndexAtX(this.headerPopupX);
    }

    public int getPopupColumnIndex() {
        int n = this.getPopupViewColumnIndex();
        int n2 = this.convertColumnIndexToModel(n);
        return n2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            int n = this.getPopupColumnIndex();
            if (actionEvent.getSource() == this.sortAscending && this.dwModel != null) {
                this.dwModel.sortInBackground(this, n, true, false);
            } else if (actionEvent.getSource() == this.sortDescending && this.dwModel != null) {
                this.dwModel.sortInBackground(this, n, false, false);
            } else if (actionEvent.getSource() == this.setColWidth) {
                try {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n);
                    int n2 = tableColumn.getWidth();
                    String string = WbSwingUtilities.getUserInput(this, ResourceMgr.getString("MsgEnterNewColWidth"), NumberStringCache.getNumberString(n2));
                    if (string == null) break block10;
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    if (n2 > 0) {
                        tableColumn.setWidth(n2);
                        tableColumn.setPreferredWidth(n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean selectKeyColumns() {
        Object object;
        DataStore dataStore = this.getDataStore();
        TableIdentifier tableIdentifier = dataStore.getUpdateTable();
        if (tableIdentifier == null && (tableIdentifier = ((UpdateTableSelector)(object = new UpdateTableSelector(this))).selectUpdateTable()) != null) {
            dataStore.setUpdateTable(tableIdentifier);
        }
        if (!((ResultInfo)(object = dataStore.getResultInfo())).hasPkColumns()) {
            try {
                ((ResultInfo)object).readPkDefinition(dataStore.getOriginalConnection());
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error when retrieving key columns", sQLException);
            }
        }
        if (tableIdentifier == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            WbSwingUtilities.showErrorMessageKey(window, "MsgNoUpdateTable");
            return false;
        }
        KeyColumnSelectorPanel keyColumnSelectorPanel = new KeyColumnSelectorPanel((ResultInfo)object);
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean bl = ValidatingDialog.showConfirmDialog(window, keyColumnSelectorPanel, ResourceMgr.getString("MsgSelectKeyColumnsWindowTitle"), null, 0, true);
        if (bl) {
            ColumnIdentifier[] columnIdentifierArray = keyColumnSelectorPanel.getColumns();
            dataStore.setPKColumns(columnIdentifierArray);
            this.checkCopyActions();
            if (keyColumnSelectorPanel.getSaveToGlobalPKMap()) {
                PkMapping.getInstance().addMapping(tableIdentifier, columnIdentifierArray);
                FileDialogUtil.selectPkMapFileIfNecessary(window);
            }
            return true;
        }
        return false;
    }

    public boolean detectDefinedPkColumns() {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return false;
        }
        if (dataStore.hasPkColumns()) {
            return true;
        }
        try {
            if (this.statusBar != null) {
                this.statusBar.setStatusMessage(ResourceMgr.getString("MsgRetrievingKeyColumns"));
            }
            dataStore.updatePkInformation();
            if (this.statusBar != null) {
                this.statusBar.clearStatusMessage();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read PK columns", exception);
            return false;
        }
        return dataStore.hasPkColumns();
    }

    public void checkCopyActions() {
        boolean bl;
        boolean bl2 = bl = this.getRowCount() > 0;
        if (this.saveDataAsAction != null) {
            this.saveDataAsAction.setEnabled(bl);
        }
        if (this.copyAsTextAction != null) {
            this.copyAsTextAction.setEnabled(bl);
        }
        if (this.copyMergeAction != null) {
            this.copyMergeAction.setEnabled(bl);
        }
        if (this.copyInsertAction != null) {
            this.copyInsertAction.setEnabled(bl);
        }
        if (this.copyUpdateAction != null) {
            this.copyUpdateAction.setEnabled(bl);
        }
        if (this.copyDeleteInsertAction != null) {
            this.copyDeleteInsertAction.setEnabled(bl);
        }
        if (this.copyDeleteAction != null) {
            this.copyDeleteAction.setEnabled(bl);
        }
    }

    public boolean hasPkColumns() {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return false;
        }
        return dataStore.hasPkColumns();
    }

    public boolean checkPkColumns(boolean bl) {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return false;
        }
        boolean bl2 = this.detectDefinedPkColumns();
        boolean bl3 = dataStore.pkColumnsComplete();
        if (bl2 && bl3) {
            return true;
        }
        if (bl) {
            bl2 = bl2 && !bl3 ? WbSwingUtilities.getYesNo(this, ResourceMgr.getString("MsgIgnoreMissingPK")) : this.selectKeyColumns();
        }
        if (!bl2) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not find key columns for updating table " + dataStore.getUpdateTable());
        }
        return bl2;
    }

    @Override
    public void fontChanged(String string, Font font) {
        if (string.equals("data")) {
            this.setFont(font);
            this.getTableHeader().setFont(font);
            this.defaultEditor.setFont(font);
            this.numberEditorTextField.setFont(font);
        }
    }

    public int addRow() {
        DataStoreTableModel dataStoreTableModel = this.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return -1;
        }
        int n = this.getSelectedRow();
        this.saveRowHeaderState();
        this.stopEditing();
        int n2 = n == -1 ? dataStoreTableModel.addRow() : dataStoreTableModel.insertRow(n);
        this.restoreRowHeaderState();
        this.getSelectionModel().setSelectionInterval(n2, n2);
        this.scrollToRow(n2);
        this.setEditingRow(n2);
        if (this.dwModel.isStatusColumnVisible()) {
            this.setEditingColumn(1);
            this.editCellAt(n2, 1);
        } else {
            this.setEditingColumn(0);
            this.editCellAt(n2, 0);
        }
        Component component = this.getEditorComponent();
        if (component != null) {
            EventQueue.invokeLater(component::requestFocusInWindow);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int duplicateRow(int n) {
        DataStoreTableModel dataStoreTableModel = this.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return -1;
        }
        int n2 = -1;
        try {
            this.saveRowHeaderState();
            n2 = dataStoreTableModel.duplicateRow(n);
        }
        finally {
            this.restoreRowHeaderState();
        }
        return n2;
    }

    public boolean deleteRow() {
        try {
            return this.deleteRow(false);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRow(boolean bl) throws SQLException {
        DataStoreTableModel dataStoreTableModel = this.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return false;
        }
        try {
            int n;
            this.saveRowHeaderState();
            int[] nArray = this.getSelectedRows();
            int n2 = nArray.length;
            if (n2 > 0) {
                for (n = n2 - 1; n >= 0; --n) {
                    dataStoreTableModel.deleteRow(nArray[n], bl);
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.restoreRowHeaderState();
        }
    }

    public void setHighlightRequiredFields(boolean bl) {
        this.highlightRequiredFields = bl;
        if (bl && this.requiredColor == null) {
            this.requiredColor = GuiSettings.getRequiredFieldColor();
        } else if (!bl) {
            this.requiredColor = null;
        }
    }
}

