/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.RestoreDataAction;
import workbench.gui.actions.SelectFkValueAction;
import workbench.gui.actions.SetNullAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.CellWindowEdit;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.EditWindow;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbTable;
import workbench.interfaces.NullableEditor;
import workbench.resource.ResourceMgr;
import workbench.util.WbDateFormatter;

public class WbTextCellEditor
extends DefaultCellEditor
implements MouseListener,
DocumentListener,
NullableEditor {
    private JTextField textField;
    private WbTable parentTable;
    private Color defaultBackground;
    private boolean changed;
    private boolean isNull;
    private RestoreDataAction restoreValue;
    private SetNullAction setNull;
    private SelectFkValueAction selectFk;
    private TextComponentMouseListener contextMenu;

    public static WbTextCellEditor createInstance() {
        return WbTextCellEditor.createInstance(null);
    }

    public static WbTextCellEditor createInstance(WbTable wbTable) {
        JTextField jTextField = new JTextField();
        WbTextCellEditor wbTextCellEditor = new WbTextCellEditor(wbTable, jTextField);
        return wbTextCellEditor;
    }

    public WbTextCellEditor(WbTable wbTable, JTextField jTextField) {
        super(jTextField);
        this.defaultBackground = jTextField.getBackground();
        this.parentTable = wbTable;
        this.textField = jTextField;
        this.textField.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.textField.addMouseListener(this);
        this.restoreValue = new RestoreDataAction(this);
        this.contextMenu = new TextComponentMouseListener(this.textField);
        this.setNull = new SetNullAction(this);
        this.contextMenu.addAction(this.setNull);
        this.setNull.addToInputMap(this.textField);
        this.contextMenu.addAction(this.restoreValue);
        this.restoreValue.addToInputMap(this.textField);
        this.selectFk = new SelectFkValueAction(wbTable);
        this.contextMenu.addAction(this.selectFk);
        this.selectFk.addToInputMap(this.textField);
        this.textField.getDocument().addDocumentListener(this);
        super.addCellEditorListener(wbTable);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.textField != null) {
            this.textField.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.textField != null) {
            this.textField.removeActionListener(actionListener);
        }
    }

    public void dispose() {
        ActionListener[] actionListenerArray;
        WbSwingUtilities.removeAllListeners(this.textField);
        WbAction.dispose(this.restoreValue, this.setNull, this.selectFk);
        this.contextMenu.dispose();
        if (this.textField != null && (actionListenerArray = this.textField.getActionListeners()) != null) {
            for (ActionListener actionListener : actionListenerArray) {
                this.textField.removeActionListener(actionListener);
            }
        }
    }

    @Override
    public void restoreOriginal() {
        Object object;
        int n = this.parentTable.getEditingRow();
        int n2 = this.parentTable.getEditingColumn();
        if (n >= 0 && n2 >= 0 && (object = this.parentTable.restoreColumnValue(n, n2)) != null) {
            this.textField.setText(object.toString());
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setFont(Font font) {
        this.textField.setFont(font);
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void requestFocus() {
        this.textField.requestFocusInWindow();
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isNull) {
            return null;
        }
        return this.textField.getText();
    }

    @Override
    public void setNull(boolean bl) {
        if (bl) {
            this.textField.setText("");
        }
        this.isNull = bl;
    }

    @Override
    public JTextComponent getEditor() {
        return this.textField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = WbDateFormatter.getDisplayValue(object);
        Component component = super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        this.textField.selectAll();
        this.changed = false;
        this.isNull = false;
        WbTable wbTable = (WbTable)jTable;
        this.setEditable(!wbTable.isReadOnly());
        DataStoreTableModel dataStoreTableModel = wbTable.getDataStoreTableModel();
        if (dataStoreTableModel != null) {
            this.restoreValue.setEnabled(dataStoreTableModel.isColumnModified(n, n2));
        } else {
            this.restoreValue.setEnabled(false);
        }
        return component;
    }

    public void setBackground(Color color) {
        this.textField.setBackground(color);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = super.shouldSelectCell(eventObject);
        if (bl) {
            this.textField.selectAll();
        }
        return bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.openEditWindow();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl = super.stopCellEditing();
        if (bl) {
            this.fireEditingStopped();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openEditWindow() {
        if (this.parentTable == null) {
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.textField);
            String string = ResourceMgr.getString("TxtEditWindowTitle");
            String string2 = this.textField.getText();
            EditWindow editWindow = new EditWindow(frame, string, string2);
            try {
                editWindow.setVisible(true);
                if (editWindow.isCancelled()) return;
                this.textField.setText(editWindow.getText());
                return;
            }
            finally {
                editWindow.dispose();
            }
        } else {
            CellWindowEdit cellWindowEdit = new CellWindowEdit(this.parentTable);
            cellWindowEdit.openEditWindow();
        }
    }

    public boolean isModified() {
        return this.changed;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.setNull(false);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.setNull(false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.setNull(false);
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
        if (!bl) {
            this.textField.setBackground(this.defaultBackground);
        }
        this.textField.getCaret().setVisible(true);
    }
}

