/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import workbench.util.StringUtil;

public class WbTextLabel
extends JComponent
implements MouseListener {
    private static final int DEFAULT_TEXT_Y = 15;
    private String text;
    private Color textColor;
    private int textX = 2;
    private int textY = 15;
    private int alignment = 2;
    private FontMetrics fm;
    private boolean hasBorder;
    private Map renderingHints;
    private int minCharacters;

    public WbTextLabel() {
        this.setDoubleBuffered(true);
        this.setBackground(UIManager.getColor("Label.background"));
        this.textColor = UIManager.getColor("Label.foreground");
        this.setForeground(this.textColor);
        this.setOpaque(false);
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            super.setFont(font);
            this.fm = this.getFontMetrics(font);
            this.textY = this.fm != null ? this.fm.getAscent() + 2 : 15;
        }
        this.addMouseListener(this);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.renderingHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
    }

    public void setMininumCharacters(int n) {
        this.minCharacters = n;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fm != null) {
            int n;
            Rectangle2D rectangle2D = this.fm.getStringBounds("M", this.getGraphics());
            int n2 = (int)rectangle2D.getWidth();
            int n3 = (int)rectangle2D.getHeight();
            int n4 = n = n2 * this.minCharacters;
            if (StringUtil.isNonEmpty(this.text)) {
                Rectangle2D rectangle2D2 = this.fm.getStringBounds(this.text, this.getGraphics());
                n4 = (int)rectangle2D2.getWidth();
                n3 = (int)rectangle2D2.getHeight();
            }
            n4 = Math.max(n, n4);
            return new Dimension(n4, n3 + 2);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.textColor = color;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.hasBorder = border != null;
    }

    public void setHorizontalAlignment(int n) {
        this.alignment = n;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textY = this.fm != null ? this.fm.getAscent() + 2 : 15;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        if (this.alignment == 4) {
            int n = this.fm != null ? this.fm.stringWidth(this.text) : 15;
            this.textX = this.getWidth() - n - 4;
        }
        this.invalidate();
        this.repaint();
    }

    public void forcePaint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.clearRect(0, 0, this.getWidth() - 4, this.getHeight() - 1);
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.hasBorder) {
            super.paint(graphics);
        }
        if (this.text != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.renderingHints != null) {
                graphics2D.addRenderingHints(this.renderingHints);
            }
            graphics.setColor(this.textColor);
            graphics.drawString(this.text, this.textX, this.textY);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

