/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import workbench.WbManager;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.WindowTitleBuilder;
import workbench.gui.components.ConnectionSelector;
import workbench.gui.components.RunningJobIndicator;
import workbench.gui.dbobjects.DbExplorerPanel;
import workbench.interfaces.Connectable;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.StatusBar;
import workbench.interfaces.ToolWindow;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class DbExplorerWindow
extends JFrame
implements WindowListener,
Connectable,
ToolWindow,
DbExecutionListener {
    private DbExplorerPanel panel;
    private boolean standalone;
    protected ConnectionSelector connectionSelector;
    protected RunningJobIndicator jobIndicator;

    public DbExplorerWindow(DbExplorerPanel dbExplorerPanel) {
        this(dbExplorerPanel, null);
    }

    public DbExplorerWindow(DbExplorerPanel dbExplorerPanel, ConnectionProfile connectionProfile) {
        this.setDefaultCloseOperation(0);
        this.panel = dbExplorerPanel;
        this.addWindowListener(this);
        this.getContentPane().add(this.panel);
        ResourceMgr.setWindowIcons((Window)this, "database");
        this.restorePosition();
        this.jobIndicator = new RunningJobIndicator(this);
        this.panel.setDbExecutionListener(this);
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void activate() {
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public String getDefaultIconName() {
        return "database";
    }

    public void updateTitle(WbConnection wbConnection) {
        WindowTitleBuilder windowTitleBuilder = new WindowTitleBuilder();
        windowTitleBuilder.setShowWorkspace(false);
        String string = windowTitleBuilder.getWindowTitle(wbConnection, null, null, ResourceMgr.getString("TxtDbExplorerTitel"));
        this.setTitle(string);
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
        if (bl) {
            WbManager.getInstance().registerToolWindow(this);
            this.connectionSelector = new ConnectionSelector(this, this);
            this.connectionSelector.setPropertyKey("workbench.dbexplorer.connection.last");
            this.panel.showConnectButton(this.connectionSelector);
        }
    }

    public void selectConnection() {
        this.connectionSelector.selectConnection();
    }

    @Override
    public void executionEnd(WbConnection wbConnection, Object object) {
        this.jobIndicator.jobEnded();
    }

    @Override
    public void executionStart(WbConnection wbConnection, Object object) {
        this.jobIndicator.jobStarted();
    }

    @Override
    public WbConnection getConnection() {
        return this.panel.getConnection();
    }

    @Override
    public void closeWindow() {
        this.saveSettings();
        this.disconnect();
        this.panel.explorerWindowClosed();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void disconnect() {
        this.panel.disconnect();
    }

    public void saveSettings() {
        Settings.getInstance().storeWindowPosition(this);
        Settings.getInstance().storeWindowSize(this);
        this.panel.saveSettings();
    }

    public final void restorePosition() {
        Settings settings = Settings.getInstance();
        if (!settings.restoreWindowSize(this)) {
            this.setSize(950, 750);
        }
        if (!settings.restoreWindowPosition(this)) {
            WbSwingUtilities.center(this, null);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (this.standalone) {
            WbManager.getInstance().unregisterToolWindow(this);
        } else if (this.panel != null) {
            this.panel.explorerWindowClosed();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.panel.canClosePanel(true)) {
            this.closeWindow();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void showWindow() {
        EventQueue.invokeLater(() -> {
            DbExplorerPanel dbExplorerPanel = new DbExplorerPanel();
            DbExplorerWindow dbExplorerWindow = new DbExplorerWindow(dbExplorerPanel);
            dbExplorerWindow.setStandalone(true);
            dbExplorerWindow.restorePosition();
            dbExplorerPanel.restoreSettings();
            dbExplorerWindow.setVisible(true);
            dbExplorerWindow.selectConnection();
        });
    }

    @Override
    public boolean connectBegin(ConnectionProfile connectionProfile, StatusBar statusBar, boolean bl) {
        return true;
    }

    @Override
    public void connectCancelled() {
    }

    @Override
    public void connectFailed(String string) {
        this.updateTitle(null);
        this.panel.setConnection(null);
        WbSwingUtilities.showFriendlyErrorMessage(this, ResourceMgr.getString("ErrConnectFailed"), string.trim());
    }

    @Override
    public void connected(WbConnection wbConnection) {
        this.updateTitle(wbConnection);
        this.panel.setConnection(wbConnection);
    }

    @Override
    public String getConnectionId(ConnectionProfile connectionProfile) {
        if (this.panel == null) {
            return "DbExplorerWindow";
        }
        return this.panel.getId();
    }

    @Override
    public void connectEnded() {
    }
}

