/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.actions.CreateSnippetAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbMenuItem;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.sql.PanelContentSender;
import workbench.gui.sql.PasteType;
import workbench.interfaces.FilenameChangeListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.NumberStringCache;

public class EditorTabSelectMenu
extends WbMenu
implements FilenameChangeListener,
ChangeListener,
ActionListener {
    public static final String CMD_CLIPBOARD = "clipboard";
    private MainWindow parentWindow;
    private ActionListener target;
    private String regularTooltip;
    private String newTabTooltip;
    public static final String PANEL_CMD_PREFIX = "panel_";
    private DependencyNode node;
    private boolean withClipboard;
    private DbObjectList objectList;
    private PasteType pasteType = PasteType.overwrite;
    private boolean useColumnListForTableSelect = true;

    public EditorTabSelectMenu(String string, String string2, String string3, MainWindow mainWindow) {
        this(string, string2, string3, mainWindow, false);
    }

    public EditorTabSelectMenu(String string, String string2, String string3, MainWindow mainWindow, boolean bl) {
        super(string);
        this.parentWindow = mainWindow;
        this.newTabTooltip = ResourceMgr.getDescription(string2, true);
        this.regularTooltip = ResourceMgr.getDescription(string3, true);
        this.withClipboard = bl;
        if (this.parentWindow != null) {
            this.parentWindow.addFilenameChangeListener(this);
            this.parentWindow.addTabChangeListener(this);
        }
    }

    public void setUseColumnListForTableData(boolean bl) {
        this.useColumnListForTableSelect = bl;
    }

    public void setPasteType(PasteType pasteType) {
        this.pasteType = pasteType;
    }

    public void setActionListener(ActionListener actionListener) {
        this.target = actionListener;
        this.updateMenu();
    }

    public void setObjectList(DbObjectList dbObjectList) {
        this.objectList = dbObjectList;
        this.updateMenu();
    }

    public void setDependencyNode(DependencyNode dependencyNode) {
        this.node = dependencyNode;
    }

    public DependencyNode getDependencyNode() {
        return this.node;
    }

    protected final synchronized void updateMenu() {
        Serializable serializable;
        JMenuItem jMenuItem;
        int n;
        if (this.parentWindow == null) {
            return;
        }
        List<String> list = this.parentWindow.getPanelLabels();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        int n2 = this.getItemCount();
        for (n = 0; n < n2; ++n) {
            jMenuItem = this.getItem(n);
            if (jMenuItem == null || this.target == null) continue;
            jMenuItem.removeActionListener(this.target);
        }
        this.removeAll();
        n = this.parentWindow.getCurrentPanelIndex();
        jMenuItem = new WbMenuItem(ResourceMgr.getString("LblShowDataInNewTab"));
        jMenuItem.setActionCommand("panel_-1");
        jMenuItem.setToolTipText(this.newTabTooltip);
        jMenuItem.addActionListener(this.target == null ? this : this.target);
        this.add(jMenuItem);
        if (this.withClipboard) {
            serializable = new WbMenuItem(ResourceMgr.getString("MnuTxtStmtClip"));
            ((JComponent)serializable).setToolTipText(ResourceMgr.getDescription("MnuTxtStmtClip", true));
            ((AbstractButton)serializable).setActionCommand(CMD_CLIPBOARD);
            ((AbstractButton)serializable).addActionListener(this.target == null ? this : this.target);
            this.add((JMenuItem)serializable);
        }
        if ((serializable = jMenuItem.getFont()) != null) {
            serializable = ((Font)serializable).deriveFont(1);
        }
        this.addSeparator();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            String string = list.get(i);
            string = i < 9 ? string + " &" + NumberStringCache.getNumberString(i + 1) : string + NumberStringCache.getNumberString(i + 1);
            WbMenuItem wbMenuItem = new WbMenuItem(string);
            wbMenuItem.setActionCommand(PANEL_CMD_PREFIX + NumberStringCache.getNumberString(i));
            if (i == n && serializable != null) {
                wbMenuItem.setFont((Font)serializable);
            }
            wbMenuItem.setToolTipText(this.regularTooltip);
            wbMenuItem.addActionListener(this.target == null ? this : this.target);
            this.add(wbMenuItem);
        }
        if (this.objectList != null) {
            List<TableIdentifier> list2 = DbObjectList.Util.getSelectedTableObjects(this.objectList);
            this.setEnabled(list2.size() > 0);
        }
    }

    @Override
    public void fileNameChanged(Object object, String string) {
        try {
            this.updateMenu();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when updating the popup menu", exception);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        EventQueue.invokeLater(this::updateMenu);
    }

    @Override
    public void dispose() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem != null && this.target != null) {
                jMenuItem.removeActionListener(this.target);
            }
            if (!(jMenuItem instanceof WbMenuItem)) continue;
            ((WbMenuItem)jMenuItem).dispose();
        }
        super.dispose();
    }

    private void showTableData(int n, PasteType pasteType) {
        TableIdentifier tableIdentifier = this.objectList.getObjectTable();
        PanelContentSender panelContentSender = new PanelContentSender(this.parentWindow, tableIdentifier.getTableName());
        try {
            String string = this.buildSqlForTable();
            if (string == null) {
                return;
            }
            EventQueue.invokeLater(() -> panelContentSender.sendContent(string, n, pasteType));
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not build SELECT statement", exception);
        }
    }

    private String buildSqlForTable() {
        Object object;
        WbConnection wbConnection = this.objectList.getConnection();
        TableIdentifier tableIdentifier = this.objectList.getObjectTable();
        if (tableIdentifier == null) {
            return null;
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList();
        if (this.useColumnListForTableSelect) {
            object = this.objectList.getCurrentTableDefinition();
            arrayList = ((TableDefinition)object).getColumns();
        }
        object = new TableSelectBuilder(wbConnection, "tabledata");
        String string = ((TableSelectBuilder)object).getSelectForTableData(tableIdentifier, arrayList, true);
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith(PANEL_CMD_PREFIX) && this.parentWindow != null) {
            try {
                int n = Integer.parseInt(string.substring(PANEL_CMD_PREFIX.length()));
                PasteType pasteType = WbAction.isCtrlPressed(actionEvent) ? PasteType.append : this.pasteType;
                this.showTableData(n, pasteType);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when accessing editor tab", exception);
            }
        } else if (CMD_CLIPBOARD.equals(string)) {
            boolean bl = WbAction.isCtrlPressed(actionEvent);
            String string2 = this.buildSqlForTable();
            if (string2 == null) {
                return;
            }
            if (bl) {
                string2 = CreateSnippetAction.makeJavaString(string2, true);
            }
            StringSelection stringSelection = new StringSelection(string2);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
    }
}

