/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import workbench.gui.WbSwingUtilities;
import workbench.gui.dbobjects.ProgressPanel;
import workbench.interfaces.Interruptable;
import workbench.storage.RowActionMonitor;
import workbench.util.WbThread;

public class ProgressDialog
extends JDialog
implements WindowListener {
    private ProgressPanel progressPanel;
    private Interruptable worker;
    private final Frame parentWindow;

    public ProgressDialog(String string, Frame frame, Interruptable interruptable) {
        this(string, frame, interruptable, true);
    }

    public ProgressDialog(String string, Frame frame, Interruptable interruptable, boolean bl) {
        super(frame, true);
        this.setTitle(string);
        this.worker = interruptable;
        this.parentWindow = frame;
        this.progressPanel = new ProgressPanel(this.worker, bl);
        this.progressPanel.setParentDialog(this);
        this.getContentPane().add(this.progressPanel);
        this.pack();
        this.addWindowListener(this);
    }

    public ProgressPanel getInfoPanel() {
        return this.progressPanel;
    }

    public void finished() {
        this.removeWindowListener(this);
        this.setVisible(false);
    }

    public RowActionMonitor getMonitor() {
        return this.progressPanel;
    }

    public void showProgressWindow() {
        WbThread wbThread = new WbThread("ShowProgress"){

            @Override
            public void run() {
                WbSwingUtilities.invoke(() -> {
                    WbSwingUtilities.center(ProgressDialog.this, ProgressDialog.this.parentWindow);
                    ProgressDialog.this.setVisible(true);
                });
            }
        };
        wbThread.start();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.worker.cancelExecution();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

