/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbButton;
import workbench.interfaces.Interruptable;
import workbench.interfaces.InterruptableJob;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class ProgressPanel
extends JPanel
implements RowActionMonitor {
    private Interruptable task;
    private JDialog parent;
    private int monitorType = 7;
    private JButton cancelButton;
    private JTextField fileNameField;
    private JPanel infoPanel;
    private JTextField progressInfoText;
    private JLabel rowInfo;

    public ProgressPanel(Interruptable interruptable, boolean bl) {
        this.task = interruptable;
        this.initComponents();
        if (!bl) {
            this.remove(this.fileNameField);
        }
        this.setRowSize(20);
        WbSwingUtilities.setMinimumSize(this.rowInfo, 15);
        WbSwingUtilities.setMinimumSize(this.progressInfoText, 30);
    }

    public void setParentDialog(JDialog jDialog) {
        this.parent = jDialog;
    }

    public void setRowInfo(long l) {
        if (l < 0L) {
            this.rowInfo.setText("");
        } else {
            this.rowInfo.setText(Long.toString(l));
        }
    }

    public void setInfoText(String string) {
        this.progressInfoText.setText(string);
    }

    public void setObject(String string) {
        boolean bl = StringUtil.stringsAreNotEqual(string, this.fileNameField.getText());
        if (bl) {
            this.fileNameField.setText(string);
            this.updateLayout();
        }
    }

    protected void updateLayout() {
        FontMetrics fontMetrics = this.getFontMetrics(this.fileNameField.getFont());
        int n = fontMetrics.stringWidth(this.fileNameField.getText()) + 25;
        int n2 = fontMetrics.getHeight() + 2;
        Dimension dimension = new Dimension(n, n2 < 22 ? 22 : n2);
        this.fileNameField.setPreferredSize(dimension);
        this.fileNameField.setMinimumSize(dimension);
        if (this.parent != null) {
            this.parent.invalidate();
        }
        this.invalidate();
        if (this.parent != null) {
            this.parent.validate();
            this.parent.pack();
        }
    }

    public void setRowSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.charWidth(' ');
        int n3 = fontMetrics.getHeight() + 2;
        Dimension dimension = new Dimension(n2 * n, n3 < 22 ? 22 : n3);
        this.rowInfo.setPreferredSize(dimension);
        this.rowInfo.setMinimumSize(dimension);
        this.updateLayout();
    }

    @Override
    public void jobFinished() {
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        String string2 = NumberStringCache.getNumberString(l) + "/" + NumberStringCache.getNumberString(l2);
        WbSwingUtilities.invoke(() -> {
            if (this.monitorType == 3) {
                this.setRowInfo(0L);
                this.setInfoText(ResourceMgr.getString("MsgSpoolingRow"));
                this.setObject(string + " [" + string2 + "]");
            } else {
                this.setInfoText(string);
                if (l >= 0L && l2 > 0L) {
                    this.rowInfo.setText(string2);
                }
            }
        });
    }

    @Override
    public void setCurrentRow(long l, long l2) {
        if (l > -1L && l2 > -1L) {
            this.rowInfo.setText(NumberStringCache.getNumberString(l) + "/" + NumberStringCache.getNumberString(l2));
        }
        if (l > -1L) {
            this.rowInfo.setText(NumberStringCache.getNumberString(l));
        } else {
            this.rowInfo.setText("");
        }
    }

    @Override
    public void saveCurrentType(String string) {
    }

    @Override
    public void restoreType(String string) {
    }

    @Override
    public void setMonitorType(int n) {
        this.monitorType = n;
    }

    @Override
    public int getMonitorType() {
        return this.monitorType;
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.progressInfoText = new JTextField();
        this.rowInfo = new JLabel();
        this.cancelButton = new WbButton();
        this.fileNameField = new JTextField();
        this.setMinimumSize(new Dimension(250, 10));
        this.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.infoPanel.setLayout(new GridBagLayout());
        this.progressInfoText.setEditable(false);
        this.progressInfoText.setBorder(null);
        this.progressInfoText.setDisabledTextColor(this.progressInfoText.getForeground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.progressInfoText, gridBagConstraints);
        this.rowInfo.setHorizontalAlignment(4);
        this.rowInfo.setMinimumSize(new Dimension(40, 20));
        this.rowInfo.setPreferredSize(new Dimension(40, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.rowInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.infoPanel, gridBagConstraints);
        this.cancelButton.setText(ResourceMgr.getString("LblCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressPanel.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 10, 0);
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.fileNameField.setEditable(false);
        this.fileNameField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 6);
        this.add((Component)this.fileNameField, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        if (this.task instanceof InterruptableJob) {
            String string = ResourceMgr.getString("MsgCancelAllCurrent");
            String string2 = ResourceMgr.getString("LblCancelCurrentExport");
            String string3 = ResourceMgr.getString("LblCancelAllExports");
            int n = WbSwingUtilities.getYesNo(this.parent, string, new String[]{string2, string3});
            InterruptableJob interruptableJob = (InterruptableJob)this.task;
            if (n == 0) {
                interruptableJob.cancelCurrent();
            } else {
                interruptableJob.cancelExecution();
            }
        } else if (this.task != null) {
            this.task.cancelExecution();
        }
    }
}

