/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.TableIdentifier;
import workbench.gui.MainWindow;
import workbench.gui.actions.CompileDbObjectAction;
import workbench.gui.actions.CountTableRowsAction;
import workbench.gui.actions.CreateDropScriptAction;
import workbench.gui.actions.CreateDummySqlAction;
import workbench.gui.actions.CreateIndexAction;
import workbench.gui.actions.DeleteTablesAction;
import workbench.gui.actions.DropDbObjectAction;
import workbench.gui.actions.ScriptDbObjectAction;
import workbench.gui.actions.SpoolDataAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbPopupMenu;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.EditorTabSelectMenu;
import workbench.gui.dbobjects.objecttree.DbTreePanel;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.EditAction;
import workbench.gui.dbobjects.objecttree.FindObjectAction;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.ReloadNodeAction;
import workbench.gui.dbobjects.objecttree.ShowRowCountAction;
import workbench.gui.dbobjects.objecttree.SortColumnsAction;
import workbench.gui.sql.PasteType;
import workbench.interfaces.WbSelectionModel;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

class ContextMenuFactory {
    ContextMenuFactory() {
    }

    static JPopupMenu createContextMenu(DbTreePanel dbTreePanel, WbSelectionModel wbSelectionModel) {
        Object object;
        Object object2;
        Object object3;
        int n;
        WbAction wbAction;
        Cloneable cloneable;
        final WbPopupMenu wbPopupMenu = new WbPopupMenu();
        wbPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                wbPopupMenu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        ReloadNodeAction reloadNodeAction = new ReloadNodeAction(dbTreePanel);
        wbPopupMenu.add(reloadNodeAction);
        List<ObjectTreeNode> list = dbTreePanel.getSelectedNodes();
        String string = null;
        if (list.size() == 1) {
            ObjectTreeNode objectTreeNode = list.get(0);
            string = objectTreeNode.getType();
            if (objectTreeNode.getType().equals("column-list")) {
                cloneable = new SortColumnsAction(dbTreePanel.getTree(), objectTreeNode, true);
                wbAction = new SortColumnsAction(dbTreePanel.getTree(), objectTreeNode, false);
                wbPopupMenu.add((Action)((Object)cloneable));
                wbPopupMenu.add(wbAction);
            }
        }
        if ((n = dbTreePanel.getSelectionCount()) == 1) {
            boolean bl;
            cloneable = dbTreePanel.getSelectedNode();
            boolean bl2 = bl = ((ObjectTreeNode)cloneable).isFKTable() || dbTreePanel.getLoader().isDependencyNode(((ObjectTreeNode)cloneable).getParent());
            if (bl) {
                object3 = new FindObjectAction(null);
                ((FindObjectAction)object3).setFinder(dbTreePanel);
                ((FindObjectAction)object3).setTargetTable(((ObjectTreeNode)cloneable).getDbObject());
                wbPopupMenu.add((Action)object3);
            }
        }
        wbPopupMenu.addSeparator();
        cloneable = new SpoolDataAction(dbTreePanel);
        wbPopupMenu.add((Action)((Object)cloneable));
        if (DbTreeSettings.showCountRowsAction()) {
            wbAction = new CountTableRowsAction(dbTreePanel, wbSelectionModel);
            ((CountTableRowsAction)wbAction).setConnection(dbTreePanel.getConnection());
            if (wbAction.isEnabled()) {
                wbPopupMenu.add(wbAction);
            }
        }
        wbAction = new ShowRowCountAction(dbTreePanel, dbTreePanel, dbTreePanel.getStatusBar());
        wbPopupMenu.add(wbAction);
        wbPopupMenu.addSeparator();
        object3 = dbTreePanel.getConnection().getMetadata();
        Set<String> set = CollectionUtil.caseInsensitiveSet(((DbMetadata)object3).getSelectableTypes());
        Window window = SwingUtilities.getWindowAncestor(dbTreePanel);
        if (string != null && set.contains(string)) {
            if (window instanceof MainWindow) {
                object2 = new EditorTabSelectMenu(ResourceMgr.getString("MnuTxtShowTableData"), "LblShowDataInNewTab", "LblDbTreePutSelectInto", (MainWindow)window, true);
                ((EditorTabSelectMenu)object2).setPasteType(PasteType.insert);
                ((EditorTabSelectMenu)object2).setObjectList(dbTreePanel);
                ((EditorTabSelectMenu)object2).setUseColumnListForTableData(DbTreeSettings.useColumnListForTableDataDisplay(dbTreePanel.getConnection().getDbId()));
                wbPopupMenu.add((JMenuItem)object2);
            }
            wbPopupMenu.add(CreateDummySqlAction.createDummyInsertAction((DbObjectList)dbTreePanel, wbSelectionModel));
            wbPopupMenu.add(CreateDummySqlAction.createDummyUpdateAction((DbObjectList)dbTreePanel, wbSelectionModel));
            wbPopupMenu.add(CreateDummySqlAction.createDummySelectAction((DbObjectList)dbTreePanel, wbSelectionModel));
            wbPopupMenu.addSeparator();
        }
        boolean bl = (object2 = dbTreePanel.getSelectedObjects()).size() > 0;
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            object = object4.next();
            if (object.supportsGetSource()) continue;
            bl = false;
            break;
        }
        if (window instanceof MainWindow) {
            object4 = new EditorTabSelectMenu(ResourceMgr.getString("LblEditScriptSource"), "LblEditInNewTab", "LblEditInTab", (MainWindow)window, false);
            object = new EditAction(dbTreePanel);
            if (object2.size() == 1) {
                ((JMenuItem)object4).setEnabled(bl);
            } else {
                ((JMenuItem)object4).setEnabled(false);
            }
            ((EditorTabSelectMenu)object4).setActionListener((ActionListener)object);
            wbPopupMenu.add((JMenuItem)object4);
        }
        object4 = new ScriptDbObjectAction(dbTreePanel, wbSelectionModel, "MnuTxtShowSource");
        ((WbAction)object4).setEnabled(bl);
        ((ScriptDbObjectAction)object4).setShowSinglePackageProcedure(true);
        wbPopupMenu.add((Action)object4);
        if (dbTreePanel.getConnection().getMetadata().isOracle()) {
            object = new CompileDbObjectAction(dbTreePanel, wbSelectionModel);
            wbPopupMenu.add((Action)object);
        }
        wbPopupMenu.addSeparator();
        if (ContextMenuFactory.onlyColumnsSelected(list)) {
            object = new CreateIndexAction(dbTreePanel, null);
            ((CreateIndexAction)object).setConnection(dbTreePanel.getConnection());
            wbPopupMenu.add((Action)object);
            wbPopupMenu.addSeparator();
        }
        object = new DropDbObjectAction(dbTreePanel, wbSelectionModel);
        ((WbAction)object).setEnabled(n > 0);
        ((DropDbObjectAction)object).addDropListener(dbTreePanel);
        wbPopupMenu.add((Action)object);
        boolean bl3 = ContextMenuFactory.onlyTablesSelected(list);
        CreateDropScriptAction createDropScriptAction = new CreateDropScriptAction(dbTreePanel, wbSelectionModel);
        createDropScriptAction.setEnabled(bl3);
        wbPopupMenu.add(createDropScriptAction);
        DeleteTablesAction deleteTablesAction = new DeleteTablesAction(dbTreePanel, wbSelectionModel, null);
        deleteTablesAction.setEnabled(bl3);
        wbPopupMenu.add(deleteTablesAction);
        return wbPopupMenu;
    }

    private static boolean onlyColumnsSelected(List<ObjectTreeNode> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (ObjectTreeNode objectTreeNode : list) {
            if (objectTreeNode.getDbObject() instanceof ColumnIdentifier) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyTablesSelected(List<ObjectTreeNode> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (ObjectTreeNode objectTreeNode : list) {
            if (objectTreeNode.getDbObject() instanceof TableIdentifier) continue;
            return false;
        }
        return true;
    }
}

