/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import workbench.db.DbObject;
import workbench.gui.dbobjects.QuickFilterExpressionBuilder;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.RootNode;
import workbench.resource.DbExplorerSettings;
import workbench.storage.filter.ColumnExpression;
import workbench.util.StringUtil;

public class DbObjectTreeModel
extends DefaultTreeModel {
    public DbObjectTreeModel() {
        super(new RootNode());
    }

    public DbObjectTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public ObjectTreeNode findNodeByType(String string, String string2) {
        if (StringUtil.isEmptyString(string) || StringUtil.isEmptyString(string2)) {
            return null;
        }
        return this.findNodeByType(this.getRoot(), string, string2);
    }

    public ObjectTreeNode findNodeByType(ObjectTreeNode objectTreeNode, String string, String string2) {
        if (objectTreeNode.getName().equalsIgnoreCase(string) && objectTreeNode.getType().equalsIgnoreCase(string2)) {
            return objectTreeNode;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            ObjectTreeNode objectTreeNode3 = this.findNodeByType(objectTreeNode2, string, string2);
            if (objectTreeNode3 == null) continue;
            return objectTreeNode3;
        }
        return null;
    }

    public void removeObjects(List<DbObject> list) {
        this.resetFilter();
        this.removeObjects(list, this.getRoot());
    }

    private void removeObjects(List<DbObject> list, ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        if (objectTreeNode.getChildCount() == 0) {
            return;
        }
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>();
        for (int i = 0; i < objectTreeNode.getChildCount(); ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            DbObject dbObject = objectTreeNode2.getDbObject();
            if (dbObject != null && list.contains(dbObject)) {
                arrayList.add(objectTreeNode2);
                continue;
            }
            if (!objectTreeNode2.canHaveChildren()) continue;
            this.removeObjects(list, objectTreeNode2);
        }
        for (ObjectTreeNode objectTreeNode2 : arrayList) {
            objectTreeNode.remove(objectTreeNode2);
        }
        if (arrayList.size() > 0) {
            this.nodeStructureChanged(objectTreeNode);
        }
    }

    @Override
    public ObjectTreeNode getRoot() {
        return (ObjectTreeNode)super.getRoot();
    }

    public void resetFilter() {
        this.resetFilter(this.getRoot());
        this.nodeStructureChanged(this.getRoot());
    }

    public void resetFilter(ObjectTreeNode objectTreeNode) {
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            objectTreeNode2.resetFilter();
            this.resetFilter(objectTreeNode2);
        }
    }

    public void applyFilter(String string) {
        if (StringUtil.isEmptyString(string)) {
            this.resetFilter();
        } else {
            QuickFilterExpressionBuilder quickFilterExpressionBuilder = new QuickFilterExpressionBuilder();
            ColumnExpression columnExpression = quickFilterExpressionBuilder.buildExpression(string, DbExplorerSettings.getUsePartialMatch());
            this.applyFilter(this.getRoot(), columnExpression);
        }
    }

    private boolean applyFilter(ObjectTreeNode objectTreeNode, ColumnExpression columnExpression) {
        int n = objectTreeNode.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2.applyFilter(columnExpression)) {
                bl = true;
                continue;
            }
            if (!this.applyFilter(objectTreeNode2, columnExpression)) continue;
            bl = true;
        }
        if (bl) {
            this.nodeStructureChanged(objectTreeNode);
        }
        return bl;
    }

    public List<ObjectTreeNode> getFilteredNodes() {
        return this.getFilteredNodes(this.getRoot());
    }

    private List<ObjectTreeNode> getFilteredNodes(ObjectTreeNode objectTreeNode) {
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>();
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2.isFiltered()) {
                arrayList.add(objectTreeNode2);
                continue;
            }
            arrayList.addAll(this.getFilteredNodes(objectTreeNode2));
        }
        return arrayList;
    }
}

