/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.EventQueue;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import workbench.db.DbObject;
import workbench.db.DbObjectComparator;
import workbench.db.DbSettings;
import workbench.db.SchemaIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.dbobjects.objecttree.DbObjectNodeRenderer;
import workbench.gui.dbobjects.objecttree.DbObjectTreeModel;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.ObjectTreeDragSource;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.PlainTextTransferhandler;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DbObjectsTree
extends JTree
implements TreeExpansionListener,
Serializable {
    private TreeLoader loader;
    private ObjectTreeDragSource dragSource;
    private WbStatusLabel statusBar;
    private DbObjectNodeRenderer renderer;
    private Map<ObjectTreeNode, Runnable> afterLoadProcess = new ConcurrentHashMap<ObjectTreeNode, Runnable>();
    private boolean ignoreEvents;
    private final ReentrantLock loadLock = new ReentrantLock();

    public DbObjectsTree(WbStatusLabel wbStatusLabel) {
        super(new DbObjectTreeModel());
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setShowsRootHandles(true);
        this.addTreeExpansionListener(this);
        this.renderer = new DbObjectNodeRenderer();
        this.setCellRenderer(this.renderer);
        this.setAutoscrolls(true);
        this.setScrollsOnExpand(true);
        this.setEditable(false);
        this.setExpandsSelectedPaths(true);
        this.getSelectionModel().setSelectionMode(4);
        this.setRowHeight(0);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.dragSource = new ObjectTreeDragSource(this);
        this.loader = new TreeLoader();
        this.statusBar = wbStatusLabel;
        this.setTransferHandler(new PlainTextTransferhandler(this));
    }

    public TreeLoader getLoader() {
        return this.loader;
    }

    @Override
    public DbObjectTreeModel getModel() {
        return (DbObjectTreeModel)super.getModel();
    }

    public WbConnection getConnection() {
        if (this.loader == null) {
            return null;
        }
        return this.loader.getConnection();
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection != null && wbConnection != this.getConnection()) {
            this.loader.setConnection(wbConnection);
            this.setModel(this.loader.getModel());
            if (wbConnection.getMetadata().getSynonymReader() != null) {
                this.renderer.setSynonymTypeName(wbConnection.getMetadata().getSynonymReader().getSynonymTypeName());
            }
            this.renderer.setTableTypes(wbConnection.getMetadata().getTableTypes());
            this.renderer.setViewTypes(wbConnection.getDbSettings().getViewTypes());
        } else {
            this.clear();
        }
    }

    public void setTypesToShow(List<String> list) {
        this.loader.setSelectedTypes(list);
    }

    public void clear() {
        if (this.loader != null) {
            this.loader.clear();
            this.setModel(this.loader.getModel());
        }
    }

    private ObjectTreeNode expandAndLoad(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        try {
            int n = treePath.getPathCount();
            ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getPathComponent(0);
            ObjectTreeNode objectTreeNode2 = this.getTreeModel().findNodeByType(objectTreeNode.getName(), objectTreeNode.getType());
            if (!objectTreeNode2.isLoaded()) {
                this.loader.loadChildren(objectTreeNode2);
            }
            this.expandNode(objectTreeNode2);
            for (int i = 1; i < n; ++i) {
                ObjectTreeNode objectTreeNode3 = (ObjectTreeNode)treePath.getPathComponent(i);
                ObjectTreeNode objectTreeNode4 = this.getTreeModel().findNodeByType(objectTreeNode2, objectTreeNode3.getName(), objectTreeNode3.getType());
                if (objectTreeNode4 == null) break;
                if (!objectTreeNode4.isLoaded()) {
                    this.loader.loadChildren(objectTreeNode4);
                }
                this.expandNode(objectTreeNode4);
                objectTreeNode2 = objectTreeNode4;
            }
            return objectTreeNode2;
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not load nodes", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSchemas(Set<String> set) {
        if (!WbSwingUtilities.isConnectionIdle(this, this.loader.getConnection())) {
            return;
        }
        TreePath treePath = this.getSelectionPath();
        try {
            this.loader.getConnection().setBusy(true);
            for (String string : set) {
                this.reloadSchema(string);
            }
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not load schemas", exception);
        }
        finally {
            this.loader.getConnection().setBusy(false);
        }
        ObjectTreeNode objectTreeNode = this.expandAndLoad(treePath);
        EventQueue.invokeLater(() -> {
            if (objectTreeNode != null) {
                Object[] objectArray = this.getTreeModel().getPathToRoot(objectTreeNode);
                TreePath treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            }
        });
    }

    public void selectObject(final DbObject dbObject) {
        ObjectTreeNode objectTreeNode;
        if (dbObject == null) {
            return;
        }
        ObjectTreeNode objectTreeNode2 = this.findSchemaNode(dbObject.getCatalog(), dbObject.getSchema());
        if (objectTreeNode2 == null) {
            objectTreeNode2 = this.getModel().getRoot();
        }
        if ((objectTreeNode = this.findNodeForObject(objectTreeNode2, dbObject)) != null) {
            this.expandNode(objectTreeNode);
            if (objectTreeNode.getDbObject() instanceof TableIdentifier) {
                this.expandColumns(objectTreeNode);
            }
            return;
        }
        if (this.shouldLoadSearchNode(objectTreeNode2)) {
            final ObjectTreeNode objectTreeNode3 = objectTreeNode2;
            WbThread wbThread = new WbThread("SchemaLoader"){

                @Override
                public void run() {
                    DbObjectsTree.this.doLoad(objectTreeNode3, true);
                    ObjectTreeNode objectTreeNode = DbObjectsTree.this.findNodeForObject(objectTreeNode3, dbObject);
                    if (objectTreeNode != null) {
                        EventQueue.invokeLater(() -> DbObjectsTree.this.expandNode(objectTreeNode));
                    }
                }
            };
            wbThread.start();
        }
    }

    private boolean shouldLoadSearchNode(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return false;
        }
        if (objectTreeNode.childrenAreLoaded()) {
            return false;
        }
        return DbTreeSettings.autoLoadSchemasOnFind(this.loader.getConnection().getDbId()) && !this.loader.getConnection().isBusy();
    }

    private ObjectTreeNode findCatalogNode(String string) {
        if (string == null) {
            return null;
        }
        ObjectTreeNode objectTreeNode = this.getModel().getRoot();
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (!objectTreeNode2.isCatalogNode() || !objectTreeNode2.getName().equalsIgnoreCase(string)) continue;
            return objectTreeNode2;
        }
        return null;
    }

    private ObjectTreeNode findSchemaNode(String string, String string2) {
        DbSettings dbSettings = this.loader.getConnection().getDbSettings();
        if (!dbSettings.supportsCatalogs() && !dbSettings.supportsSchemas()) {
            return this.getModel().getRoot();
        }
        ObjectTreeNode objectTreeNode = null;
        if (dbSettings.supportsCatalogs()) {
            objectTreeNode = this.findCatalogNode(string);
        }
        if (string2 == null) {
            if (this.shouldLoadSearchNode(objectTreeNode)) {
                this.doLoad(objectTreeNode, true);
            }
            return objectTreeNode;
        }
        SchemaIdentifier schemaIdentifier = new SchemaIdentifier(string2);
        schemaIdentifier.setCatalog(string);
        ObjectTreeNode objectTreeNode2 = this.getModel().getRoot();
        if (objectTreeNode != null) {
            if (this.shouldLoadSearchNode(objectTreeNode)) {
                this.doLoad(objectTreeNode, true);
            }
            objectTreeNode2 = objectTreeNode;
        }
        return this.findSchemaNode(objectTreeNode2, schemaIdentifier);
    }

    private ObjectTreeNode findSchemaNode(ObjectTreeNode objectTreeNode, SchemaIdentifier schemaIdentifier) {
        if (objectTreeNode == null) {
            return null;
        }
        if (schemaIdentifier == null) {
            return null;
        }
        if (objectTreeNode.isSchemaNode() && schemaIdentifier.equals(objectTreeNode.getDbObject())) {
            return objectTreeNode;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2;
            ObjectTreeNode objectTreeNode3 = objectTreeNode.getChildAt(i);
            if (schemaIdentifier.equals(objectTreeNode3.getDbObject())) {
                return objectTreeNode3;
            }
            if (!objectTreeNode3.isCatalogNode() || (objectTreeNode2 = this.findSchemaNode(objectTreeNode3, schemaIdentifier)) == null) continue;
            return objectTreeNode2;
        }
        return null;
    }

    private ObjectTreeNode findNodeForObject(ObjectTreeNode objectTreeNode, DbObject dbObject) {
        if (objectTreeNode == null) {
            return null;
        }
        if (dbObject == null) {
            return null;
        }
        String string = objectTreeNode.getType();
        if (string == null) {
            return null;
        }
        if (this.loader.isDependencyNode(objectTreeNode)) {
            return null;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2 != null && !objectTreeNode2.isFKTable() && DbObjectComparator.namesAreEqual(dbObject, objectTreeNode2.getDbObject())) {
                return objectTreeNode2;
            }
            ObjectTreeNode objectTreeNode3 = this.findNodeForObject(objectTreeNode2, dbObject);
            if (objectTreeNode3 == null) continue;
            return objectTreeNode3;
        }
        return null;
    }

    private void reloadSchema(String string) {
        ObjectTreeNode objectTreeNode = this.getTreeModel().findNodeByType(string, "schema");
        if (objectTreeNode == null) {
            return;
        }
        objectTreeNode.removeAllChildren();
        try {
            this.loader.reloadSchema(objectTreeNode);
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not load schema", exception);
        }
    }

    public void reload() {
        TreePath treePath = this.getSelectionPath();
        this.reload(treePath);
    }

    public void reload(TreePath treePath) {
        this.load(false);
        try {
            this.ignoreEvents = true;
            this.expandAndLoad(treePath);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    public void load(boolean bl) {
        if (this.loader == null) {
            return;
        }
        if (!this.loadLock.tryLock()) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not obtain lock for loading the DbTree", new Exception("Backtrace"));
            return;
        }
        this.clear();
        try {
            this.loader.load();
            this.setModel(this.loader.getModel());
            if (bl) {
                boolean bl2 = this.loader.getConnection().getDbSettings().supportsCatalogs();
                EventQueue.invokeLater(() -> {
                    boolean bl2 = false;
                    if (bl2) {
                        bl2 = this.selectCurrentCatalog();
                    }
                    if (!bl2) {
                        this.selectCurrentSchema();
                    }
                });
            }
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not load tree", exception);
        }
        finally {
            this.loadLock.unlock();
        }
    }

    private void expandColumns(ObjectTreeNode objectTreeNode) {
        ObjectTreeNode objectTreeNode2;
        if (objectTreeNode == null) {
            return;
        }
        if (objectTreeNode.getDbObject() instanceof TableIdentifier && objectTreeNode.getChildCount() > 0 && (objectTreeNode2 = objectTreeNode.getChildAt(0)).canHaveChildren()) {
            Object[] objectArray = this.getTreeModel().getPathToRoot(objectTreeNode2);
            TreePath treePath = new TreePath(objectArray);
            this.setExpandedState(treePath, true);
            this.scrollPathToVisible(treePath);
        }
    }

    public void expandNode(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        Object[] objectArray = this.getTreeModel().getPathToRoot(objectTreeNode);
        if (objectArray != null) {
            this.selectPath(new TreePath(objectArray));
        }
    }

    public void selectPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.setExpandedState(treePath, true);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCurrentSchema() {
        WbConnection wbConnection = this.loader.getConnection();
        if (wbConnection == null || wbConnection.isBusy() || wbConnection.isClosed()) {
            return;
        }
        try {
            String string = wbConnection.getCurrentSchema();
            ObjectTreeNode objectTreeNode = this.getTreeModel().findNodeByType(string, "schema");
            this.expandNode(objectTreeNode);
            this.loader.endTransaction(new CallerInfo(){});
        }
        catch (Throwable throwable) {
            this.loader.endTransaction(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    private void loadNodeObjects(ObjectTreeNode objectTreeNode) {
        try {
            this.loader.loadNodeObjects(objectTreeNode);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not expand current schema", sQLException);
        }
    }

    public boolean selectCurrentCatalog() {
        WbConnection wbConnection = this.loader.getConnection();
        if (wbConnection == null || wbConnection.isBusy()) {
            return false;
        }
        String string = wbConnection.getCurrentCatalog();
        if (string == null) {
            return false;
        }
        ObjectTreeNode objectTreeNode = this.getTreeModel().findNodeByType(string, "catalog");
        this.expandNode(objectTreeNode);
        if (objectTreeNode != null && wbConnection.getDbSettings().supportsSchemas()) {
            Runnable runnable = () -> {
                String string = this.loader.getConnection().getCurrentSchema();
                ObjectTreeNode objectTreeNode2 = this.getTreeModel().findNodeByType(objectTreeNode, string, "schema");
                if (objectTreeNode2 != null) {
                    this.expandNode(objectTreeNode2);
                }
            };
            this.afterLoadProcess.put(objectTreeNode, runnable);
        }
        return objectTreeNode != null;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (this.ignoreEvents) {
            return;
        }
        if (this.loader == null) {
            return;
        }
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath == null) {
            return;
        }
        final ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
        if (objectTreeNode.isLoaded()) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.loader.getConnection())) {
            return;
        }
        WbThread wbThread = new WbThread("DbTree Load Thread"){

            @Override
            public void run() {
                DbObjectsTree.this.doLoad(objectTreeNode, false);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(ObjectTreeNode objectTreeNode, boolean bl) {
        try {
            Runnable runnable;
            WbSwingUtilities.showWaitCursor(this);
            this.statusBar.setStatusMessage(ResourceMgr.getString("MsgRetrieving"));
            if (!objectTreeNode.isLoaded()) {
                this.loader.loadChildren(objectTreeNode);
            }
            if (bl) {
                this.loadNodeObjects(objectTreeNode);
            }
            if ((runnable = this.afterLoadProcess.get(objectTreeNode)) != null) {
                this.afterLoadProcess.remove(objectTreeNode);
                runnable.run();
            }
        }
        catch (SQLException sQLException) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(sQLException));
            LogMgr.logError(new CallerInfo(){}, "Could not load node: " + objectTreeNode, sQLException);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.statusBar.clearStatusMessage();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void dispose() {
        this.clear();
        this.loader = null;
    }

    private DbObjectTreeModel getTreeModel() {
        return this.getModel();
    }

    public ObjectTreeNode findNodeByType(ObjectTreeNode objectTreeNode, String string) {
        if (!objectTreeNode.canHaveChildren()) {
            return null;
        }
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2 == null || !objectTreeNode2.getType().equals(string)) continue;
            if (!objectTreeNode2.isLoaded()) {
                this.doLoad(objectTreeNode2, objectTreeNode.isNamespace());
            }
            return objectTreeNode2;
        }
        return null;
    }

    public void reloadNode(ObjectTreeNode objectTreeNode) throws SQLException {
        Object object;
        ObjectTreeNode objectTreeNode2;
        int n;
        if (objectTreeNode == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.getConnection())) {
            return;
        }
        if (objectTreeNode.isRoot()) {
            this.reload();
            return;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        for (n = 0; n < objectTreeNode.getChildCount(); ++n) {
            objectTreeNode2 = objectTreeNode.getChildAt(n);
            object = new TreePath(this.getTreeModel().getPathToRoot(objectTreeNode2));
            if (!this.isExpanded((TreePath)object)) continue;
            set.add(objectTreeNode2.getType());
        }
        if (objectTreeNode.isSchemaNode()) {
            this.loader.reloadSchema(objectTreeNode);
        } else {
            objectTreeNode.removeAllChildren();
            this.loader.loadChildren(objectTreeNode);
        }
        if (objectTreeNode.isCatalogNode() || objectTreeNode.isSchemaNode()) {
            for (n = 0; n < objectTreeNode.getChildCount(); ++n) {
                objectTreeNode2 = objectTreeNode.getChildAt(n);
                object = objectTreeNode2.getType();
                if (!set.contains(object)) continue;
                this.setExpandedState(new TreePath(this.getTreeModel().getPathToRoot(objectTreeNode2)), true);
            }
        }
    }

    public void expandNodes(List<TreePath> list) {
        if (list == null) {
            return;
        }
        for (TreePath treePath : list) {
            this.setExpandedState(treePath, true);
        }
    }

    public List<TreePath> getExpandedNodes() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isExpanded(i)) continue;
            TreePath treePath = this.getPathForRow(i);
            arrayList.add(treePath);
        }
        return arrayList;
    }

    public List<TreePath> getFilteredNodes() {
        List<ObjectTreeNode> list = this.getModel().getFilteredNodes();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(list.size());
        for (ObjectTreeNode objectTreeNode : list) {
            arrayList.add(new TreePath(this.getTreeModel().getPathToRoot(objectTreeNode)));
        }
        return arrayList;
    }

    public String getSelectedNamespace() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null || treePath.getPathCount() == 0) {
            return "";
        }
        ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
        if (objectTreeNode == null) {
            return "";
        }
        return objectTreeNode.getLocationInfo();
    }
}

