/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import workbench.db.DbObject;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.objecttree.ObjectFinder;
import workbench.interfaces.TextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class FindObjectAction
extends WbAction {
    private ObjectFinder finder;
    private TextContainer textContainer;
    private WbConnection editorConnection;
    private DbObject toShow;

    public FindObjectAction(TextContainer textContainer) {
        this.initMenuDefinition("MnuTxtFindObjInTree");
        this.textContainer = textContainer;
        this.setEnabled(false);
    }

    public void setFinder(ObjectFinder objectFinder) {
        this.finder = objectFinder;
        this.setEnabled(this.finder != null);
    }

    public void setEditorConnection(WbConnection wbConnection) {
        this.editorConnection = wbConnection;
        this.setEnabled(this.editorConnection != null);
    }

    public void setTargetTable(DbObject dbObject) {
        this.toShow = dbObject;
        this.setEnabled(this.toShow != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.toShow != null) {
            this.showTable(this.toShow);
            return;
        }
        if (this.textContainer == null) {
            return;
        }
        if (this.finder == null) {
            return;
        }
        String string = SqlUtil.getIdentifierAtCursor(this.textContainer, this.editorConnection);
        if (StringUtil.isBlank(string)) {
            return;
        }
        TableIdentifier tableIdentifier = null;
        if (this.editorConnection.isBusy()) {
            LogMgr.logWarning(new CallerInfo(){}, "Can not create full qualified table because the connection is busy");
            tableIdentifier = new TableIdentifier(string, this.editorConnection);
        } else {
            DbObjectFinder dbObjectFinder = new DbObjectFinder(this.editorConnection);
            tableIdentifier = dbObjectFinder.searchObjectOnPath(new TableIdentifier(string, this.editorConnection), null);
        }
        this.showTable(tableIdentifier);
    }

    private void showTable(DbObject dbObject) {
        EventQueue.invokeLater(() -> this.finder.selectObject(dbObject));
    }
}

