/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import workbench.db.ColumnIdentifier;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.gui.dbobjects.objecttree.DbObjectsTree;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;

public class SortColumnsAction
extends WbAction {
    private ObjectTreeNode columnsNode;
    private DbObjectsTree client;
    private boolean sortByName;

    public SortColumnsAction(DbObjectsTree dbObjectsTree, ObjectTreeNode objectTreeNode, boolean bl) {
        this.columnsNode = objectTreeNode;
        this.client = dbObjectsTree;
        this.sortByName = bl;
        if (bl) {
            this.initMenuDefinition("MnuTxtSortColByName");
        } else {
            this.initMenuDefinition("MnuTxtSortColByPos");
        }
        this.setEnabled(this.columnsNode != null && this.columnsNode.getChildCount() > 0);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.sortColumns();
    }

    private void sortColumns() {
        if (this.columnsNode == null) {
            return;
        }
        if (this.client == null) {
            return;
        }
        int n = this.columnsNode.getChildCount();
        if (n <= 0) {
            return;
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((ColumnIdentifier)this.columnsNode.getChildAt(i).getDbObject());
        }
        if (this.sortByName) {
            DbObjectSorter.sort(arrayList, true);
        } else {
            ColumnIdentifier.sortByPosition(arrayList);
        }
        this.columnsNode.removeAllChildren();
        for (ColumnIdentifier columnIdentifier : arrayList) {
            ObjectTreeNode objectTreeNode = new ObjectTreeNode(columnIdentifier);
            this.columnsNode.add(objectTreeNode);
        }
        this.columnsNode.setChildrenLoaded(true);
        this.client.getModel().nodeStructureChanged(this.columnsNode);
    }
}

