/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.BlobHandler;
import workbench.gui.components.EncodingDropDown;
import workbench.gui.components.FlatButton;
import workbench.gui.dialogs.HexViewer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.StringUtil;
import workbench.util.ToolDefinition;

public class BlobInfoDialog
extends JDialog
implements ActionListener {
    private Object blobValue;
    private BlobHandler handler;
    private EscAction escAction;
    private File uploadFile;
    private boolean hasTools = false;
    private boolean setToNull = false;
    public JButton closeButton;
    public EncodingDropDown encodingPanel;
    public JComboBox externalTools;
    public JButton externalViewer;
    public JLabel infoLabel;
    public JPanel jPanel1;
    public JButton saveAsButton;
    public JButton setNullButton;
    public JButton showAsTextButton;
    public JButton showHexButton;
    public JButton showImageButton;
    public JButton uploadButton;

    public BlobInfoDialog(Frame frame, boolean bl, boolean bl2) {
        super(frame, bl);
        this.initComponents();
        this.handler = new BlobHandler();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.escAction = new EscAction(this, this);
        String string = Settings.getInstance().getDefaultBlobTextEncoding();
        this.encodingPanel.setEncoding(string);
        List<ToolDefinition> list = Settings.getInstance().getExternalTools(true, true);
        this.hasTools = list != null && list.size() > 0;
        this.externalViewer.setEnabled(this.hasTools);
        this.externalTools.setEnabled(this.hasTools);
        if (this.hasTools) {
            DefaultComboBoxModel<ToolDefinition> defaultComboBoxModel = new DefaultComboBoxModel<ToolDefinition>();
            String string2 = Settings.getInstance().getLastUsedBlobTool();
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                defaultComboBoxModel.addElement(list.get(i));
                if (!StringUtil.equalString(string2, list.get(i).getName())) continue;
                n = i;
            }
            this.externalTools.setModel(defaultComboBoxModel);
            if (n != -1) {
                this.externalTools.setSelectedIndex(n);
            }
        }
        this.uploadButton.setEnabled(!bl2);
        this.setNullButton.setEnabled(!bl2);
        WbSwingUtilities.center(this, frame);
    }

    public File getUploadedFile() {
        return this.uploadFile;
    }

    public boolean setToNull() {
        return this.setToNull;
    }

    public byte[] getNewValue() {
        return this.handler.getNewValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escAction) {
            this.closeWindow();
        }
    }

    private void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    public void setBlobValue(Object object) {
        this.blobValue = object;
        String string = null;
        string = object instanceof File ? ResourceMgr.getString("LblFileSize") : ResourceMgr.getString("LblBlobSize");
        long l = 0L;
        if (object == null) {
            string = string + ": (null)";
        } else {
            l = this.handler.getBlobSize(this.blobValue);
            string = string + ": " + Long.toString(l) + " Byte";
        }
        this.infoLabel.setText(string);
        if (object instanceof File) {
            this.infoLabel.setToolTipText(object.toString());
        } else {
            this.infoLabel.setToolTipText(this.handler.getByteDisplay(l).toString());
        }
        this.saveAsButton.setEnabled(l > 0L);
        this.showImageButton.setEnabled(l > 0L);
        this.showHexButton.setEnabled(l > 0L);
        this.showAsTextButton.setEnabled(l > 0L);
        this.externalViewer.setEnabled(l > 0L && this.hasTools);
    }

    private void openWithExternalViewer() {
        try {
            File file = File.createTempFile("wb$tmp_", ".data");
            file.deleteOnExit();
            BlobHandler.saveBlobToFile(this.blobValue, file.getAbsolutePath());
            ToolDefinition toolDefinition = (ToolDefinition)this.externalTools.getSelectedItem();
            toolDefinition.runApplication(file.getAbsolutePath());
            Settings.getInstance().setLastUsedBlobTool(toolDefinition.getName());
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error running external program", exception);
            String string = ExceptionUtil.getDisplay(exception);
            WbSwingUtilities.showErrorMessage(this, string);
        }
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.infoLabel = new JLabel();
        this.showAsTextButton = new FlatButton();
        this.saveAsButton = new FlatButton();
        this.encodingPanel = new EncodingDropDown(null, false);
        this.showImageButton = new FlatButton();
        this.uploadButton = new FlatButton();
        this.showHexButton = new FlatButton();
        this.externalViewer = new FlatButton();
        this.externalTools = new JComboBox();
        this.setNullButton = new FlatButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceMgr.getString("TxtBlobInfo"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                BlobInfoDialog.this.formWindowClosed(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BlobInfoDialog.this.closeButtonMouseClicked(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 0, 10, 0);
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.infoLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 0, 8);
        this.jPanel1.add((Component)this.infoLabel, gridBagConstraints);
        this.showAsTextButton.setText(ResourceMgr.getString("LblShowAsTxt"));
        this.showAsTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.showAsTextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(9, 10, 0, 5);
        this.jPanel1.add((Component)this.showAsTextButton, gridBagConstraints);
        this.saveAsButton.setText(ResourceMgr.getString("MnuTxtFileSaveAs"));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.saveAsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(9, 10, 2, 5);
        this.jPanel1.add((Component)this.saveAsButton, gridBagConstraints);
        this.encodingPanel.setLabelVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(9, 8, 0, 10);
        this.jPanel1.add((Component)this.encodingPanel, gridBagConstraints);
        this.showImageButton.setText(ResourceMgr.getString("LblShowAsImg"));
        this.showImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.showImageButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(16, 10, 2, 5);
        this.jPanel1.add((Component)this.showImageButton, gridBagConstraints);
        this.uploadButton.setText(ResourceMgr.getString("LblUploadFile"));
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.uploadButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 8, 2, 10);
        this.jPanel1.add((Component)this.uploadButton, gridBagConstraints);
        this.showHexButton.setText(ResourceMgr.getString("LblShowAsHex"));
        this.showHexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.showHexButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 8, 2, 10);
        this.jPanel1.add((Component)this.showHexButton, gridBagConstraints);
        this.externalViewer.setText(ResourceMgr.getString("LblExternalView"));
        this.externalViewer.setToolTipText(ResourceMgr.getString("d_LblExternalView"));
        this.externalViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.externalViewerActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 10, 11, 5);
        this.jPanel1.add((Component)this.externalViewer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 8, 11, 10);
        this.jPanel1.add((Component)this.externalTools, gridBagConstraints);
        this.setNullButton.setText(ResourceMgr.getString("LblSetNull"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlobInfoDialog.this.setNullButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 8, 0, 10);
        this.jPanel1.add((Component)this.setNullButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void setNullButtonActionPerformed(ActionEvent actionEvent) {
        this.setToNull = true;
        this.closeWindow();
    }

    private void showHexButtonActionPerformed(ActionEvent actionEvent) {
        try {
            byte[] byArray = this.handler.getBlobAsArray(this.blobValue);
            if (byArray == null) {
                WbSwingUtilities.showErrorMessageKey(this, "MsgBlobNotRetrieved");
                return;
            }
            HexViewer hexViewer = new HexViewer(this, ResourceMgr.getString("TxtBlobData"));
            hexViewer.setData(byArray);
            hexViewer.setVisible(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error showing hex data", exception);
        }
    }

    private void showAsTextButtonActionPerformed(ActionEvent actionEvent) {
        if (this.handler.showBlobAsText(this, this.blobValue, this.encodingPanel.getEncoding())) {
            this.uploadFile = null;
        }
    }

    private void saveAsButtonActionPerformed(ActionEvent actionEvent) {
        long l = -1L;
        try {
            String string = FileDialogUtil.getBlobFile(this);
            if (string == null) {
                return;
            }
            l = BlobHandler.saveBlobToFile(this.blobValue, string);
            String string2 = ResourceMgr.getString("MsgBlobSaved");
            File file = new File(string);
            string2 = StringUtil.replace(string2, "%filename%", file.getAbsolutePath());
            l = file.length();
            string2 = StringUtil.replace(string2, "%filesize%", Long.toString(l));
            WbSwingUtilities.showMessage(this, string2);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when writing data file", exception);
            String string = ResourceMgr.getString("ErrBlobSaveError");
            string = string + "\n" + ExceptionUtil.getDisplay(exception);
            WbSwingUtilities.showErrorMessage(this, string);
        }
    }

    private void uploadButtonActionPerformed(ActionEvent actionEvent) {
        String string = FileDialogUtil.getBlobFile(this, false);
        if (string != null) {
            this.uploadFile = new File(string);
        }
    }

    private void showImageButtonActionPerformed(ActionEvent actionEvent) {
        this.handler.showBlobAsImage(this, this.blobValue);
    }

    private void externalViewerActionPerformed(ActionEvent actionEvent) {
        this.openWithExternalViewer();
    }

    private void formWindowClosed(WindowEvent windowEvent) {
        String string = this.encodingPanel.getEncoding();
        Settings.getInstance().setDefaultBlobTextEncoding(string);
    }

    private void closeButtonMouseClicked(MouseEvent mouseEvent) {
        this.closeWindow();
    }
}

