/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.FileUtil;

public class ImagePanel
extends JPanel {
    private Image displayImage;

    public ImagePanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setImage(File file) throws IOException, SQLException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.readImageData(bufferedInputStream);
    }

    public void setImage(Blob blob) throws IOException, SQLException {
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        this.setImage(byArray);
    }

    public void setImage(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        if (byArray.length < 4) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.readImageData(byteArrayInputStream);
    }

    public boolean hasImage() {
        return this.displayImage != null;
    }

    private void readImageData(InputStream inputStream) throws IOException {
        if (this.displayImage != null) {
            this.displayImage.flush();
        }
        try {
            this.displayImage = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            this.displayImage = null;
            LogMgr.logError(new CallerInfo(){}, "Error reading image", exception);
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.displayImage != null) {
            int n3 = this.displayImage.getWidth(this);
            int n4 = this.displayImage.getHeight(this);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (n3 > n || n4 > n2) {
                graphics2D.drawImage(this.displayImage, 0, 0, n, n2, null);
            } else {
                int n5 = (n - n3) / 2;
                int n6 = (n2 - n4) / 2;
                graphics2D.drawImage(this.displayImage, n5, n6, n3, n4, null);
            }
        } else {
            String string = ResourceMgr.getString("ErrImgNotSupp");
            Font font = UIManager.getDefaults().getFont("Label.font");
            Font font2 = font.deriveFont(12.0f);
            graphics.setFont(font2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.stringWidth(string);
            int n8 = fontMetrics.getHeight();
            int n9 = (n - n7) / 2;
            int n10 = (n2 - n8) / 2;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            graphics2D.addRenderingHints(map);
            graphics2D.drawString(string, n9, n10);
        }
    }
}

