/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import workbench.gui.components.EncodingDropDown;
import workbench.gui.components.FlatButton;
import workbench.gui.dialogs.export.ExportOptions;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class GeneralExportOptionsPanel
extends JPanel
implements ExportOptions {
    private JTextField dateFormat;
    private JLabel dateFormatLabel;
    private EncodingDropDown encodingPanel;
    private JSeparator jSeparator1;
    private JTextField nullString;
    private JLabel nullStringLabel;
    private JButton selectColumnsButton;
    private JTextField timestampFormat;
    private JLabel timestampFormatLabel;

    public GeneralExportOptionsPanel() {
        this.initComponents();
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export.general.dateformat", this.getDateFormat());
        settings.setProperty("workbench.export.general.timestampformat", this.getTimestampFormat());
        settings.setProperty("workbench.export.general.encoding", this.getEncoding());
        settings.setExportNullString(this.getNullString());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setDateFormat(settings.getProperty("workbench.export.general.dateformat", ""));
        this.setTimestampFormat(settings.getProperty("workbench.export.general.timestampformat", ""));
        this.setEncoding(settings.getProperty("workbench.export.general.encoding", settings.getDefaultDataEncoding()));
        this.setNullString(settings.getExportNullString());
    }

    @Override
    public void setNullString(String string) {
        this.nullString.setText(string);
    }

    @Override
    public String getNullString() {
        if (StringUtil.isBlank(this.nullString.getText())) {
            return null;
        }
        return this.nullString.getText().trim();
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat.getText();
    }

    @Override
    public String getEncoding() {
        return this.encodingPanel.getEncoding();
    }

    @Override
    public String getTimestampFormat() {
        return this.timestampFormat.getText();
    }

    @Override
    public void setDateFormat(String string) {
        this.dateFormat.setText(string);
    }

    @Override
    public void setEncoding(String string) {
        this.encodingPanel.setEncoding(string);
    }

    @Override
    public void setTimestampFormat(String string) {
        this.timestampFormat.setText(string);
    }

    public void showRetrieveColumnsLabel() {
        this.selectColumnsButton.setText(ResourceMgr.getString("LblRetrieveColumns"));
    }

    public void showSelectColumnsLabel() {
        this.selectColumnsButton.setText(ResourceMgr.getString("LblSelectColumns"));
    }

    public void allowSelectColumns(boolean bl) {
        this.selectColumnsButton.setEnabled(bl);
    }

    public Object addColumnSelectListener(ActionListener actionListener) {
        this.selectColumnsButton.addActionListener(actionListener);
        return this.selectColumnsButton;
    }

    private void initComponents() {
        this.encodingPanel = new EncodingDropDown();
        this.dateFormatLabel = new JLabel();
        this.dateFormat = new JTextField();
        this.timestampFormatLabel = new JLabel();
        this.timestampFormat = new JTextField();
        this.selectColumnsButton = new FlatButton();
        this.nullStringLabel = new JLabel();
        this.nullString = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 4);
        this.add((Component)this.encodingPanel, gridBagConstraints);
        this.dateFormatLabel.setText(ResourceMgr.getString("LblDateFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 7, 0);
        this.add((Component)this.dateFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 7, 4);
        this.add((Component)this.dateFormat, gridBagConstraints);
        this.timestampFormatLabel.setText(ResourceMgr.getString("LblTimestampFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 7, 0);
        this.add((Component)this.timestampFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 7, 4);
        this.add((Component)this.timestampFormat, gridBagConstraints);
        this.selectColumnsButton.setText(ResourceMgr.getString("LblSelectColumns"));
        this.selectColumnsButton.setToolTipText(ResourceMgr.getString("d_LblSelectColumns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 7, 4);
        this.add((Component)this.selectColumnsButton, gridBagConstraints);
        this.nullStringLabel.setText(ResourceMgr.getString("LblNullString"));
        this.nullStringLabel.setToolTipText(ResourceMgr.getString("d_LblNullString"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 7, 0);
        this.add((Component)this.nullStringLabel, gridBagConstraints);
        this.nullString.setToolTipText(ResourceMgr.getString("d_LblNullString"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 7, 4);
        this.add((Component)this.nullString, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }
}

