/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import workbench.gui.dialogs.export.XmlOptions;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class XmlOptionsPanel
extends JPanel
implements XmlOptions {
    private JCheckBox useCdata;
    private JCheckBox verboseXmlCheckBox;
    private ButtonGroup versionGroup;
    private JRadioButton xml10;
    private JRadioButton xml11;

    public XmlOptionsPanel() {
        this.initComponents();
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export.xml.usecdata", this.getUseCDATA());
        settings.setProperty("workbench.export.xml.verbosexml", this.getUseVerboseXml());
        settings.setProperty("workbench.export.xml.xmlversion", this.getXMLVersion());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setUseCDATA(settings.getBoolProperty("workbench.export.xml.usecdata"));
        this.setUseVerboseXml(settings.getBoolProperty("workbench.export.xml.verbosexml", true));
        String string = settings.getProperty("workbench.export.xml.xmlversion", settings.getDefaultXmlVersion());
        if (string.equals("1.0")) {
            this.xml10.setSelected(true);
        } else if (string.equals("1.1")) {
            this.xml11.setSelected(true);
        }
    }

    @Override
    public String getXMLVersion() {
        if (this.xml11.isSelected()) {
            return "1.1";
        }
        return "1.0";
    }

    @Override
    public boolean getUseVerboseXml() {
        return this.verboseXmlCheckBox.isSelected();
    }

    @Override
    public void setUseVerboseXml(boolean bl) {
        this.verboseXmlCheckBox.setSelected(bl);
    }

    @Override
    public boolean getUseCDATA() {
        return this.useCdata.isSelected();
    }

    @Override
    public void setUseCDATA(boolean bl) {
        this.useCdata.setSelected(bl);
    }

    private void initComponents() {
        this.versionGroup = new ButtonGroup();
        this.useCdata = new JCheckBox();
        this.verboseXmlCheckBox = new JCheckBox();
        this.xml10 = new JRadioButton();
        this.xml11 = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.useCdata.setText(ResourceMgr.getString("LblExportUseCDATA"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.useCdata, gridBagConstraints);
        this.verboseXmlCheckBox.setText(ResourceMgr.getString("LblExportVerboseXml"));
        this.verboseXmlCheckBox.setToolTipText(ResourceMgr.getString("d_LblExportVerboseXml"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.verboseXmlCheckBox, gridBagConstraints);
        this.versionGroup.add(this.xml10);
        this.xml10.setSelected(true);
        this.xml10.setText("XML 1.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.xml10, gridBagConstraints);
        this.versionGroup.add(this.xml11);
        this.xml11.setText("XML 1.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.xml11, gridBagConstraints);
    }
}

