/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.util.Collection;
import workbench.gui.editor.KeywordMap;
import workbench.gui.editor.SQLTokenMarker;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.sql.wbcommands.CommandTester;

public class AnsiSQLTokenMarker
extends SQLTokenMarker {
    public AnsiSQLTokenMarker() {
        this.initKeywordMap();
    }

    private void addKeywordList(Collection<String> collection, byte by) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            if (this.keywords.containsKey(string)) continue;
            this.keywords.add(string.toUpperCase().trim(), by);
        }
    }

    public void setIsMicrosoft(boolean bl) {
        this.isMicrosoft = bl;
    }

    public void setIsMySQL(boolean bl) {
        this.isMySql = bl;
    }

    public void initKeywordMap() {
        this.keywords = new KeywordMap(true, 150);
        this.addKeywords();
        this.addWbCommands();
        this.addDataTypes();
        this.addSystemFunctions();
        this.addOperators();
    }

    public void addOperator(String string) {
        this.keywords.add(string, (byte)9);
    }

    public void initKeywordMap(Collection<String> collection, Collection<String> collection2, Collection<String> collection3, Collection<String> collection4) {
        this.keywords = new KeywordMap(true, 150);
        this.addKeywordList(collection, (byte)6);
        this.addWbCommands();
        this.addKeywordList(collection2, (byte)5);
        this.addKeywordList(collection4, (byte)8);
        this.addKeywordList(collection3, (byte)9);
    }

    private void addWbCommands() {
        CommandTester commandTester = new CommandTester();
        for (String string : commandTester.getCommands()) {
            if ("@".equals(string)) continue;
            this.keywords.add(string, (byte)7);
        }
    }

    private void addKeywords() {
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
        this.addKeywordList(sqlKeywordHelper.getKeywords(), (byte)6);
    }

    private void addDataTypes() {
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
        this.addKeywordList(sqlKeywordHelper.getDataTypes(), (byte)5);
    }

    private void addSystemFunctions() {
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
        this.addKeywordList(sqlKeywordHelper.getSqlFunctions(), (byte)8);
    }

    private void addOperators() {
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
        this.addKeywordList(sqlKeywordHelper.getOperators(), (byte)9);
    }
}

