/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class BracketCompleter
implements PropertyChangeListener {
    private char[] openingBrackets;
    private String[] closingBrackets;

    public BracketCompleter() {
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.completechars", new String[0]);
        this.setCompletionPairs(Settings.getInstance().getProperty("workbench.editor.completechars", null));
    }

    public BracketCompleter(String string) {
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.completechars", new String[0]);
        this.setCompletionPairs(string);
    }

    public void setCompletionPairs(String string) {
        if (!BracketCompleter.isValidDefinition(string)) {
            throw new IllegalArgumentException("Not a valid bracket pair definition");
        }
        if (StringUtil.isBlank(string)) {
            this.openingBrackets = null;
            this.closingBrackets = null;
            return;
        }
        int n = string.length() / 2;
        this.openingBrackets = new char[n];
        this.closingBrackets = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            this.openingBrackets[n3] = string.charAt(n2);
            this.closingBrackets[n3] = new String(new char[]{string.charAt(n2 + 1)});
            n2 += 2;
            ++n3;
        }
    }

    public String toString() {
        if (this.openingBrackets == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.openingBrackets.length * 2);
        for (int i = 0; i < this.openingBrackets.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.openingBrackets[i]);
            stringBuilder.append('|');
            stringBuilder.append(this.closingBrackets[i]);
        }
        return stringBuilder.toString();
    }

    public char getOpeningChar(char c) {
        if (this.openingBrackets == null || this.closingBrackets == null) {
            return '\u0000';
        }
        for (int i = 0; i < this.closingBrackets.length; ++i) {
            if (this.closingBrackets[i].charAt(0) != c) continue;
            return this.openingBrackets[i];
        }
        return '\u0000';
    }

    public String getCompletionChar(char c) {
        int n = this.findChar(c);
        if (n < 0) {
            return null;
        }
        return this.closingBrackets[n];
    }

    private int findChar(char c) {
        if (this.openingBrackets == null) {
            return -1;
        }
        for (int i = 0; i < this.openingBrackets.length; ++i) {
            if (this.openingBrackets[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidDefinition(String string) {
        if (StringUtil.isBlank(string)) {
            return true;
        }
        return string.length() % 2 == 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        this.setCompletionPairs(string);
    }

    public void dispose() {
        Settings.getInstance().removePropertyChangeListener(this);
    }
}

