/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.util.List;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class InListCreator {
    private String text;

    public InListCreator(String string) {
        this.text = string;
    }

    public String makeInList() {
        if (StringUtil.isBlank(this.text)) {
            return this.text;
        }
        List<String> list = StringUtil.getLines(this.text);
        return this.makeInList(list, this.needsQuotes(list));
    }

    public String makeQuotedInList() {
        if (StringUtil.isBlank(this.text)) {
            return this.text;
        }
        List<String> list = StringUtil.getLines(this.text);
        return this.makeInList(list, true);
    }

    public String makeInListForNonChar() {
        if (StringUtil.isBlank(this.text)) {
            return this.text;
        }
        List<String> list = StringUtil.getLines(this.text);
        return this.makeInList(list, false);
    }

    private String makeInList(List<String> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.text.length() + list.size() * 5);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        int n = 5;
        n = bl ? Settings.getInstance().getMaxCharInListElements() : Settings.getInstance().getMaxNumInListElements();
        int n2 = 0;
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = StringUtil.trimToNull(list.get(i));
            if (string2 == null) continue;
            if (i == 0) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append(", ");
            }
            if (bl2) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
                bl2 = false;
            }
            boolean bl3 = this.isQuoted(string2);
            if (bl && !bl3) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(string2);
            if (bl && !bl3) {
                stringBuilder.append('\'');
            }
            if (i >= list.size() || (++n2 & n) != n) continue;
            bl2 = true;
            n2 = 0;
        }
        stringBuilder.append(')');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private boolean isQuoted(String string) {
        if (CollectionUtil.isEmpty(string)) {
            return true;
        }
        return (string = string.trim()).startsWith("'") && string.endsWith("'");
    }

    private boolean needsQuotes(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (String string : list) {
            if (StringUtil.isNumber(string)) continue;
            return true;
        }
        return false;
    }
}

