/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.TextUtilities;
import workbench.gui.editor.actions.NextWord;
import workbench.gui.macros.MacroClient;
import workbench.gui.macros.MacroRunner;
import workbench.interfaces.MacroChangeListener;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;

public class MacroExpander
implements MacroChangeListener,
PropertyChangeListener {
    public static final String CURSOR_PLACEHOLDER = "${c}";
    public static final String SELECT_PLACEHOLDER = "${s}";
    private final Object lockMonitor = new Object();
    private Map<String, MacroDefinition> macros;
    private int maxTypingPause = 350;
    private JEditTextArea editor;
    private MacroClient macroClient;

    public MacroExpander(JEditTextArea jEditTextArea, MacroClient macroClient) {
        this.editor = jEditTextArea;
        this.macroClient = macroClient;
        MacroManager.getInstance().addChangeListener(this, this.macroClient.getMacroClientId());
        this.macros = MacroManager.getInstance().getExpandableMacros(this.macroClient.getMacroClientId());
        this.maxTypingPause = GuiSettings.getMaxExpansionPause();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.expand.maxduration", new String[0]);
    }

    public void dispose() {
        MacroManager.getInstance().removeChangeListener(this, this.macroClient.getMacroClientId());
        Settings.getInstance().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.maxTypingPause = GuiSettings.getMaxExpansionPause();
    }

    public int getMacroClientId() {
        return this.macroClient.getMacroClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMap() {
        Object object = this.lockMonitor;
        synchronized (object) {
            this.macros = MacroManager.getInstance().getExpandableMacros(this.getMacroClientId());
        }
    }

    @Override
    public void macroListChanged() {
        EventQueue.invokeLater(this::readMap);
    }

    public boolean hasExpandableMacros() {
        return this.macros.size() > 0;
    }

    public String getReplacement(String string) {
        MacroDefinition macroDefinition = this.macros.get(string);
        if (macroDefinition == null) {
            return null;
        }
        return macroDefinition.getText();
    }

    public boolean expandWordAtCursor() {
        String string;
        String string2;
        int n;
        long l = System.currentTimeMillis() - this.editor.getLastModifiedTime();
        if (!this.hasExpandableMacros()) {
            return false;
        }
        if (l > (long)this.maxTypingPause) {
            return false;
        }
        int n2 = this.editor.getCaretLine();
        String string3 = this.editor.getLineText(n2);
        int n3 = this.editor.getCaretPositionInLine(n2);
        if (n3 < 0) {
            return false;
        }
        int n4 = TextUtilities.findWordStart(string3, n3);
        if (n4 < (n = TextUtilities.findWordEnd(string3, n3)) && n4 >= 0 && (string2 = this.getReplacement(string = string3.substring(n4, n))) != null) {
            this.insertMacroText(string2, n4, n);
            return true;
        }
        return false;
    }

    public void insertMacroText(String string) {
        int n = -1;
        int n2 = -1;
        if (this.editor.isTextSelected()) {
            int n3 = this.editor.getCaretLine();
            int n4 = this.editor.getLineStartOffset(n3);
            n = this.editor.getSelectionStart(n3) - n4;
            n2 = this.editor.getSelectionEnd(n3) - n4;
        }
        this.insertMacroText(string, n, n2);
    }

    private void insertMacroText(String string, int n, int n2) {
        int n3 = -1;
        int n4 = this.editor.getCaretLine();
        int n5 = this.editor.getLineStartOffset(n4);
        MacroRunner macroRunner = new MacroRunner();
        string = macroRunner.handleReplacement(string, this.macroClient, false);
        boolean bl = this.shouldSelect(string);
        int n6 = this.getCaretPositionInString(string);
        if (n6 > -1) {
            n3 = n5 + Math.max(n, 0) + n6;
        }
        string = string.replace(CURSOR_PLACEHOLDER, "").replace(SELECT_PLACEHOLDER, "");
        if (n > -1 && n2 > -1) {
            this.editor.replaceText(n4, n, n2, string);
        } else {
            this.editor.insertText(string);
        }
        if (n3 > -1) {
            this.editor.setCaretPosition(n3);
            if (bl) {
                NextWord.jump(this.editor, true);
            }
        }
    }

    private int getCaretPositionInString(String string) {
        int n = string.indexOf(CURSOR_PLACEHOLDER);
        if (n == -1) {
            n = string.indexOf(SELECT_PLACEHOLDER);
        }
        return n;
    }

    private boolean shouldSelect(String string) {
        return string.indexOf(SELECT_PLACEHOLDER) > -1;
    }
}

