/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.text.Segment;
import workbench.gui.editor.KeywordMap;
import workbench.gui.editor.Token;
import workbench.gui.editor.TokenMarker;

public class SQLTokenMarker
extends TokenMarker {
    private int offset;
    private int lastOffset;
    private int lastKeyword;
    protected boolean isMySql;
    protected boolean isMicrosoft;
    protected KeywordMap keywords;
    private char literalChar = '\u0000';

    @Override
    public char getPendingLiteralChar() {
        return this.literalChar;
    }

    private byte getLiteralId(char c) {
        switch (c) {
            case '\'': {
                return 3;
            }
            case '\"': {
                return 4;
            }
            case '[': 
            case ']': {
                if (this.isMicrosoft) {
                    return 4;
                }
                return 0;
            }
            case '`': {
                if (!this.isMySql) break;
                return 4;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void markTokensImpl(Token token, Segment segment, int n) {
        int n2 = 0;
        char c = this.literalChar = token == null ? (char)'\u0000' : token.getPendingLiteralChar();
        if (this.literalChar != '\u0000') {
            n2 = this.getLiteralId(this.literalChar);
        }
        if (token != null && token.id == 1) {
            n2 = 1;
        }
        char[] cArray = segment.array;
        this.lastOffset = this.lastKeyword = segment.offset;
        this.offset = this.lastKeyword;
        int n3 = segment.count + this.offset;
        block11: for (int i = this.offset; i < n3; ++i) {
            int n4 = i + 1;
            switch (cArray[i]) {
                case '*': {
                    if (n2 == 1 && n3 - i >= 1 && n4 < cArray.length && cArray[n4] == '/') {
                        n2 = 0;
                        this.addToken(n, ++i + 1 - this.lastOffset, (byte)1);
                        if (i + 1 >= n3) {
                            Token token2;
                            Token token3 = this.getLastTokenInLine(n);
                            token3.next = token2 = new Token(0, 0);
                        }
                        this.lastOffset = i + 1;
                        break;
                    }
                    if (n2 != 0) break;
                    this.searchBack(n, segment, i, true);
                    this.addToken(n, 1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '[': {
                    if (!this.isMicrosoft || n2 != 0) break;
                    this.searchBack(n, segment, i, true);
                    n2 = 4;
                    this.literalChar = (char)91;
                    this.lastOffset = i;
                    break;
                }
                case ']': {
                    if (!this.isMicrosoft || n2 != 4 || this.literalChar != '[') break;
                    n2 = 0;
                    this.literalChar = '\u0000';
                    this.addToken(n, n4 - this.lastOffset, (byte)4);
                    this.lastOffset = i + 1;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': {
                    if (n2 != 0) break;
                    this.searchBack(n, segment, i, true);
                    this.addToken(n, 1, (byte)0);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\t': 
                case ' ': 
                case ';': {
                    if (n2 != 0) break;
                    this.searchBack(n, segment, i, false);
                    break;
                }
                case '/': {
                    if (n2 != 0) break;
                    if (n3 - i >= 2 && n4 < cArray.length && cArray[n4] == '*') {
                        this.searchBack(n, segment, i, true);
                        n2 = 1;
                        this.lastOffset = i++;
                        break;
                    }
                    this.searchBack(n, segment, i, true);
                    this.addToken(n, 1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '-': {
                    if (n2 != 0) break;
                    if (n3 - i >= 2 && n4 < cArray.length && cArray[n4] == '-') {
                        this.searchBack(n, segment, i, true);
                        this.addToken(n, n3 - i, (byte)2);
                        this.lastOffset = n3;
                        break block11;
                    }
                    this.searchBack(n, segment, i, true);
                    this.addToken(n, 1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '#': {
                    if (!this.isMySql || n2 != 0 || n3 - i < 1) break;
                    this.searchBack(n, segment, i, true);
                    this.addToken(n, n3 - i, (byte)2);
                    this.lastOffset = n3;
                    break block11;
                }
                case '\"': 
                case '\'': {
                    if (n2 == 0) {
                        this.literalChar = cArray[i];
                        n2 = this.getLiteralId(this.literalChar);
                        this.addToken(n, i - this.lastOffset, (byte)0);
                        this.lastOffset = i;
                        break;
                    }
                    if (!Token.isLiteral(n2) || this.literalChar != cArray[i]) break;
                    n2 = 0;
                    this.addToken(n, i + 1 - this.lastOffset, this.getLiteralId(this.literalChar));
                    this.literalChar = '\u0000';
                    this.lastOffset = i + 1;
                }
            }
        }
        if (n2 == 0) {
            this.searchBack(n, segment, n3, false);
        }
        if (this.lastOffset != n3) {
            this.addToken(n, n3 - this.lastOffset, (byte)n2);
        }
    }

    private void searchBack(int n, Segment segment, int n2, boolean bl) {
        int n3 = n2 - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(n, this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n, n3, by);
            this.lastOffset = n2;
        }
        this.lastKeyword = n2 + 1;
        if (bl && this.lastOffset < n2) {
            this.addToken(n, n2 - this.lastOffset, (byte)0);
        }
    }
}

