/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.text.BadLocationException;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.SyntaxDocument;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class TextCommenter {
    private JEditTextArea editor;

    public TextCommenter(JEditTextArea jEditTextArea) {
        this.editor = jEditTextArea;
    }

    public void toggleComment() {
        String string = this.editor.getCommentChar();
        this.doComment(string, CommentType.toggle);
    }

    public void commentSelection() {
        String string = this.editor.getCommentChar();
        this.doComment(string, CommentType.comment);
    }

    public void unCommentSelection() {
        this.doComment(this.editor.getCommentChar(), CommentType.uncomment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComment(String string, CommentType commentType) {
        int n = this.editor.getSelectionStartLine();
        int n2 = this.getLastRelevantSelectionLine();
        if (string == null) {
            string = "--";
        }
        String string2 = string;
        int n3 = string.length();
        int n4 = this.editor.getSelectionEnd(n2) - this.editor.getLineStartOffset(n2);
        SyntaxDocument syntaxDocument = this.editor.getDocument();
        if (string.equals("--")) {
            string2 = "-- ";
        }
        boolean bl = "--".equals(string);
        try {
            syntaxDocument.beginCompoundEdit();
            for (int i = n; i <= n2; ++i) {
                String string3 = this.editor.getLineText(i);
                boolean bl2 = string3.trim().startsWith(string);
                int n5 = this.editor.getLineStartOffset(i);
                if (commentType == CommentType.comment || commentType == CommentType.toggle && !bl2) {
                    syntaxDocument.insertString(n5, string2, null);
                    continue;
                }
                n4 = string3.indexOf(string);
                if (n4 <= -1) continue;
                int n6 = n3;
                if (bl && string3.length() > n4 + n3 && Character.isWhitespace(string3.charAt(n4 + n3))) {
                    ++n6;
                }
                syntaxDocument.remove(n5, n4 + n6);
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error when processing comment", badLocationException);
        }
        finally {
            syntaxDocument.endCompoundEdit();
        }
    }

    private int getLastRelevantSelectionLine() {
        int n = this.editor.getSelectionStartLine();
        int n2 = this.editor.getSelectionEndLine();
        int n3 = this.editor.getLineStartOffset(n2);
        if (n3 == this.editor.getSelectionEnd() && n2 > n) {
            --n2;
        }
        return n2;
    }

    private static enum CommentType {
        comment,
        uncomment,
        toggle;

    }
}

