/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import workbench.gui.WbSwingUtilities;
import workbench.interfaces.SqlTextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.DelimiterDefinition;
import workbench.sql.formatter.SqlFormatter;
import workbench.sql.formatter.SqlFormatterFactory;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;

public class TextFormatter {
    private String dbId;

    public TextFormatter(String string) {
        this.dbId = string;
    }

    public void formatSql(SqlTextContainer sqlTextContainer, DelimiterDefinition delimiterDefinition) {
        String string = sqlTextContainer.getSelectedStatement();
        SqlFormatter sqlFormatter = SqlFormatterFactory.createFormatter(this.dbId);
        String string2 = null;
        string2 = sqlFormatter.supportsMultipleStatements() ? sqlFormatter.getFormattedSql(string) : this.doFormat(string, sqlFormatter, delimiterDefinition);
        this.updateEditor(sqlTextContainer, string2);
    }

    private void updateEditor(SqlTextContainer sqlTextContainer, String string) {
        WbSwingUtilities.invoke(() -> {
            if (sqlTextContainer.isTextSelected()) {
                boolean bl = sqlTextContainer.isEditable();
                try {
                    sqlTextContainer.setEditable(true);
                    sqlTextContainer.setSelectedText(string);
                }
                finally {
                    sqlTextContainer.setEditable(bl);
                }
            } else {
                sqlTextContainer.setText(string);
            }
        });
    }

    private String doFormat(String string, SqlFormatter sqlFormatter, DelimiterDefinition delimiterDefinition) {
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromDBID(this.dbId));
        scriptParser.setAlternateDelimiter(delimiterDefinition);
        scriptParser.setReturnStartingWhitespace(true);
        scriptParser.setScript(string);
        int n = scriptParser.getSize();
        if (n < 1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 100);
        for (int i = 0; i < n; ++i) {
            String string2 = scriptParser.getCommand(i);
            DelimiterDefinition delimiterDefinition2 = scriptParser.getDelimiterUsed(i);
            boolean bl = this.isEmpty(string2);
            if (bl) {
                stringBuilder.append(string2);
                continue;
            }
            try {
                String string3 = sqlFormatter.getFormattedSql(string2);
                if (i > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string3.trim());
                if (delimiterDefinition2 == null || bl) continue;
                if (delimiterDefinition2.isSingleLine()) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(delimiterDefinition2.getDelimiter());
                continue;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when formatting SQL", exception);
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private boolean isEmpty(String string) {
        SQLLexer sQLLexer = SQLLexerFactory.createLexerForDbId(this.dbId, string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        return sQLToken == null;
    }
}

