/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class WbCompoundEdit
implements UndoableEdit {
    private final List<UndoableEdit> edits = new ArrayList<UndoableEdit>();
    private boolean acceptNew = true;
    private long lastEditTime;

    public int getSize() {
        return this.edits.size();
    }

    public void reset() {
        this.edits.clear();
        this.acceptNew = true;
        this.lastEditTime = 0L;
    }

    public void finished() {
        this.acceptNew = false;
    }

    public UndoableEdit getLast() {
        if (this.edits.isEmpty()) {
            return null;
        }
        return this.edits.get(this.edits.size() - 1);
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.edits.isEmpty()) {
            return;
        }
        for (int i = this.edits.size() - 1; i > -1; --i) {
            UndoableEdit undoableEdit = this.edits.get(i);
            if (!undoableEdit.canUndo() || !undoableEdit.isSignificant()) continue;
            undoableEdit.undo();
        }
    }

    @Override
    public boolean canUndo() {
        if (this.edits.isEmpty()) {
            return false;
        }
        for (UndoableEdit undoableEdit : this.edits) {
            if (undoableEdit.canUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.edits.isEmpty()) {
            return;
        }
        for (UndoableEdit undoableEdit : this.edits) {
            undoableEdit.redo();
        }
    }

    @Override
    public boolean canRedo() {
        if (this.edits.isEmpty()) {
            return false;
        }
        for (UndoableEdit undoableEdit : this.edits) {
            if (undoableEdit.canRedo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void die() {
        for (UndoableEdit undoableEdit : this.edits) {
            undoableEdit.die();
        }
    }

    public long getDurationSinceLastEdit() {
        if (this.getSize() == 0) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastEditTime;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.acceptNew) {
            return false;
        }
        this.lastEditTime = System.currentTimeMillis();
        return this.edits.add(undoableEdit);
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        for (UndoableEdit undoableEdit : this.edits) {
            if (!undoableEdit.isSignificant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPresentationName() {
        UndoableEdit undoableEdit = this.getLast();
        if (undoableEdit == null) {
            return "";
        }
        return undoableEdit.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.getLast();
        if (undoableEdit == null) {
            return "";
        }
        return undoableEdit.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.getLast();
        if (undoableEdit == null) {
            return "";
        }
        return undoableEdit.getRedoPresentationName();
    }
}

