/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.TextUtilities;
import workbench.gui.editor.actions.EditorAction;
import workbench.resource.PlatformShortcuts;

public class NextWord
extends EditorAction {
    protected boolean select;

    public NextWord() {
        super("TxtEdNxtWord", PlatformShortcuts.getDefaultNextWord(false));
        this.select = false;
    }

    public NextWord(String string, KeyStroke keyStroke) {
        super(string, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JEditTextArea jEditTextArea = this.getTextArea(actionEvent);
        NextWord.jump(jEditTextArea, this.select);
    }

    public static void jump(JEditTextArea jEditTextArea, boolean bl) {
        int n = jEditTextArea.getCaretPosition();
        int n2 = jEditTextArea.getCaretLine();
        int n3 = jEditTextArea.getLineStartOffset(n2);
        int n4 = jEditTextArea.getLineEndOffset(n2);
        String string = jEditTextArea.getLineText(jEditTextArea.getCaretLine());
        if ((n -= n3) == string.length()) {
            if (n3 + n == jEditTextArea.getDocumentLength()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            ++n;
        } else {
            n = TextUtilities.findWordEnd(string, n);
        }
        int n5 = 0;
        n5 = n == -1 ? n4 - 1 : n3 + n;
        if (bl) {
            jEditTextArea.select(jEditTextArea.getMarkPosition(), n5);
        } else {
            jEditTextArea.setCaretPosition(n5);
        }
    }
}

