/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor.actions;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import workbench.gui.actions.WbAction;
import workbench.gui.completion.ParameterTipProvider;
import workbench.gui.components.MultiLineToolTip;
import workbench.gui.editor.JEditTextArea;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ShowTipAction
extends WbAction
implements MouseListener,
KeyListener,
AdjustmentListener,
FocusListener {
    private JEditTextArea area;
    private Popup currentPopup;
    private JToolTip currentTooltip;
    private ParameterTipProvider tipProvider;

    public ShowTipAction(JEditTextArea jEditTextArea, ParameterTipProvider parameterTipProvider) {
        this.area = jEditTextArea;
        this.tipProvider = parameterTipProvider;
        this.initMenuDefinition("MnuTxtShowInsertParms", KeyStroke.getKeyStroke(520, 2));
        this.setMenuItemName("MnuTxtSQL");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.tipProvider.getCurrentTooltip();
        if (string == null) {
            this.closeTooltip();
            return;
        }
        this.currentTooltip = new MultiLineToolTip();
        this.currentTooltip.setComponent(this.area);
        this.currentTooltip.setTipText(string);
        this.showPopupAt(this.calculatePopupPosition());
        this.area.notifiyKeyEvents(this);
        this.area.getPainter().addMouseListener(this);
        this.currentTooltip.addMouseListener(this);
        this.area.getHorizontalBar().addAdjustmentListener(this);
        this.area.getVerticalScrollBar().addAdjustmentListener(this);
        this.area.addFocusListener(this);
    }

    private void closeTooltip() {
        try {
            if (this.currentTooltip != null) {
                this.currentTooltip.removeMouseListener(this);
                this.currentTooltip = null;
            }
            if (this.currentPopup != null) {
                this.currentPopup.hide();
                this.currentPopup = null;
            }
            this.area.stopKeyNotification();
            this.area.getPainter().removeMouseListener(this);
            this.area.getHorizontalBar().removeAdjustmentListener(this);
            this.area.getVerticalScrollBar().removeAdjustmentListener(this);
            this.area.removeFocusListener(this);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when closing tip!", exception);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.currentTooltip) {
            this.closeTooltip();
        } else if (mouseEvent.getSource() == this.area) {
            this.updateTooltip();
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "mouseListener was not removed!!", new Exception());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.area) {
            this.closeTooltip();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.area) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.updateTooltip();
                    break;
                }
                default: {
                    this.closeTooltip();
                }
            }
        }
    }

    private void updateTooltip() {
        String string = this.tipProvider.getCurrentTooltip();
        if (string == null) {
            this.closeTooltip();
        } else {
            this.currentTooltip.setTipText(string);
            this.showPopupAt(this.calculatePopupPosition());
        }
    }

    private Point calculatePopupPosition() {
        Point point = this.area.getCursorLocation();
        Point point2 = this.area.getLocationOnScreen();
        int n = this.area.getCaretLine();
        Dimension dimension = this.currentTooltip.getPreferredSize();
        int n2 = (int)dimension.getHeight();
        int n3 = this.area.lineToY(n);
        int n4 = point2.y + n3;
        n4 = n4 - n2 > 0 ? (n4 -= n2) : point2.y + this.area.lineToY(n + 1) + 5;
        Point point3 = new Point(point2.x + point.x, n4);
        return point3;
    }

    private void showPopupAt(Point point) {
        if (this.currentPopup != null) {
            this.currentPopup.hide();
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.currentPopup = popupFactory.getPopup(this.area, this.currentTooltip, point.x, point.y);
        this.currentPopup.show();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.closeTooltip();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.area) {
            this.closeTooltip();
        }
    }
}

