/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.FlatButton;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbFileChooser;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.filter.ColumnExpressionPanel;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.filter.PanelEntry;
import workbench.interfaces.ValidatingComponent;
import workbench.interfaces.ValueProvider;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.DataStoreValueProvider;
import workbench.storage.ResultInfo;
import workbench.storage.filter.AndExpression;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ComplexExpression;
import workbench.storage.filter.ExpressionValue;
import workbench.storage.filter.FilterExpression;
import workbench.storage.filter.OrExpression;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class DefineFilterExpressionPanel
extends JPanel
implements ActionListener,
ValidatingComponent {
    private ValueProvider data;
    private List<PanelEntry> panels = new ArrayList<PanelEntry>();
    private JButton addLineButton;
    private JRadioButton andButton;
    private JRadioButton orButton;
    private JPanel expressions;
    private JScrollPane scroll;
    private JButton saveButton = new JButton();
    private JButton loadButton = new JButton();
    private FilterDefinitionManager filterMgr;

    public DefineFilterExpressionPanel(ValueProvider valueProvider) {
        this(valueProvider, FilterDefinitionManager.getDefaultInstance());
    }

    public DefineFilterExpressionPanel(ValueProvider valueProvider, FilterDefinitionManager filterDefinitionManager) {
        this.data = valueProvider;
        this.expressions = new JPanel();
        this.expressions.setLayout(new GridBagLayout());
        this.filterMgr = filterDefinitionManager;
        this.setLayout(new BorderLayout(0, 2));
        Insets insets = new Insets(0, 0, 0, 0);
        this.orButton = new JRadioButton(ResourceMgr.getString("LblFilterOrOption"));
        this.orButton.setToolTipText(ResourceMgr.getDescription("LblFilterOrOption"));
        this.orButton.setMargin(insets);
        this.andButton = new JRadioButton(ResourceMgr.getString("LblFilterAndOption"));
        this.andButton.setToolTipText(ResourceMgr.getDescription("LblFilterAndOption"));
        this.andButton.setMargin(insets);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.orButton);
        buttonGroup.add(this.andButton);
        this.andButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 0, 0));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(this.andButton);
        jPanel.add(this.orButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.setBorder(BorderFactory.createEtchedBorder());
        this.saveButton.setIcon(IconMgr.getInstance().getLabelIcon("save"));
        this.saveButton.setMargin(insets);
        this.saveButton.setToolTipText(ResourceMgr.getDescription("SaveFilter"));
        this.loadButton.setIcon(IconMgr.getInstance().getLabelIcon("Open"));
        this.loadButton.setMargin(new Insets(0, 0, 0, 0));
        this.loadButton.setToolTipText(ResourceMgr.getDescription("MnuTxtLoadFilter"));
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        wbToolbar.add(this.loadButton);
        wbToolbar.addSeparator();
        wbToolbar.add(this.saveButton);
        jPanel2.add((Component)wbToolbar, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.addLineButton = new FlatButton(ResourceMgr.getString("LblFilterAddLine"));
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight();
        this.addLineButton.setMinimumSize(new Dimension(25, n));
        dimension = this.addLineButton.getPreferredSize();
        this.addLineButton.setPreferredSize(new Dimension((int)dimension.getWidth(), n));
        this.addLineButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 2);
        jPanel2.add(this.addLineButton);
        this.add((Component)jPanel2, "North");
        this.scroll = new JScrollPane(this.expressions);
        this.scroll.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.scroll, "Center");
        dimension = this.addExpressionPanel();
        this.scroll.getVerticalScrollBar().setUnitIncrement((int)dimension.getHeight());
        this.scroll.getHorizontalScrollBar().setUnitIncrement(25);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(ResourceMgr.getString("MsgFilterHelp"));
        jPanel3.add(jLabel);
        this.add((Component)jPanel3, "South");
        double d = dimension.getWidth() + this.scroll.getHorizontalScrollBar().getPreferredSize().getWidth();
        this.expressions.setPreferredSize(new Dimension((int)d, dimension.height * 3));
    }

    private void saveFilter() {
        FilterExpression filterExpression = this.getExpression();
        if (filterExpression == null) {
            WbSwingUtilities.showMessageKey(this, "ErrFilterNotPresent");
            return;
        }
        String string = this.filterMgr.getLastFilterDir();
        FileFilter fileFilter = ExtensionFileFilter.getXmlFileFilter();
        WbFileChooser wbFileChooser = new WbFileChooser(string);
        wbFileChooser.setAcceptAllFileFilterUsed(false);
        wbFileChooser.resetChoosableFileFilters();
        wbFileChooser.addChoosableFileFilter(fileFilter);
        int n = wbFileChooser.showSaveDialog(SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            String string2 = wbFileChooser.getSelectedFile().getAbsolutePath();
            if (!string2.toLowerCase().endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            String string3 = wbFileChooser.getCurrentDirectory().getAbsolutePath();
            this.filterMgr.setLastFilterDir(string3);
            try {
                WbFile wbFile = new WbFile(string2);
                this.filterMgr.saveFilter(filterExpression, wbFile);
            }
            catch (IOException iOException) {
                String string4 = ResourceMgr.getString("ErrLoadingFilter");
                string4 = string4 + "\n" + ExceptionUtil.getDisplay(iOException);
                WbSwingUtilities.showErrorMessage(this, string4);
            }
        }
    }

    public static FilterExpression loadFilter(JComponent jComponent, FilterDefinitionManager filterDefinitionManager) {
        String string = filterDefinitionManager.getLastFilterDir();
        FileFilter fileFilter = ExtensionFileFilter.getXmlFileFilter();
        WbFileChooser wbFileChooser = new WbFileChooser(string);
        wbFileChooser.setAcceptAllFileFilterUsed(false);
        wbFileChooser.resetChoosableFileFilters();
        wbFileChooser.addChoosableFileFilter(fileFilter);
        int n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(jComponent));
        if (n == 0) {
            String string2 = wbFileChooser.getSelectedFile().getAbsolutePath();
            String string3 = wbFileChooser.getCurrentDirectory().getAbsolutePath();
            filterDefinitionManager.setLastFilterDir(string3);
            try {
                return filterDefinitionManager.loadFilter(string2);
            }
            catch (Exception exception) {
                String string4 = ResourceMgr.getString("ErrLoadingFilter");
                string4 = string4 + "\n" + ExceptionUtil.getDisplay(exception);
                WbSwingUtilities.showErrorMessage(jComponent, string4);
            }
        }
        return null;
    }

    private void loadFilter() {
        FilterExpression filterExpression = DefineFilterExpressionPanel.loadFilter(this, this.filterMgr);
        if (filterExpression != null) {
            this.setFilter(filterExpression);
        }
    }

    public void selectColumn(String string) {
        if (this.panels.isEmpty()) {
            return;
        }
        this.panels.get((int)0).expressionPanel.selectColumn(string);
    }

    private void removeAllPanels() {
        this.panels.clear();
        this.expressions.removeAll();
    }

    public void setFilter(FilterExpression filterExpression) {
        if (filterExpression == null) {
            return;
        }
        if (filterExpression instanceof AndExpression) {
            this.andButton.setSelected(true);
        } else if (filterExpression instanceof OrExpression) {
            this.orButton.setSelected(true);
        } else {
            return;
        }
        this.removeAllPanels();
        ComplexExpression complexExpression = (ComplexExpression)filterExpression;
        List<FilterExpression> list = complexExpression.getExpressions();
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                ExpressionValue expressionValue = (ExpressionValue)((Object)list.get(i));
                Dimension dimension = this.addExpressionPanel(expressionValue);
                PanelEntry panelEntry = this.panels.get(this.panels.size() - 1);
                ColumnExpressionPanel columnExpressionPanel = panelEntry.expressionPanel;
                columnExpressionPanel.setExpressionValue(expressionValue);
                if (i > 10) continue;
                n2 += dimension.height;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        Dimension dimension = new Dimension(this.expressions.getPreferredSize().width, (int)((double)n2 * 1.15));
        this.expressions.setPreferredSize(dimension);
        WbSwingUtilities.repaintLater(this);
    }

    @Override
    public boolean validateInput() {
        for (PanelEntry panelEntry : this.panels) {
            ColumnComparator columnComparator = panelEntry.expressionPanel.getComparator();
            if (columnComparator == null) {
                String string = ResourceMgr.getString("ErrFilterNoComparator");
                WbSwingUtilities.showErrorMessage(this, string);
                return false;
            }
            if (panelEntry.expressionPanel.validateInput()) continue;
            String string = ResourceMgr.getString("ErrFilterWrongValue");
            string = StringUtil.replace(string, "%value%", panelEntry.expressionPanel.getInputValue());
            string = StringUtil.replace(string, "%op%", columnComparator.getOperator());
            WbSwingUtilities.showErrorMessage(this, string);
            return false;
        }
        return true;
    }

    public FilterExpression getExpression() {
        ComplexExpression complexExpression = null;
        for (PanelEntry panelEntry : this.panels) {
            FilterExpression filterExpression = (FilterExpression)((Object)panelEntry.expressionPanel.getExpressionValue());
            if (filterExpression == null) continue;
            if (complexExpression == null) {
                complexExpression = this.andButton.isSelected() ? new AndExpression() : new OrExpression();
            }
            complexExpression.addExpression(filterExpression);
        }
        return complexExpression;
    }

    private Dimension addExpressionPanel() {
        return this.addExpressionPanel(null);
    }

    private Dimension addExpressionPanel(ExpressionValue expressionValue) {
        Cloneable cloneable;
        ColumnExpressionPanel columnExpressionPanel = new ColumnExpressionPanel(this.data, expressionValue);
        FlatButton flatButton = new FlatButton(IconMgr.getInstance().getLabelIcon("delete"));
        flatButton.setPreferredSize(new Dimension(21, 21));
        flatButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)columnExpressionPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)flatButton, gridBagConstraints);
        PanelEntry panelEntry = new PanelEntry(jPanel, columnExpressionPanel);
        flatButton.putClientProperty("panel", panelEntry);
        this.panels.add(panelEntry);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        GridBagLayout gridBagLayout = (GridBagLayout)this.expressions.getLayout();
        for (PanelEntry object2 : this.panels) {
            cloneable = gridBagLayout.getConstraints(object2.container);
            cloneable.weighty = 0.0;
            gridBagLayout.setConstraints(object2.container, (GridBagConstraints)cloneable);
        }
        this.expressions.add((Component)jPanel, gridBagConstraints2);
        this.invalidate();
        this.validate();
        this.repaint();
        Dimension dimension = columnExpressionPanel.getPreferredSize();
        Dimension dimension2 = flatButton.getPreferredSize();
        cloneable = new Dimension((int)(dimension.getWidth() + dimension2.getWidth()), (int)dimension.getHeight());
        return cloneable;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveFilter();
        } else if (actionEvent.getSource() == this.loadButton) {
            this.loadFilter();
        } else if (actionEvent.getSource() == this.addLineButton) {
            this.addExpressionPanel();
        } else if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            PanelEntry panelEntry = (PanelEntry)jButton.getClientProperty("panel");
            this.panels.remove(panelEntry);
            this.expressions.remove(panelEntry.container);
            GridBagLayout gridBagLayout = (GridBagLayout)this.expressions.getLayout();
            int n = this.panels.size();
            for (int i = 0; i < n; ++i) {
                panelEntry = this.panels.get(i);
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(panelEntry.container);
                gridBagConstraints.weighty = i < n - 1 ? 0.0 : 1.0;
                gridBagLayout.setConstraints(panelEntry.container, gridBagConstraints);
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public static void showDialog(WbTable wbTable) {
        DefineFilterExpressionPanel.showDialog(wbTable, FilterDefinitionManager.getDefaultInstance());
    }

    public static void showDialog(WbTable wbTable, FilterDefinitionManager filterDefinitionManager) {
        String string;
        DataStore dataStore = wbTable.getDataStore();
        if (dataStore == null) {
            return;
        }
        ResultInfo resultInfo = dataStore.getResultInfo();
        if (resultInfo == null) {
            return;
        }
        DataStoreValueProvider dataStoreValueProvider = new DataStoreValueProvider(dataStore);
        DefineFilterExpressionPanel defineFilterExpressionPanel = new DefineFilterExpressionPanel(dataStoreValueProvider, filterDefinitionManager);
        int n = wbTable.getSelectedColumn();
        FilterExpression filterExpression = wbTable.getLastFilter();
        if (filterExpression != null) {
            defineFilterExpressionPanel.setFilter(filterExpression);
            defineFilterExpressionPanel.doLayout();
        } else if (n > -1) {
            string = resultInfo.getColumnName(n);
            defineFilterExpressionPanel.selectColumn(string);
        }
        string = ResourceMgr.getString("MsgFilterWindowTitle");
        boolean bl = true;
        while (bl) {
            boolean bl2 = ValidatingDialog.showConfirmDialog(SwingUtilities.getWindowAncestor(wbTable), defineFilterExpressionPanel, string);
            if (bl2) {
                if (!defineFilterExpressionPanel.validateInput()) continue;
                FilterExpression filterExpression2 = defineFilterExpressionPanel.getExpression();
                wbTable.applyFilter(filterExpression2);
                bl = false;
                continue;
            }
            bl = false;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        FilterExpression filterExpression = this.getExpression();
        this.saveButton.setEnabled(filterExpression != null);
    }

    @Override
    public void componentDisplayed() {
        if (this.panels.isEmpty()) {
            return;
        }
        PanelEntry panelEntry = this.panels.get(0);
        if (panelEntry == null || panelEntry.expressionPanel == null) {
            return;
        }
        panelEntry.expressionPanel.setFocusToColumn();
    }

    @Override
    public void componentWillBeClosed() {
    }
}

