/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.filter;

import java.util.Date;
import workbench.gui.components.WbTable;
import workbench.storage.filter.AndExpression;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ComparatorFactory;
import workbench.storage.filter.ComplexExpression;
import workbench.storage.filter.DateEqualsComparator;
import workbench.storage.filter.IsNullComparator;
import workbench.storage.filter.NumberEqualsComparator;
import workbench.storage.filter.OrExpression;
import workbench.storage.filter.StringEqualsComparator;
import workbench.util.SqlUtil;

public class SelectionFilter {
    private WbTable client;

    public SelectionFilter(WbTable wbTable) {
        this.client = wbTable;
    }

    public void applyFilter() {
        if (this.client == null) {
            return;
        }
        int n = this.client.getSelectedRowCount();
        int n2 = this.client.getSelectedColumnCount();
        if (n < 1 || n > 1 && n2 != 1) {
            return;
        }
        int[] nArray = null;
        nArray = n2 == this.client.getColumnCount() ? new int[]{this.client.getSelectedColumn()} : this.client.getSelectedColumns();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ComplexExpression complexExpression = null;
        complexExpression = n == 1 ? new AndExpression() : new OrExpression();
        int[] nArray2 = this.client.getSelectedRows();
        for (int i = 0; i < nArray2.length; ++i) {
            int n3 = nArray2[i];
            for (int j = 0; j < nArray.length; ++j) {
                String string = this.client.getColumnName(nArray[j]);
                Object object = this.client.getValueAt(n3, nArray[j]);
                int n4 = this.client.getDataStore().getColumnType(nArray[j]);
                ColumnComparator columnComparator = null;
                if (object == null) {
                    columnComparator = new IsNullComparator();
                } else if (SqlUtil.isCharacterType(n4)) {
                    columnComparator = new StringEqualsComparator();
                } else if (SqlUtil.isNumberType(n4) && object instanceof Number) {
                    columnComparator = new NumberEqualsComparator();
                } else if (SqlUtil.isDateType(n4) && object instanceof Date) {
                    columnComparator = new DateEqualsComparator(n4);
                } else {
                    ComparatorFactory comparatorFactory = new ComparatorFactory();
                    columnComparator = comparatorFactory.findEqualityComparatorFor(object.getClass());
                }
                if (columnComparator == null) continue;
                complexExpression.addColumnExpression(string, columnComparator, object);
            }
        }
        if (complexExpression.hasFilter()) {
            this.client.applyFilter(complexExpression);
        }
    }
}

