/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.help;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.BrowserLauncher;
import workbench.util.ClasspathUtil;
import workbench.util.ExceptionUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class HelpManager {
    public static final String TOPIC_ALTERNATE_DELIMITER = "understand-alternate-delim";

    public static WbFile getDefaultPdf() {
        String string = Settings.getInstance().getProperty("workbench.manual.pdf.file", "SQLWorkbench-Manual.pdf");
        WbFile wbFile = new WbFile(string);
        if (wbFile.isDirectory()) {
            wbFile = new WbFile(wbFile, "SQLWorkbench-Manual.pdf");
        }
        if (wbFile.exists()) {
            return wbFile;
        }
        ClasspathUtil classpathUtil = new ClasspathUtil();
        String string2 = classpathUtil.getJarPath();
        WbFile wbFile2 = new WbFile(string2, string);
        return wbFile2;
    }

    public static WbFile getPDFManualPath() {
        WbFile wbFile = HelpManager.getDefaultPdf();
        if (wbFile.exists() && wbFile.canRead()) {
            return wbFile;
        }
        if (!wbFile.exists()) {
            wbFile = new WbFile(Settings.getInstance().getConfigDir(), wbFile.getFileName());
        }
        if (wbFile.exists() && wbFile.canRead()) {
            return wbFile;
        }
        return null;
    }

    public static File getHtmlManualDir() {
        String string = Settings.getInstance().getProperty("workbench.manual.html.dir", null);
        File file = null;
        if (string == null) {
            ClasspathUtil classpathUtil = new ClasspathUtil();
            File file2 = classpathUtil.getJarFile().getParentFile();
            file = new File(file2, "manual");
        } else {
            file = new File(string);
        }
        if (!file.exists()) {
            file = new File(Settings.getInstance().getConfigDir(), "manual");
        }
        if (file.exists()) {
            return file;
        }
        LogMgr.logWarning(new CallerInfo(){}, "Help directory '" + file.getAbsolutePath() + "' not found!");
        return null;
    }

    public static void showPdfHelp() {
        final WbFile wbFile = HelpManager.getPDFManualPath();
        if (wbFile == null) {
            ClasspathUtil classpathUtil = new ClasspathUtil();
            String string = HelpManager.getDefaultPdf().getFullPath();
            String string2 = ResourceMgr.getFormattedString("ErrManualNotFound", string, classpathUtil.getJarPath());
            WbSwingUtilities.showMessage(WbManager.getInstance().getCurrentWindow(), string2);
            return;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Using PDF: " + wbFile.getFullPath());
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            WbThread wbThread = new WbThread("OpenPDF"){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(wbFile);
                    }
                    catch (Exception exception) {
                        LogMgr.logError(new CallerInfo(){}, "Error when running PDF Viewer", exception);
                        WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
                    }
                }
            };
            wbThread.start();
        } else {
            LogMgr.logError(new CallerInfo(){}, "Desktop not supported!", null);
            WbSwingUtilities.showErrorMessage("Desktop not supported by your Java version");
        }
    }

    public static void showHistory() {
        WbFile wbFile = HelpManager.getDefaultPdf();
        WbFile wbFile2 = new WbFile(wbFile.getParent(), "history.html");
        if (!wbFile2.exists()) {
            String string = ResourceMgr.getFormattedString("ErrHelpFileNotFound", "history.html", wbFile.getParent());
            WbSwingUtilities.showErrorMessage(WbManager.getInstance().getCurrentWindow(), string);
            return;
        }
        try {
            BrowserLauncher.openURL(wbFile2.toURI());
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error displaying manual", exception);
        }
    }

    public static void showHelpFile(String string) {
        HelpManager.showHelpFile(string, null);
    }

    public static void showHelpFile(String string, String string2) {
        String string3 = Settings.getInstance().useSinglePageHelp() ? "workbench-manual-single.html" : (string != null ? string + ".html" : "workbench-manual.html");
        File file = HelpManager.getHtmlManualDir();
        if (file == null) {
            HelpManager.showOnlineHelp(string3, string2);
            return;
        }
        File file2 = new File(file, string3);
        if (!file2.exists()) {
            LogMgr.logInfo(new CallerInfo(){}, "Help file: '" + file2 + "' not found. Showing online help");
            HelpManager.showOnlineHelp(string3, string2);
            return;
        }
        try {
            String string4 = file2.toURI().toURL().toString();
            if (Settings.getInstance().useSinglePageHelp() && string != null) {
                string4 = string4 + "#" + string;
            } else if (string2 != null) {
                string4 = string4 + "#" + string2;
            }
            BrowserLauncher.openURL(new URI(string4));
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error displaying manual", exception);
        }
    }

    private static void showOnlineHelp(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = string == null ? "" : string;
            if (string2 != null) {
                string3 = string3 + "#" + string2;
            }
            String string5 = "https://www.sql-workbench.eu/";
            if (WbManager.getInstance().isDevBuild()) {
                string5 = string5 + "dev";
            }
            string5 = string5 + "manual/";
            BrowserLauncher.openURL(string5 + string3);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not open online help", exception);
        }
    }

    public static void showHelpIndex() {
        HelpManager.showHelpFile("workbench-manual");
    }

    public static void showDataPumperHelp() {
        HelpManager.showHelpFile("data-pumper");
    }

    public static void showOptionsHelp() {
        HelpManager.showHelpFile("options");
    }

    public static void showProfileHelp() {
        HelpManager.showHelpFile("profiles");
    }

    public static void showDriverHelp() {
        HelpManager.showHelpFile("jdbc-setup");
    }

    public static void showDateFormatHelp() {
        HelpManager.showHelpFile("options", "options-date-format");
    }

    public static void showNumberFormatHelp() {
        HelpManager.showHelpFile("options", "options-number-format");
    }
}

