/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.lnf;

import java.awt.Font;
import java.awt.Toolkit;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class FontScaler {
    private final boolean scaleFont;
    private final int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
    private final int defaultDPI = Settings.getInstance().getIntProperty("workbench.gui.desktop.defaultdpi", 96);
    private final float scaleFactor;

    public FontScaler() {
        float f = Settings.getInstance().getScaleFactor();
        if (f > 0.0f) {
            this.scaleFont = true;
            this.scaleFactor = f;
        } else if (this.dpi == this.defaultDPI) {
            this.scaleFont = false;
            this.scaleFactor = 1.0f;
        } else {
            this.scaleFont = true;
            this.scaleFactor = (float)this.dpi / (float)this.defaultDPI;
        }
    }

    public boolean doScaleFonts() {
        return this.scaleFont;
    }

    public void logSettings() {
        if (this.scaleFont) {
            LogMgr.logInfo(new CallerInfo(){}, "Current DPI: " + this.dpi + ", Default DPI: " + this.defaultDPI + ", scale factor: " + this.scaleFactor);
        } else {
            LogMgr.logInfo(new CallerInfo(){}, "Current DPI: " + this.dpi + ", Default DPI: " + this.defaultDPI);
        }
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public Font scaleFont(Font font) {
        if (!this.scaleFont) {
            return font;
        }
        if (font == null) {
            return null;
        }
        float f = font.getSize2D();
        float f2 = f * this.scaleFactor;
        Font font2 = font.deriveFont(f2);
        return font2;
    }
}

