/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.lnf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Set;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import workbench.gui.components.TabbedPaneUIFactory;
import workbench.gui.lnf.FontScaler;
import workbench.gui.lnf.LnFDefinition;
import workbench.gui.lnf.LnFLoader;
import workbench.gui.lnf.LnFManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;

public class LnFHelper {
    public static final String MENU_FONT_KEY = "MenuItem.font";
    public static final String LABEL_FONT_KEY = "Label.font";
    public static final String TREE_FONT_KEY = "Tree.font";
    private boolean isWindowsClassic;
    private LnFManager lnfManager = new LnFManager();
    private final Set<String> noScale = CollectionUtil.treeSet("Menu.font", "MenuBar.font", "MenuItem.font", "PopupMenu.font", "CheckBoxMenuItem.font");
    private final Set<String> fontProperties = CollectionUtil.treeSet("Button.font", "CheckBox.font", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "EditorPane.font", "FileChooser.font", "Label.font", "List.font", "Menu.font", "MenuBar.font", "MenuItem.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.font", "ScrollPane.font", "Slider.font", "Spinner.font", "TabbedPane.font", "TextArea.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "ViewPort.font");

    public boolean isWindowsClassic() {
        return this.isWindowsClassic;
    }

    public static int getMenuFontHeight() {
        return LnFHelper.getFontHeight(MENU_FONT_KEY);
    }

    public static int getLabelFontHeight() {
        return LnFHelper.getFontHeight(LABEL_FONT_KEY);
    }

    private static int getFontHeight(String string) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        double d = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
        Font font = uIDefaults.getFont(string);
        if (font == null) {
            return 18;
        }
        return (int)Math.ceil((double)font.getSize() * d);
    }

    public void initUI() {
        String string;
        Object object;
        this.initializeLookAndFeel();
        Settings settings = Settings.getInstance();
        UIDefaults uIDefaults = UIManager.getDefaults();
        Font font = settings.getStandardFont();
        if (font != null) {
            object = this.fontProperties.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                uIDefaults.put(string, font);
            }
        } else if (LnFHelper.isWindowsLookAndFeel()) {
            this.scaleDefaultFonts();
        }
        if (LnFHelper.isWebLaf()) {
            this.initializeWebLaf();
        }
        if ((object = settings.getDataFont()) != null) {
            uIDefaults.put("Table.font", object);
            uIDefaults.put("TableHeader.font", object);
        }
        if ((string = TabbedPaneUIFactory.getTabbedPaneUIClass()) != null) {
            uIDefaults.put("TabbedPaneUI", string);
        }
        if (settings.getBoolProperty("workbench.gui.adjustgridcolor", true)) {
            Color color = settings.getColor("workbench.table.gridcolor", new Color(215, 215, 215));
            uIDefaults.put("Table.gridColor", color);
        }
        uIDefaults.put("Button.showMnemonics", (Object)GuiSettings.getShowMnemonics());
        UIManager.put("Synthetica.extendedFileChooser.rememberLastDirectory", false);
    }

    public static boolean isWebLaf() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.contains("WebLookAndFeel");
    }

    public static boolean isGTKLookAndFeel() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.contains("GTKLookAndFeel");
    }

    public static boolean isWindowsLookAndFeel() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.contains("plaf.windows");
    }

    public static boolean isNonStandardLookAndFeel() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return !string.startsWith("com.sun.java") && !string.startsWith("javax.swing.plaf");
    }

    private void scaleDefaultFonts() {
        FontScaler fontScaler = new FontScaler();
        fontScaler.logSettings();
        if (!Settings.getInstance().getScaleFonts()) {
            return;
        }
        if (!fontScaler.doScaleFonts()) {
            return;
        }
        LogMgr.logInfo(new CallerInfo(){}, "Scaling default fonts by: " + fontScaler.getScaleFactor());
        UIDefaults uIDefaults = UIManager.getDefaults();
        boolean bl = Settings.getInstance().getScaleFactor() < 0.0f;
        for (String string : this.fontProperties) {
            Font font;
            if (bl && this.noScale.contains(string) || (font = uIDefaults.getFont(string)) == null) continue;
            Font font2 = fontScaler.scaleFont(font);
            uIDefaults.put(string, font2);
        }
    }

    public static boolean isFlatLaf() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.startsWith("com.formdev.flatlaf");
    }

    public static boolean isJGoodies() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.startsWith("com.jgoodies.looks.plastic");
    }

    private String getDefaultLookAndFeel() {
        if (PlatformHelper.isWindows()) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if (PlatformHelper.isLinux() && this.lnfManager.isFlatLafLibPresent()) {
            return "com.formdev.flatlaf.FlatLightLaf";
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    protected void initializeLookAndFeel() {
        String string = GuiSettings.getLookAndFeelClass();
        try {
            LnFDefinition lnFDefinition;
            if (StringUtil.isEmptyString(string)) {
                string = this.getDefaultLookAndFeel();
            }
            if ((lnFDefinition = this.lnfManager.findLookAndFeel(string)) == null) {
                LogMgr.logError(new CallerInfo(){}, "Specified Look & Feel " + string + " not available!", null);
                this.setSystemLnF();
            } else {
                Object object;
                if (string.contains(".plaf.windows.") && Settings.getInstance().getBoolProperty("workbench.gui.fix.filechooser.bug", false)) {
                    UIManager.put("FileChooser.useSystemExtensionHiding", false);
                }
                UIManager.put("FileChooser.useSystemIcons", Boolean.TRUE);
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                UIManager.put("Synthetica.window.decoration", Boolean.FALSE);
                System.setProperty("substancelaf.noExtraElements", "");
                if (string.startsWith("org.jb2011.lnf.beautyeye")) {
                    UIManager.put("RootPane.setupButtonVisible", false);
                }
                if (string.startsWith("com.formdev.flatlaf")) {
                    object = Settings.getInstance().getColor("workbench.lnf.flatlaf.tab.selectedbackground");
                    if (object != null) {
                        UIManager.put("TabbedPane.selectedBackground", object);
                    }
                    boolean bl = Settings.getInstance().getBoolProperty("lnf.flatlaf.tab.showseparator", true);
                    UIManager.put("TabbedPane.showTabSeparators", bl);
                }
                object = new LnFLoader(lnFDefinition);
                LookAndFeel lookAndFeel = ((LnFLoader)object).getLookAndFeel();
                UIManager.setLookAndFeel(lookAndFeel);
                PlatformHelper.installGtkPopupBugWorkaround();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not set look and feel to [" + string + "]. Look and feel will be ignored", throwable);
            this.setSystemLnF();
        }
        this.checkWindowsClassic(UIManager.getLookAndFeel().getClass().getName());
    }

    private void initializeWebLaf() {
        try {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            Method method = lookAndFeel.getClass().getMethod("initializeManagers", new Class[0]);
            method.invoke(null, (Object[])null);
            UIManager.getDefaults().put("ToolBarUI", "com.alee.laf.toolbar.WebToolBarUI");
            UIManager.getDefaults().put("TabbedPaneUI", "com.alee.laf.toolbar.WebTabbedPaneUI");
            UIManager.getDefaults().put("SplitPaneUI", "com.alee.laf.splitpane.WebSplitPaneUI");
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not initialize WebLaf", throwable);
        }
    }

    private void setSystemLnF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkWindowsClassic(String string) {
        try {
            if (string.contains("com.sun.java.swing.plaf.windows")) {
                String string2 = System.getProperty("os.version", "1.0");
                Float f = Float.valueOf(string2);
                if ((double)f.floatValue() <= 5.0) {
                    this.isWindowsClassic = true;
                } else {
                    this.isWindowsClassic = string.contains("WindowsClassicLookAndFeel");
                    if (!this.isWindowsClassic) {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Boolean bl = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
                        this.isWindowsClassic = bl != null ? bl == false : true;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.isWindowsClassic = false;
        }
    }
}

