/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbCheckBox;
import workbench.gui.components.WbLabelField;
import workbench.gui.editor.MacroExpander;
import workbench.gui.macros.MacroManagerGui;
import workbench.gui.macros.MacroRunner;
import workbench.gui.macros.MacroTreeNode;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;
import workbench.util.StringUtil;

public class MacroManagerDialog
extends JDialog
implements ActionListener,
TreeSelectionListener,
MouseListener,
WindowListener {
    private JList macroList;
    private JButton okButton;
    private JButton runButton;
    private MacroManagerGui macroPanel;
    private JButton cancelButton;
    private boolean cancelled = true;
    private EscAction escAction;
    private SqlPanel client;
    private JCheckBox replaceEditorText;
    private final int macroClient;

    public MacroManagerDialog(Frame frame, SqlPanel sqlPanel, int n) {
        super(frame, true);
        this.client = sqlPanel;
        this.macroClient = n;
        this.initComponents();
        this.initWindow(frame);
        boolean bl = false;
        boolean bl2 = false;
        WbConnection wbConnection = null;
        if (this.client != null) {
            wbConnection = this.client.getConnection();
            bl = this.client.isConnected();
            bl2 = this.client.isBusy();
        }
        this.runButton.setEnabled(bl && !bl2);
        this.runButton.setVisible(bl && !bl2);
        this.replaceEditorText.setVisible(bl && !bl2);
        this.replaceEditorText.setEnabled(bl && !bl2);
        this.initKeys();
        this.addWindowListener(this);
        this.macroPanel.addTreeSelectionListener(this);
        this.macroPanel.setCurrentConnection(wbConnection);
    }

    private void initWindow(Frame frame) {
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.pack();
        }
        WbSwingUtilities.center(this, frame);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.gui.macros.replaceOnRun", false);
        this.replaceEditorText.setSelected(bl);
    }

    private void initKeys() {
        if (this.runButton.isEnabled()) {
            this.getRootPane().setDefaultButton(this.runButton);
        } else {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        this.escAction = new EscAction(this, this);
    }

    private void initComponents() {
        this.macroPanel = new MacroManagerGui(this.macroClient);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.runButton = new WbButton(ResourceMgr.getString("LblRunMacro"));
        this.runButton.setToolTipText(ResourceMgr.getDescription("LblManageMacrosRun"));
        this.okButton = new WbButton(ResourceMgr.getString("LblOK"));
        this.okButton.setToolTipText(ResourceMgr.getDescription("LblManageMacrosOK"));
        this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
        this.cancelButton.setToolTipText(ResourceMgr.getDescription("LblManageMacrosCancel"));
        this.setTitle(ResourceMgr.getString("TxtMacroManagerWindowTitle"));
        this.setModal(true);
        this.setName("MacroManagerDialog");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MacroManagerDialog.this.closeDialog(windowEvent);
            }
        });
        this.macroPanel.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), BorderFactory.createEtchedBorder()));
        this.getContentPane().add((Component)this.macroPanel, "Center");
        this.replaceEditorText = new WbCheckBox(ResourceMgr.getString("LblReplaceCurrentSql"));
        this.replaceEditorText.setToolTipText(ResourceMgr.getDescription("LblReplaceCurrentSql"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.replaceEditorText);
        jPanel.add(jPanel2);
        this.runButton.addActionListener(this);
        this.runButton.setEnabled(false);
        jPanel.add(this.runButton);
        this.okButton.addActionListener(this);
        jPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        String string = ResourceMgr.getFormattedString("LblCurrMacros", MacroManager.getInstance().getMacros(this.macroClient).getCurrentMacroFilename());
        WbLabelField wbLabelField = new WbLabelField(string);
        wbLabelField.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel3.add((Component)wbLabelField, "Before");
        jPanel3.add((Component)jPanel, "After");
        this.getContentPane().add((Component)jPanel3, "South");
        WbSwingUtilities.makeEqualWidth(this.runButton, this.okButton, this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonActionPerformed(actionEvent);
        }
        if (actionEvent.getSource() == this.runButton) {
            this.runButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals(this.escAction.getActionName())) {
            this.cancelButtonActionPerformed(actionEvent);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.macroPanel.saveItem();
            this.cancelled = false;
            this.closeDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runButtonActionPerformed(ActionEvent actionEvent) {
        this.runSelectedMacro();
    }

    private void runSelectedMacro() {
        try {
            this.macroPanel.saveItem();
            this.cancelled = false;
            this.closeDialog();
            if (this.client != null) {
                MacroDefinition macroDefinition = this.macroPanel.getSelectedMacro();
                if (macroDefinition.getExpandWhileTyping()) {
                    MacroExpander macroExpander = this.client.getEditor().getMacroExpander();
                    macroExpander.insertMacroText(macroDefinition.getText());
                } else {
                    MacroRunner macroRunner = new MacroRunner();
                    macroRunner.runMacro(macroDefinition, this.client, this.replaceEditorText.isSelected());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeDialog();
    }

    public void closeDialog() {
        Settings.getInstance().storeWindowSize(this);
        this.macroPanel.saveSettings();
        Settings.getInstance().setProperty("workbench.gui.macros.replaceOnRun", this.replaceEditorText.isSelected());
        this.macroPanel.dispose();
        this.setVisible(false);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        int n = 0;
        boolean bl = true;
        for (TreePath treePath : treePathArray) {
            if (!treeSelectionEvent.isAddedPath(treePath)) continue;
            ++n;
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            boolean bl2 = bl = bl && !macroTreeNode.getAllowsChildren();
            if (macroTreeNode.getAllowsChildren()) continue;
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode.getDataObject();
            bl = bl && StringUtil.isNonBlank(macroDefinition.getText());
        }
        this.runButton.setEnabled(n == 1 && bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.macroList && mouseEvent.getClickCount() == 2 && this.runButton.isEnabled()) {
            this.runSelectedMacro();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        EventQueue.invokeLater(this.macroPanel::restoreSettings);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

