/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.MultiLineToolTip;
import workbench.gui.macros.MacroListModel;
import workbench.gui.macros.MacroTreeCellRenderer;
import workbench.gui.macros.MacroTreeDragHandler;
import workbench.gui.macros.MacroTreeNode;
import workbench.gui.menu.CutCopyPastePopup;
import workbench.interfaces.ClipboardSupport;
import workbench.interfaces.ExpandableTree;
import workbench.interfaces.GroupTree;
import workbench.resource.ResourceMgr;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.util.StringUtil;

public class MacroTree
extends JTree
implements TreeModelListener,
MouseListener,
ClipboardSupport,
ActionListener,
TreeSelectionListener,
GroupTree,
ExpandableTree {
    private final String pasteCmd = "paste-action";
    private final String sortCmd = "sort-action";
    private MacroListModel macroModel;
    private MacroTreeNode[] clipboardNodes;
    private static final int CLIP_COPY = 1;
    private static final int CLIP_CUT = 2;
    private int clipboardType;
    private CutCopyPastePopup popup;
    private WbAction pasteToFolderAction;
    private WbAction sortMacrosAction;
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private final int macroClientId;

    public MacroTree(int n, boolean bl) {
        super(new MacroListModel(new MacroStorage(), false));
        this.macroClientId = n;
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.loadMacros(bl);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setExpandsSelectedPaths(true);
        this.addMouseListener(this);
        this.getSelectionModel().setSelectionMode(4);
        this.addTreeSelectionListener(this);
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        this.popup = new CutCopyPastePopup(this);
        WbAction wbAction = this.popup.getPasteAction();
        wbAction.addToInputMap(inputMap, actionMap);
        wbAction = this.popup.getCopyAction();
        wbAction.addToInputMap(inputMap, actionMap);
        wbAction = this.popup.getCutAction();
        wbAction.addToInputMap(inputMap, actionMap);
        this.pasteToFolderAction = new WbAction(this, "paste-action");
        this.pasteToFolderAction.removeIcon();
        this.pasteToFolderAction.initMenuDefinition("MnuTxtPasteNewFolder");
        this.popup.addAction(this.pasteToFolderAction, false);
        this.sortMacrosAction = new WbAction(this, "sort-action");
        this.sortMacrosAction.removeIcon();
        this.sortMacrosAction.initMenuDefinition("MnuTxtSortByName");
        this.popup.addAction(this.sortMacrosAction, false);
        MacroTreeCellRenderer macroTreeCellRenderer = new MacroTreeCellRenderer();
        this.setCellRenderer(macroTreeCellRenderer);
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(200, 400));
        new MacroTreeDragHandler(this, 3);
        this.setRowHeight(0);
    }

    @Override
    public MacroListModel getModel() {
        if (this.macroModel == null) {
            return (MacroListModel)super.getModel();
        }
        return this.macroModel;
    }

    public final void loadMacros(boolean bl) {
        if (this.macroModel != null) {
            this.macroModel.removeTreeModelListener(this);
        }
        this.macroModel = new MacroListModel(MacroManager.getInstance().getMacros(this.macroClientId), bl);
        this.setModel(this.macroModel);
        this.macroModel.addTreeModelListener(this);
    }

    public void addPopupActionAtTop(WbAction wbAction) {
        this.popup.insert(wbAction, 0);
    }

    public void addPopupAction(WbAction wbAction, boolean bl) {
        if (bl) {
            this.popup.addSeparator();
        }
        this.popup.add(wbAction);
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        wbAction.addToInputMap(inputMap, actionMap);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)objectArray[0];
        Object object = macroTreeNode.getDataObject();
        if (object == null) {
            return;
        }
        if (macroTreeNode.getAllowsChildren()) {
            MacroGroup macroGroup = (MacroGroup)macroTreeNode.getDataObject();
            macroGroup.setName(object.toString());
        }
    }

    @Override
    public void expandAll() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            if (treePath == null) continue;
            this.expandPath(treePath);
        }
    }

    @Override
    public void collapseAll() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            if (treePath == null) continue;
            this.collapsePath(treePath);
        }
    }

    public boolean selectFirstMacro() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            if (macroTreeNode.getChildCount() <= 0) continue;
            MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getChildAt(0);
            this.selectNode(macroTreeNode2);
            return true;
        }
        return false;
    }

    public boolean selectMacro(MacroDefinition macroDefinition) {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            if (macroTreeNode.isLeaf()) continue;
            int n = macroTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                MacroDefinition macroDefinition2;
                MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getChildAt(i);
                if (!macroTreeNode2.isLeaf() || (macroDefinition2 = (MacroDefinition)macroTreeNode2.getDataObject()) != macroDefinition) continue;
                this.selectNode(macroTreeNode2);
                return true;
            }
        }
        return false;
    }

    public void selectMacro(String string, String string2) {
        TreePath[] treePathArray;
        block0: for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            MacroGroup macroGroup;
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            if (macroTreeNode.isLeaf() || !(macroGroup = (MacroGroup)macroTreeNode.getDataObject()).getName().equals(string)) continue;
            this.expandPath(treePath);
            this.selectNode(macroTreeNode);
            int n = macroTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                MacroDefinition macroDefinition;
                MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getChildAt(i);
                if (!macroTreeNode2.isLeaf() || (macroDefinition = (MacroDefinition)macroTreeNode2.getDataObject()) == null || !macroDefinition.getName().equals(string2)) continue;
                this.selectNode(macroTreeNode2);
                continue block0;
            }
        }
    }

    public boolean isModified() {
        MacroStorage macroStorage = this.macroModel.getMacros();
        return macroStorage.isModified();
    }

    public void saveChanges() {
        MacroStorage macroStorage = this.macroModel.getMacros();
        MacroManager.getInstance().getMacros(this.macroClientId).copyFrom(macroStorage);
        MacroManager.getInstance().save(this.macroClientId);
        macroStorage.resetModified();
    }

    public void expandGroups(List<String> list) {
        if (list == null) {
            return;
        }
        TreePath[] treePathArray = this.macroModel.getGroupNodes();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            MacroGroup macroGroup;
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            if (!macroTreeNode.getAllowsChildren() || !list.contains((macroGroup = (MacroGroup)macroTreeNode.getDataObject()).getName()) || this.isExpanded(treePath)) continue;
            this.expandPath(treePath);
        }
    }

    public List<String> getExpandedGroupNames() {
        TreePath[] treePathArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TreePath treePath : treePathArray = this.macroModel.getGroupNodes()) {
            if (!this.isExpanded(treePath)) continue;
            MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
            MacroGroup macroGroup = (MacroGroup)macroTreeNode.getDataObject();
            arrayList.add(macroGroup.getName());
        }
        return arrayList;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public boolean isGroup(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return treeNode.getAllowsChildren();
    }

    private void checkActions() {
        boolean bl = this.onlyGroupSelected();
        boolean bl2 = this.clipboardNodes != null && bl;
        boolean bl3 = this.onlyMacrosSelected();
        this.pasteToFolderAction.setEnabled(bl2);
        this.sortMacrosAction.setEnabled(bl);
        WbAction wbAction = this.popup.getPasteAction();
        wbAction.setEnabled(bl2);
        wbAction = this.popup.getCopyAction();
        wbAction.setEnabled(bl3);
        wbAction = this.popup.getCutAction();
        wbAction.setEnabled(bl3);
    }

    public boolean onlyMacrosSelected() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (!treeNode.getAllowsChildren()) continue;
            return false;
        }
        return true;
    }

    public boolean onlyGroupSelected() {
        if (this.getSelectionCount() > 1) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        return this.onlyGroupSelected(treePathArray);
    }

    public boolean onlyGroupSelected(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode.getAllowsChildren()) continue;
            return false;
        }
        return true;
    }

    protected MacroTreeNode getSelectedNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        if (treePathArray.length != 1) {
            return null;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)this.getLastSelectedPathComponent();
        return macroTreeNode;
    }

    public MacroTreeNode getCurrentGroupNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)this.getLastSelectedPathComponent();
        if (macroTreeNode == null) {
            return null;
        }
        if (macroTreeNode.getAllowsChildren()) {
            return macroTreeNode;
        }
        MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getParent();
        return macroTreeNode2;
    }

    public MacroGroup getCurrentGroup() {
        MacroTreeNode macroTreeNode = this.getCurrentGroupNode();
        if (macroTreeNode == null) {
            return null;
        }
        Object object = macroTreeNode.getDataObject();
        if (object instanceof MacroGroup) {
            return (MacroGroup)object;
        }
        return null;
    }

    public MacroDefinition getSelectedMacro() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        if (treePathArray.length != 1) {
            return null;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)this.getLastSelectedPathComponent();
        if (macroTreeNode == null) {
            return null;
        }
        Object object = macroTreeNode.getDataObject();
        if (object instanceof MacroDefinition) {
            return (MacroDefinition)object;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            TreePath treePath = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.getSelectionCount() == 1 || this.isGroup(treePath)) {
                this.setSelectionPath(treePath);
            }
            this.checkActions();
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void storeSelectedNodes() {
        TreePath[] treePathArray = this.getSelectionPaths();
        this.clipboardNodes = new MacroTreeNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            this.clipboardNodes[i] = (MacroTreeNode)treePathArray[i].getLastPathComponent();
        }
    }

    @Override
    public void copy() {
        this.storeSelectedNodes();
        this.clipboardType = 1;
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void cut() {
        this.storeSelectedNodes();
        this.clipboardType = 2;
    }

    @Override
    public void paste() {
        if (this.clipboardNodes == null) {
            return;
        }
        if (this.clipboardNodes.length == 0) {
            return;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)this.getLastSelectedPathComponent();
        if (macroTreeNode == null) {
            return;
        }
        if (!macroTreeNode.getAllowsChildren()) {
            return;
        }
        try {
            if (this.clipboardType == 2) {
                this.macroModel.moveMacrosToGroup(this.clipboardNodes, macroTreeNode);
            } else if (this.clipboardType == 1) {
                this.macroModel.copyMacrosToGroup(this.clipboardNodes, macroTreeNode);
            }
        }
        finally {
            this.clipboardType = 0;
            this.clipboardNodes = null;
        }
    }

    public void handleDroppedNodes(MacroTreeNode[] macroTreeNodeArray, MacroTreeNode macroTreeNode, int n) {
        if (macroTreeNodeArray == null || macroTreeNodeArray.length < 1) {
            return;
        }
        if (macroTreeNode == null) {
            return;
        }
        if (n == 2) {
            this.macroModel.moveNodes(macroTreeNodeArray, macroTreeNode);
        } else if (n == 1) {
            this.macroModel.copyMacrosToGroup(macroTreeNodeArray, macroTreeNode);
        }
        this.selectNode(macroTreeNodeArray[0]);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getActionCommand().equals("paste-action") && (object = this.addGroup()) != null) {
            this.paste();
        }
        if (actionEvent.getActionCommand().equals("sort-action")) {
            if (this.onlyGroupSelected()) {
                object = this.getCurrentGroup();
                this.macroModel.sortByName((MacroGroup)object);
            } else {
                object = this.getSelectedNode();
                if (((DefaultMutableTreeNode)object).getParent() == null) {
                    this.macroModel.sortGroups();
                }
            }
            this.doLayout();
            this.validate();
        }
    }

    public void deleteSelection() {
        MacroTreeNode macroTreeNode = this.getSelectedNode();
        TreePath treePath = null;
        if (macroTreeNode != null) {
            treePath = this.macroModel.deleteNode(macroTreeNode);
        }
        this.selectPath(treePath);
    }

    public boolean addMacro(boolean bl) {
        Object object;
        MacroDefinition macroDefinition = this.getSelectedMacro();
        MacroGroup macroGroup = this.getCurrentGroup();
        if (macroGroup == null) {
            object = this.addGroup();
            if (object == null) {
                return false;
            }
            macroGroup = this.getCurrentGroup();
        }
        object = null;
        if (macroDefinition != null && bl) {
            object = macroDefinition.createCopy();
            ((MacroDefinition)object).setShortcut(null);
            ((MacroDefinition)object).setName(ResourceMgr.getString("TxtCopyOf") + " " + macroDefinition.getName());
        } else {
            object = new MacroDefinition(ResourceMgr.getString("LblNewMacro"), "");
        }
        macroGroup.addMacro((MacroDefinition)object);
        TreePath treePath = this.macroModel.addMacro(macroGroup, (MacroDefinition)object);
        this.selectPath(treePath);
        return treePath != null;
    }

    @Override
    public String addGroup() {
        String string = WbSwingUtilities.getUserInput(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("LblNewProfileGroup"), "");
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (this.macroModel.getMacros().containsGroup(string)) {
            WbSwingUtilities.showErrorMessageKey(SwingUtilities.getWindowAncestor(this), "ErrGroupNotUnique");
            return null;
        }
        TreePath treePath = this.macroModel.addGroup(string);
        this.selectPath(treePath);
        return string;
    }

    public void selectPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void selectNode(MacroTreeNode macroTreeNode) {
        Object[] objectArray = this.macroModel.getPathToRoot(macroTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.selectPath(treePath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.checkActions();
    }

    public void autoscroll(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + this.autoscrollInsets.left, rectangle.y + this.autoscrollInsets.top, rectangle.width - (this.autoscrollInsets.left + this.autoscrollInsets.right), rectangle.height - (this.autoscrollInsets.top + this.autoscrollInsets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - this.autoscrollInsets.left, point.y - this.autoscrollInsets.top, this.autoscrollInsets.left + this.autoscrollInsets.right, this.autoscrollInsets.top + this.autoscrollInsets.bottom);
            this.scrollRectToVisible(rectangle3);
        }
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
        multiLineToolTip.setComponent(this);
        return multiLineToolTip;
    }
}

