/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import workbench.gui.macros.DragType;
import workbench.gui.macros.MacroTreeNode;
import workbench.gui.macros.ReorderBorder;
import workbench.resource.IconMgr;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;

public class MacroTreeCellRenderer
extends DefaultTreeCellRenderer {
    private MacroTreeNode dropTarget;
    private DragType type = DragType.none;
    private final ReorderBorder reorderBorder = new ReorderBorder();
    private final Border moveToGroupBorder;
    private final Border standardBorder = new EmptyBorder(2, 2, 2, 2);

    public MacroTreeCellRenderer() {
        this.setIconTextGap(5);
        this.setLeafIcon(IconMgr.getInstance().getLabelIcon("macro"));
        this.setOpenIcon(IconMgr.getInstance().getLabelIcon("folder-open"));
        this.setClosedIcon(IconMgr.getInstance().getLabelIcon("folder"));
        this.moveToGroupBorder = new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1), new EmptyBorder(1, 1, 1, 1));
    }

    public void setDragType(DragType dragType, MacroTreeNode macroTreeNode) {
        this.type = dragType;
        this.dropTarget = macroTreeNode;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object instanceof MacroTreeNode) {
            MacroTreeNode macroTreeNode = (MacroTreeNode)object;
            Object object2 = macroTreeNode.getDataObject();
            if (object2 instanceof MacroDefinition) {
                MacroDefinition macroDefinition = (MacroDefinition)object2;
                if (macroDefinition.getExpandWhileTyping()) {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("macro_expand"));
                } else {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("macro"));
                }
                this.setToolTipText(macroDefinition.getDisplayTooltip());
            } else if (object2 instanceof MacroGroup) {
                this.setToolTipText(((MacroGroup)object2).getTooltip());
            }
        }
        if (this.dropTarget == object && this.type == DragType.moveItems) {
            this.setBorder(this.moveToGroupBorder);
        } else if (this.dropTarget == object && this.type == DragType.reorderItems) {
            this.setBorder(this.reorderBorder);
        } else {
            this.setBorder(this.standardBorder);
        }
        return component;
    }
}

