/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.tree.TreePath;
import workbench.gui.macros.DragType;
import workbench.gui.macros.MacroTree;
import workbench.gui.macros.MacroTreeCellRenderer;
import workbench.gui.macros.MacroTreeNode;
import workbench.gui.macros.TransferableMacroNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

class MacroTreeDragHandler
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private DragSource dragSource;
    private MacroTree macroTree;
    private TreePath[] draggedEntries;

    MacroTreeDragHandler(MacroTree macroTree, int n) {
        this.macroTree = macroTree;
        this.dragSource = new DragSource();
        new DropTarget(this.macroTree, this);
        this.dragSource.createDefaultDragGestureRecognizer(this.macroTree, n, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.draggedEntries = this.macroTree.getSelectionPaths();
        TransferableMacroNode transferableMacroNode = new TransferableMacroNode(this.draggedEntries);
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, transferableMacroNode, this);
        this.setCurrentDropTargetItem(null, DragType.none);
    }

    private void handleDragSourceEvent(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if (n == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (n == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragSourceEvent(dragSourceDragEvent);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragSourceEvent(dragSourceDragEvent);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.handleDragSourceEvent(dragSourceDragEvent);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.setCurrentDropTargetItem(null, DragType.none);
    }

    private void handleDragTargetEvent(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this.macroTree.autoscroll(point);
        TreePath treePath = this.macroTree.getClosestPathForLocation(point.x, point.y);
        if (treePath == null || this.draggedEntries == null) {
            dropTargetDragEvent.rejectDrag();
            this.setCurrentDropTargetItem(null, DragType.none);
            return;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
        boolean bl = false;
        if (this.draggedEntries.length == 1) {
            bl = !this.draggedEntries[0].getLastPathComponent().equals(macroTreeNode);
        }
        DragType dragType = DragType.none;
        if (bl) {
            dragType = macroTreeNode.getDropType(this.draggedEntries);
        }
        if (dragType != DragType.none) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            this.setCurrentDropTargetItem(macroTreeNode, dragType);
        } else {
            dropTargetDragEvent.rejectDrag();
            this.setCurrentDropTargetItem(null, DragType.none);
        }
    }

    private void setCurrentDropTargetItem(MacroTreeNode macroTreeNode, DragType dragType) {
        MacroTreeCellRenderer macroTreeCellRenderer = (MacroTreeCellRenderer)this.macroTree.getCellRenderer();
        macroTreeCellRenderer.setDragType(dragType, macroTreeNode);
        this.macroTree.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDragTargetEvent(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDragTargetEvent(dropTargetDragEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setCurrentDropTargetItem(null, DragType.none);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.macroTree.getClosestPathForLocation(point.x, point.y);
        MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
        if (this.draggedEntries == null || this.draggedEntries.length > 1 && !macroTreeNode.getAllowsChildren()) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        try {
            MacroTreeNode[] macroTreeNodeArray = new MacroTreeNode[this.draggedEntries.length];
            for (int i = 0; i < this.draggedEntries.length; ++i) {
                macroTreeNodeArray[i] = (MacroTreeNode)this.draggedEntries[i].getLastPathComponent();
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            this.macroTree.handleDroppedNodes(macroTreeNodeArray, macroTreeNode, dropTargetDropEvent.getDropAction());
            dropTargetDropEvent.dropComplete(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when finishing drop", exception);
            dropTargetDropEvent.rejectDrop();
        }
        finally {
            this.draggedEntries = null;
            this.setCurrentDropTargetItem(null, DragType.none);
        }
    }
}

