/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.QuickFilterAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbToolbar;
import workbench.gui.macros.MacroTree;
import workbench.interfaces.QuickFilter;
import workbench.resource.GuiSettings;
import workbench.util.CollectionUtil;

public class MacroTreeQuickFilter
implements KeyListener,
QuickFilter {
    private JTextField filterValue;
    private QuickFilterAction filterAction;
    private WbAction resetFilter;
    private boolean keySelectionInProgress;
    private final MacroTree tree;
    private List<String> openedGroups;

    public MacroTreeQuickFilter(MacroTree macroTree) {
        this.tree = macroTree;
    }

    public JPanel createFilterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(2, 0, 2, 4));
        this.filterValue = new JTextField();
        this.filterAction = new QuickFilterAction(this);
        this.resetFilter = new WbAction(){

            @Override
            public void executeAction(ActionEvent actionEvent) {
                MacroTreeQuickFilter.this.resetFilter();
            }
        };
        this.resetFilter.setIcon("resetfilter");
        this.resetFilter.setEnabled(false);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.add(this.filterAction);
        wbToolbar.add(this.resetFilter);
        wbToolbar.setMargin(WbSwingUtilities.getEmptyInsets());
        wbToolbar.setBorderPainted(true);
        jPanel.add((Component)wbToolbar, "Before");
        jPanel.add((Component)this.filterValue, "Center");
        this.filterValue.addKeyListener(this);
        return jPanel;
    }

    private boolean isEditKey(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\b': 
            case '\f': 
            case '\u007f': 
            case '\u009b': 
            case '\uffd1': {
                return true;
            }
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (Character.isISOControl(keyEvent.getKeyChar()) && !this.isEditKey(keyEvent)) {
            return;
        }
        if (GuiSettings.filterMacroWhileTyping()) {
            EventQueue.invokeLater(this::applyQuickFilter);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() != this.filterValue || keyEvent.getModifiers() != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 39: {
                if (this.keySelectionInProgress) {
                    this.tree.dispatchEvent(keyEvent);
                    break;
                }
                keyEvent.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.keySelectionInProgress = true;
                this.tree.dispatchEvent(keyEvent);
                break;
            }
            case 10: {
                if (this.keySelectionInProgress) {
                    this.tree.dispatchEvent(keyEvent);
                    break;
                }
                keyEvent.consume();
                this.keySelectionInProgress = false;
                this.applyQuickFilter();
                break;
            }
            case 27: {
                if (!this.isFiltered()) break;
                keyEvent.consume();
                this.keySelectionInProgress = false;
                this.resetFilter();
                break;
            }
            default: {
                this.keySelectionInProgress = false;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean isFiltered() {
        return this.tree.getModel().isFiltered();
    }

    @Override
    public void resetFilter() {
        this.tree.getModel().resetFilter();
        this.resetFilter.setEnabled(false);
        if (CollectionUtil.isNonEmpty(this.openedGroups)) {
            this.tree.expandGroups(this.openedGroups);
            this.openedGroups = null;
        }
        this.tree.selectFirstMacro();
    }

    @Override
    public synchronized void applyQuickFilter() {
        if (!this.tree.getModel().isFiltered()) {
            this.openedGroups = this.tree.getExpandedGroupNames();
        }
        String string = this.filterValue.getText();
        this.tree.getModel().applyFilter(string);
        this.tree.expandAll();
        this.tree.selectFirstMacro();
        this.resetFilter.setEnabled(true);
    }
}

