/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.menu;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import workbench.gui.MainWindow;
import workbench.gui.actions.LoadMacroFileAction;
import workbench.gui.actions.LoadWorkspaceFileAction;
import workbench.gui.actions.OpenFileAction;
import workbench.resource.ListItemProperty;
import workbench.resource.Settings;
import workbench.resource.SettingsListener;
import workbench.util.FixedSizeList;
import workbench.util.WbFile;

public class RecentFileManager
implements SettingsListener {
    private final String WKSP_PROP_NAME = "workspace.recent";
    private final String MACROS_PROP_NAME = "macros.recent";
    private final String FILES_PROP_NAME = "files.recent";
    private Map<String, FixedSizeList<WbFile>> recentFiles = new HashMap<String, FixedSizeList<WbFile>>();

    public static RecentFileManager getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private RecentFileManager() {
        Settings.getInstance().addSaveListener(this);
        FixedSizeList fixedSizeList = new FixedSizeList(Settings.getInstance().getIntProperty("workbench.workspace.recent.maxcount", 15));
        FixedSizeList fixedSizeList2 = new FixedSizeList(Settings.getInstance().getIntProperty("workbench.macros.recent.maxcount", 15));
        FixedSizeList fixedSizeList3 = new FixedSizeList(Settings.getInstance().getIntProperty("workbench.files.recent.maxcount", 25));
        this.recentFiles.put("workspace.recent", fixedSizeList);
        this.recentFiles.put("macros.recent", fixedSizeList2);
        this.recentFiles.put("files.recent", fixedSizeList3);
        this.readSettings("workspace.recent");
        this.readSettings("macros.recent");
        this.readSettings("files.recent");
    }

    public void populateRecentWorkspaceMenu(JMenu jMenu, MainWindow mainWindow) {
        jMenu.removeAll();
        FixedSizeList<WbFile> fixedSizeList = this.recentFiles.get("workspace.recent");
        if (fixedSizeList.isEmpty()) {
            jMenu.setEnabled(false);
            return;
        }
        for (WbFile wbFile : fixedSizeList) {
            LoadWorkspaceFileAction loadWorkspaceFileAction = new LoadWorkspaceFileAction(mainWindow, wbFile);
            jMenu.add(loadWorkspaceFileAction);
        }
        jMenu.setEnabled(true);
    }

    public void populateRecentFilesMenu(JMenu jMenu, MainWindow mainWindow) {
        if (jMenu == null) {
            return;
        }
        jMenu.removeAll();
        FixedSizeList<WbFile> fixedSizeList = this.recentFiles.get("files.recent");
        if (fixedSizeList.isEmpty()) {
            jMenu.setEnabled(false);
            return;
        }
        for (WbFile wbFile : fixedSizeList) {
            OpenFileAction openFileAction = new OpenFileAction(mainWindow, wbFile);
            jMenu.add(openFileAction);
        }
        jMenu.setEnabled(true);
    }

    public void populateRecentMacrosMenu(int n, JMenu jMenu) {
        jMenu.removeAll();
        FixedSizeList<WbFile> fixedSizeList = this.recentFiles.get("macros.recent");
        if (fixedSizeList.isEmpty()) {
            jMenu.setEnabled(false);
            return;
        }
        for (WbFile wbFile : fixedSizeList) {
            LoadMacroFileAction loadMacroFileAction = new LoadMacroFileAction(n, wbFile);
            jMenu.add(loadMacroFileAction);
        }
        jMenu.setEnabled(true);
    }

    private void readSettings(String string) {
        FixedSizeList<WbFile> fixedSizeList = this.recentFiles.get(string);
        ListItemProperty listItemProperty = new ListItemProperty(string);
        List<String> list = listItemProperty.getItems();
        for (String string2 : list) {
            WbFile wbFile = new WbFile(string2);
            if (!wbFile.exists()) continue;
            fixedSizeList.append(wbFile);
        }
    }

    public void saveSettings() {
        ListItemProperty listItemProperty = new ListItemProperty("workspace.recent");
        listItemProperty.storeItems(this.getRecentWorkspaces());
        listItemProperty = new ListItemProperty("macros.recent");
        listItemProperty.storeItems(this.getRecentMacroFiles());
        listItemProperty = new ListItemProperty("files.recent");
        listItemProperty.storeItems(this.getRecentFiles());
    }

    @Override
    public void beforeSettingsSave() {
        this.saveSettings();
    }

    private FixedSizeList<WbFile> getRecentMacroFiles() {
        return this.recentFiles.get("macros.recent");
    }

    private FixedSizeList<WbFile> getRecentWorkspaces() {
        return this.recentFiles.get("workspace.recent");
    }

    private FixedSizeList<WbFile> getRecentFiles() {
        return this.recentFiles.get("files.recent");
    }

    public void editorFileLoaded(WbFile wbFile) {
        this.getRecentFiles().add(wbFile);
    }

    public void workspaceLoaded(WbFile wbFile) {
        this.getRecentWorkspaces().addEntry(wbFile);
    }

    public void macrosLoaded(WbFile wbFile) {
        this.getRecentMacroFiles().addEntry(wbFile);
    }

    protected static class LazyInstanceHolder {
        protected static final RecentFileManager INSTANCE = new RecentFileManager();

        protected LazyInstanceHolder() {
        }
    }
}

