/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.preparedstatement;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import workbench.resource.ResourceMgr;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.util.SqlUtil;

public class StatementParameterTableModel
implements TableModel {
    private final String[] columns;
    private Integer[] parameterIndex;
    private String[] types;
    private String[] values;
    private StatementParameters parms;

    public StatementParameterTableModel(StatementParameters statementParameters, boolean bl) {
        this.columns = bl ? new String[]{ResourceMgr.getString("TxtPSParameterIndex"), ResourceMgr.getString("TxtPSParameterName"), ResourceMgr.getString("TxtPSParameterType"), ResourceMgr.getString("TxtPSParameterValue")} : new String[]{ResourceMgr.getString("TxtPSParameterIndex"), ResourceMgr.getString("TxtPSParameterType"), ResourceMgr.getString("TxtPSParameterValue")};
        this.parms = statementParameters;
        int n = statementParameters.getParameterCount();
        this.parameterIndex = new Integer[n];
        this.types = new String[n];
        this.values = new String[n];
        for (int i = 0; i < n; ++i) {
            this.parameterIndex[i] = i + 1;
            this.types[i] = SqlUtil.getTypeName(statementParameters.getParameterType(i));
            Object object = statementParameters.getParameterValue(i);
            this.values[i] = object == null ? "" : object.toString();
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    @Override
    public int getRowCount() {
        return this.parms.getParameterCount();
    }

    public String getParameterValue(int n) {
        return this.values[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.parameterIndex[n];
        }
        if (this.columns.length == 4) {
            switch (n2) {
                case 1: {
                    return this.parms.getParameterName(n);
                }
                case 2: {
                    return this.types[n];
                }
                case 3: {
                    return this.values[n];
                }
            }
        } else {
            switch (n2) {
                case 1: {
                    return this.types[n];
                }
                case 2: {
                    return this.values[n];
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == this.columns.length - 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == this.columns.length - 1) {
            this.values[n] = object == null ? "" : object.toString();
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }
}

