/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.db.ObjectNameFilter;
import workbench.db.TransactionChecker;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.BooleanPropertyEditor;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.IntegerPropertyEditor;
import workbench.gui.components.MapEditor;
import workbench.gui.components.PasswordPropertyEditor;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbColorPicker;
import workbench.gui.components.WbFileChooser;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.help.HelpManager;
import workbench.gui.profiles.ConnectionGuiHelper;
import workbench.gui.profiles.ConnectionPropertiesEditor;
import workbench.gui.profiles.DriverEditorDialog;
import workbench.gui.profiles.EditConnectScriptsPanel;
import workbench.gui.profiles.EditConnectionFiltersPanel;
import workbench.gui.profiles.ProfileChangeListener;
import workbench.gui.profiles.SshConfigPanel;
import workbench.gui.profiles.TagSearchPopup;
import workbench.interfaces.SimplePropertyEditor;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.macros.MacroFileSelector;
import workbench.ssh.SshConfig;
import workbench.ssh.UrlParser;
import workbench.util.CollectionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.ImageUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ConnectionEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
ValidatingComponent,
KeyListener {
    private ConnectionProfile currentProfile;
    private final List<ProfileChangeListener> changeListener = new ArrayList<ProfileChangeListener>();
    private boolean init;
    private List<SimplePropertyEditor> editors = new ArrayList<SimplePropertyEditor>();
    private Set<String> allTags;
    private char echoChar;
    protected JLabel altDelimLabel;
    protected JTextField altDelimiter;
    protected JCheckBox asSysDBA;
    protected JCheckBox cbAutocommit;
    protected JComboBox cbDrivers;
    protected JCheckBox cbIgnoreDropErrors;
    protected JCheckBox cbSeparateConnections;
    protected JCheckBox cbStorePassword;
    protected JCheckBox cbxPromptUsername;
    protected JCheckBox checkOpenTrans;
    protected JCheckBox confirmUpdates;
    protected JPanel controlUpdates;
    protected JButton editConnectionScriptsButton;
    protected JButton editFilterButton;
    protected JButton editVariablesButton;
    protected JCheckBox emptyStringIsNull;
    protected JButton extendedProps;
    protected JLabel fetchSizeLabel;
    protected Box.Filler filler2;
    protected JLabel groupNameLabel;
    protected JCheckBox hideWarnings;
    protected JTextField icon;
    protected JCheckBox includeNull;
    protected WbColorPicker infoColor;
    protected JLabel infoColorLabel;
    protected JCheckBox jCheckBox1;
    protected JLabel jLabel1;
    protected JLabel jLabel2;
    protected JLabel jLabel3;
    protected JLabel jLabel4;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel3;
    protected JPanel jPanel4;
    protected JPanel jPanel5;
    protected JPanel jPanel6;
    protected JPanel jPanel7;
    protected JSeparator jSeparator2;
    protected JSeparator jSeparator3;
    protected JLabel lblDriver;
    protected JLabel lblPwd;
    protected JLabel lblUrl;
    protected JLabel lblUsername;
    protected JTextField macroFile;
    protected JCheckBox preventNoWhere;
    protected JCheckBox readOnly;
    protected JCheckBox rememberExplorerSchema;
    protected JCheckBox removeComments;
    protected JCheckBox rollbackBeforeDisconnect;
    protected JLabel scriptDirLabel;
    protected JButton selectIconButton;
    protected JButton selectMacroFileButton;
    protected JButton selectScriptDirButton;
    protected JButton selectWkspButton;
    protected JButton showPassword;
    protected JButton sshConfig;
    protected JTextField tagList;
    protected JButton testConnectionButton;
    protected JTextField tfFetchSize;
    protected JTextField tfProfileName;
    protected JPasswordField tfPwd;
    protected JTextField tfScriptDir;
    protected JTextField tfTimeout;
    protected JTextField tfURL;
    protected JTextField tfUserName;
    protected JTextField tfWorkspaceFile;
    protected JLabel timeoutLabel;
    protected JPanel timeoutpanel;
    protected JCheckBox trimCharData;
    protected JPanel wbOptionsPanel;
    protected JLabel workspaceFileLabel;

    public ConnectionEditorPanel() {
        this.initComponents();
        this.echoChar = this.tfPwd.getEchoChar();
        String string = this.altDelimLabel.getText();
        this.altDelimLabel.setText("<html><u>" + string + "</u></html>");
        this.altDelimLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HelpManager.showHelpFile("understand-alternate-delim");
            }
        });
        this.tagList.addKeyListener(this);
        this.groupNameLabel.setBorder(new CompoundBorder(DividerBorder.BOTTOM_DIVIDER, new EmptyBorder(3, 6, 3, 6)));
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.tfProfileName);
        wbTraversalPolicy.addComponent(this.cbDrivers);
        wbTraversalPolicy.addComponent(this.tfURL);
        wbTraversalPolicy.addComponent(this.tfUserName);
        wbTraversalPolicy.addComponent(this.asSysDBA);
        wbTraversalPolicy.addComponent(this.tfPwd);
        wbTraversalPolicy.addComponent(this.showPassword);
        wbTraversalPolicy.addComponent(this.cbAutocommit);
        wbTraversalPolicy.addComponent(this.tfFetchSize);
        wbTraversalPolicy.addComponent(this.tfTimeout);
        wbTraversalPolicy.addComponent(this.extendedProps);
        wbTraversalPolicy.addComponent(this.cbxPromptUsername);
        wbTraversalPolicy.addComponent(this.rollbackBeforeDisconnect);
        wbTraversalPolicy.addComponent(this.cbStorePassword);
        wbTraversalPolicy.addComponent(this.confirmUpdates);
        wbTraversalPolicy.addComponent(this.readOnly);
        wbTraversalPolicy.addComponent(this.cbSeparateConnections);
        wbTraversalPolicy.addComponent(this.preventNoWhere);
        wbTraversalPolicy.addComponent(this.cbIgnoreDropErrors);
        wbTraversalPolicy.addComponent(this.includeNull);
        wbTraversalPolicy.addComponent(this.emptyStringIsNull);
        wbTraversalPolicy.addComponent(this.rememberExplorerSchema);
        wbTraversalPolicy.addComponent(this.trimCharData);
        wbTraversalPolicy.addComponent(this.removeComments);
        wbTraversalPolicy.addComponent(this.hideWarnings);
        wbTraversalPolicy.addComponent(this.checkOpenTrans);
        wbTraversalPolicy.addComponent(this.altDelimiter);
        wbTraversalPolicy.addComponent(this.editConnectionScriptsButton);
        wbTraversalPolicy.addComponent(this.tfWorkspaceFile);
        wbTraversalPolicy.addComponent(this.selectWkspButton);
        wbTraversalPolicy.addComponent(this.tfScriptDir);
        wbTraversalPolicy.addComponent(this.selectScriptDirButton);
        wbTraversalPolicy.addComponent(this.icon);
        wbTraversalPolicy.addComponent(this.selectIconButton);
        wbTraversalPolicy.addComponent(this.macroFile);
        wbTraversalPolicy.addComponent(this.selectMacroFileButton);
        wbTraversalPolicy.addComponent(this.tagList);
        wbTraversalPolicy.addComponent(this.editConnectionScriptsButton);
        wbTraversalPolicy.addComponent(this.editFilterButton);
        wbTraversalPolicy.setDefaultComponent(this.tfProfileName);
        this.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.selectWkspButton.addActionListener(this);
        this.selectIconButton.addActionListener(this);
        this.selectMacroFileButton.addActionListener(this);
        this.selectScriptDirButton.addActionListener(this);
        this.showPassword.addActionListener(this);
        this.infoColor.setActionListener(this);
        this.confirmUpdates.addActionListener(this);
        this.readOnly.addActionListener(this);
        this.cbxPromptUsername.addActionListener(this);
        WbSwingUtilities.setMinimumSize(this.tfFetchSize, 5);
        WbSwingUtilities.setMinimumSize(this.tfTimeout, 5);
        WbSwingUtilities.setMinimumSize(this.altDelimiter, 5);
        this.showPassword.setText(null);
        this.showPassword.setIcon(IconMgr.getInstance().getLabelIcon("eye"));
        this.showPassword.setMargin(this.tfPwd.getMargin());
        this.alignHeight(this.tfPwd, this.showPassword);
        this.alignHeight(this.tfWorkspaceFile, this.selectWkspButton);
        this.alignHeight(this.icon, this.selectIconButton);
        this.alignHeight(this.macroFile, this.selectMacroFileButton);
        this.initEditorList();
    }

    private void alignHeight(JTextField jTextField, JButton jButton) {
        Dimension dimension = jTextField.getPreferredSize();
        Dimension dimension2 = jButton.getPreferredSize();
        Dimension dimension3 = new Dimension(dimension2.width, dimension.height + 2);
        jButton.setSize(dimension3);
        jButton.setPreferredSize(dimension3);
    }

    public JComponent getInitialFocusComponent() {
        return this.tfProfileName;
    }

    public void setFocusToTitle() {
        EventQueue.invokeLater(() -> {
            this.tfProfileName.requestFocusInWindow();
            this.tfProfileName.selectAll();
        });
    }

    private void initEditorList() {
        this.editors.clear();
        this.initEditorList(this);
    }

    private void initEditorList(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof SimplePropertyEditor) {
                SimplePropertyEditor simplePropertyEditor = (SimplePropertyEditor)((Object)component);
                this.editors.add(simplePropertyEditor);
                String string = component.getName();
                component.addPropertyChangeListener(string, this);
                simplePropertyEditor.setImmediateUpdate(true);
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            this.initEditorList((JPanel)component);
        }
    }

    private void showTagSearch() {
        TagSearchPopup tagSearchPopup = new TagSearchPopup(this.tagList, this.allTags);
        tagSearchPopup.showPopup();
    }

    public void setAllTags(Set<String> set) {
        this.allTags = CollectionUtil.caseInsensitiveSet(set);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && WbAction.isCtrlPressed(keyEvent.getModifiers())) {
            keyEvent.consume();
            EventQueue.invokeLater(this::showTagSearch);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void initComponents() {
        this.cbDrivers = new JComboBox();
        this.tfURL = new StringPropertyEditor();
        this.tfUserName = new StringPropertyEditor();
        this.tfPwd = new PasswordPropertyEditor();
        this.asSysDBA = new BooleanPropertyEditor();
        this.lblUsername = new JLabel();
        this.lblPwd = new JLabel();
        this.lblDriver = new JLabel();
        this.lblUrl = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.showPassword = new JButton();
        this.wbOptionsPanel = new JPanel();
        this.cbStorePassword = new BooleanPropertyEditor();
        this.rollbackBeforeDisconnect = new BooleanPropertyEditor();
        this.cbIgnoreDropErrors = new BooleanPropertyEditor();
        this.cbSeparateConnections = new BooleanPropertyEditor();
        this.emptyStringIsNull = new BooleanPropertyEditor();
        this.includeNull = new BooleanPropertyEditor();
        this.removeComments = new BooleanPropertyEditor();
        this.rememberExplorerSchema = new BooleanPropertyEditor();
        this.trimCharData = new BooleanPropertyEditor();
        this.controlUpdates = new JPanel();
        this.confirmUpdates = new BooleanPropertyEditor();
        this.readOnly = new BooleanPropertyEditor();
        this.hideWarnings = new BooleanPropertyEditor();
        this.checkOpenTrans = new BooleanPropertyEditor();
        this.preventNoWhere = new BooleanPropertyEditor();
        this.cbxPromptUsername = new BooleanPropertyEditor();
        this.jCheckBox1 = new BooleanPropertyEditor();
        this.jPanel2 = new JPanel();
        this.tfFetchSize = new IntegerPropertyEditor();
        this.cbAutocommit = new BooleanPropertyEditor();
        this.extendedProps = new JButton();
        this.timeoutLabel = new JLabel();
        this.tfTimeout = new IntegerPropertyEditor();
        this.jLabel1 = new JLabel();
        this.fetchSizeLabel = new JLabel();
        this.sshConfig = new JButton();
        this.jPanel3 = new JPanel();
        this.workspaceFileLabel = new JLabel();
        this.infoColor = new WbColorPicker(true);
        this.infoColorLabel = new JLabel();
        this.altDelimLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.tfWorkspaceFile = new StringPropertyEditor();
        this.selectWkspButton = new JButton();
        this.scriptDirLabel = new JLabel();
        this.jPanel7 = new JPanel();
        this.tfScriptDir = new StringPropertyEditor();
        this.selectScriptDirButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.icon = new StringPropertyEditor();
        this.selectIconButton = new JButton();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.macroFile = new StringPropertyEditor();
        this.selectMacroFileButton = new JButton();
        this.altDelimiter = new StringPropertyEditor();
        this.jLabel2 = new JLabel();
        this.tagList = new StringPropertyEditor();
        this.jSeparator3 = new JSeparator();
        this.timeoutpanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.editConnectionScriptsButton = new JButton();
        this.editFilterButton = new JButton();
        this.editVariablesButton = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.testConnectionButton = new JButton();
        this.groupNameLabel = new JLabel();
        this.tfProfileName = new StringPropertyEditor();
        FormListener formListener = new FormListener();
        this.setMinimumSize(new Dimension(220, 200));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.cbDrivers.setMaximumSize(new Dimension(Short.MAX_VALUE, 64));
        this.cbDrivers.setName("driverclass");
        this.cbDrivers.setVerifyInputWhenFocusTarget(false);
        this.cbDrivers.addItemListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 2, 5);
        this.add((Component)this.cbDrivers, gridBagConstraints);
        this.tfURL.setHorizontalAlignment(2);
        this.tfURL.setName("url");
        this.tfURL.addFocusListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 6, 2, 5);
        this.add((Component)this.tfURL, gridBagConstraints);
        this.tfUserName.setHorizontalAlignment(2);
        this.tfUserName.setName("username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.tfUserName, gridBagConstraints);
        this.tfPwd.setName("password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 4, 2);
        this.add((Component)this.tfPwd, gridBagConstraints);
        this.asSysDBA.setText(ResourceMgr.getString("LblSysDba"));
        this.asSysDBA.setToolTipText(ResourceMgr.getString("d_LblSysDba"));
        this.asSysDBA.setBorder(null);
        this.asSysDBA.setName("oracleSysDBA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 5);
        this.add((Component)this.asSysDBA, gridBagConstraints);
        this.lblUsername.setLabelFor(this.tfUserName);
        this.lblUsername.setText(ResourceMgr.getString("LblUsername"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.add((Component)this.lblUsername, gridBagConstraints);
        this.lblPwd.setLabelFor(this.tfPwd);
        this.lblPwd.setText(ResourceMgr.getString("LblPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.add((Component)this.lblPwd, gridBagConstraints);
        this.lblDriver.setLabelFor(this.cbDrivers);
        this.lblDriver.setText(ResourceMgr.getString("LblDriver"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.lblDriver, gridBagConstraints);
        this.lblUrl.setLabelFor(this.tfURL);
        this.lblUrl.setText(ResourceMgr.getString("LblDbURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 2, 0);
        this.add((Component)this.lblUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.showPassword.setText(ResourceMgr.getString("LblShowPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 4, 5);
        this.add((Component)this.showPassword, gridBagConstraints);
        this.wbOptionsPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.wbOptionsPanel.setLayout(new GridBagLayout());
        this.cbStorePassword.setSelected(true);
        this.cbStorePassword.setText(ResourceMgr.getString("LblSavePassword"));
        this.cbStorePassword.setToolTipText(ResourceMgr.getString("d_LblSavePassword"));
        this.cbStorePassword.setBorder(null);
        this.cbStorePassword.setName("storePassword");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.wbOptionsPanel.add((Component)this.cbStorePassword, gridBagConstraints);
        this.rollbackBeforeDisconnect.setText(ResourceMgr.getString("LblRollbackBeforeDisconnect"));
        this.rollbackBeforeDisconnect.setToolTipText(ResourceMgr.getString("d_LblRollbackBeforeDisconnect"));
        this.rollbackBeforeDisconnect.setBorder(null);
        this.rollbackBeforeDisconnect.setMargin(new Insets(2, 0, 2, 2));
        this.rollbackBeforeDisconnect.setName("rollbackBeforeDisconnect");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.wbOptionsPanel.add((Component)this.rollbackBeforeDisconnect, gridBagConstraints);
        this.cbIgnoreDropErrors.setSelected(true);
        this.cbIgnoreDropErrors.setText(ResourceMgr.getString("LblIgnoreDropErrors"));
        this.cbIgnoreDropErrors.setToolTipText(ResourceMgr.getString("d_LblIgnoreDropErrors"));
        this.cbIgnoreDropErrors.setBorder(null);
        this.cbIgnoreDropErrors.setName("ignoreDropErrors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.wbOptionsPanel.add((Component)this.cbIgnoreDropErrors, gridBagConstraints);
        this.cbSeparateConnections.setText(ResourceMgr.getString("LblSeparateConnections"));
        this.cbSeparateConnections.setToolTipText(ResourceMgr.getString("d_LblSeparateConnections"));
        this.cbSeparateConnections.setBorder(null);
        this.cbSeparateConnections.setName("useSeparateConnectionPerTab");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.wbOptionsPanel.add((Component)this.cbSeparateConnections, gridBagConstraints);
        this.emptyStringIsNull.setText(ResourceMgr.getString("LblEmptyStringIsNull"));
        this.emptyStringIsNull.setToolTipText(ResourceMgr.getString("d_LblEmptyStringIsNull"));
        this.emptyStringIsNull.setBorder(null);
        this.emptyStringIsNull.setName("emptyStringIsNull");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.wbOptionsPanel.add((Component)this.emptyStringIsNull, gridBagConstraints);
        this.includeNull.setText(ResourceMgr.getString("LblIncludeNullInInsert"));
        this.includeNull.setToolTipText(ResourceMgr.getString("d_LblIncludeNullInInsert"));
        this.includeNull.setBorder(null);
        this.includeNull.setMargin(new Insets(2, 0, 2, 2));
        this.includeNull.setName("includeNullInInsert");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.wbOptionsPanel.add((Component)this.includeNull, gridBagConstraints);
        this.removeComments.setText(ResourceMgr.getString("LblRemoveComments"));
        this.removeComments.setToolTipText(ResourceMgr.getString("d_LblRemoveComments"));
        this.removeComments.setBorder(null);
        this.removeComments.setMargin(new Insets(2, 0, 2, 2));
        this.removeComments.setName("removeComments");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 6, 9);
        this.wbOptionsPanel.add((Component)this.removeComments, gridBagConstraints);
        this.rememberExplorerSchema.setText(ResourceMgr.getString("LblRememberSchema"));
        this.rememberExplorerSchema.setToolTipText(ResourceMgr.getString("d_LblRememberSchema"));
        this.rememberExplorerSchema.setBorder(null);
        this.rememberExplorerSchema.setMargin(new Insets(2, 0, 2, 2));
        this.rememberExplorerSchema.setName("storeExplorerSchema");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 9);
        this.wbOptionsPanel.add((Component)this.rememberExplorerSchema, gridBagConstraints);
        this.trimCharData.setText(ResourceMgr.getString("LblTrimCharData"));
        this.trimCharData.setToolTipText(ResourceMgr.getString("d_LblTrimCharData"));
        this.trimCharData.setBorder(null);
        this.trimCharData.setName("trimCharData");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.wbOptionsPanel.add((Component)this.trimCharData, gridBagConstraints);
        this.controlUpdates.setLayout(new FlowLayout(0, 0, 0));
        this.confirmUpdates.setText(ResourceMgr.getString("LblConfirmDbUpdates"));
        this.confirmUpdates.setToolTipText(ResourceMgr.getString("d_LblConfirmDbUpdates"));
        this.confirmUpdates.setBorder(null);
        this.confirmUpdates.setMargin(new Insets(2, 0, 2, 5));
        this.confirmUpdates.setName("confirmUpdates");
        this.controlUpdates.add(this.confirmUpdates);
        this.readOnly.setText(ResourceMgr.getString("LblConnReadOnly"));
        this.readOnly.setToolTipText(ResourceMgr.getString("d_LblConnReadOnly"));
        this.readOnly.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.readOnly.setMargin(new Insets(2, 5, 2, 2));
        this.readOnly.setName("readOnly");
        this.controlUpdates.add(this.readOnly);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.wbOptionsPanel.add((Component)this.controlUpdates, gridBagConstraints);
        this.hideWarnings.setText(ResourceMgr.getString("LblHideWarn"));
        this.hideWarnings.setToolTipText(ResourceMgr.getString("d_LblHideWarn"));
        this.hideWarnings.setBorder(null);
        this.hideWarnings.setName("hideWarnings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 9);
        this.wbOptionsPanel.add((Component)this.hideWarnings, gridBagConstraints);
        this.checkOpenTrans.setText(ResourceMgr.getString("LblCheckUncommitted"));
        this.checkOpenTrans.setToolTipText(ResourceMgr.getString("d_LblCheckUncommitted"));
        this.checkOpenTrans.setBorder(null);
        this.checkOpenTrans.setMargin(new Insets(2, 0, 2, 2));
        this.checkOpenTrans.setName("detectOpenTransaction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 9);
        this.wbOptionsPanel.add((Component)this.checkOpenTrans, gridBagConstraints);
        this.preventNoWhere.setText(ResourceMgr.getString("LblConnPreventNoWhere"));
        this.preventNoWhere.setToolTipText(ResourceMgr.getString("d_LblConnPreventNoWhere"));
        this.preventNoWhere.setBorder(null);
        this.preventNoWhere.setName("preventDMLWithoutWhere");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.wbOptionsPanel.add((Component)this.preventNoWhere, gridBagConstraints);
        this.cbxPromptUsername.setText(ResourceMgr.getString("LblPrompUsername"));
        this.cbxPromptUsername.setToolTipText(ResourceMgr.getString("d_LblPrompUsername"));
        this.cbxPromptUsername.setBorder(null);
        this.cbxPromptUsername.setName("promptForUsername");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.wbOptionsPanel.add((Component)this.cbxPromptUsername, gridBagConstraints);
        this.jCheckBox1.setText(ResourceMgr.getString("LblLocalStorageType"));
        this.jCheckBox1.setBorder(null);
        this.jCheckBox1.setName("storeCacheLocally");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 6, 9);
        this.wbOptionsPanel.add((Component)this.jCheckBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.wbOptionsPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.tfFetchSize.setToolTipText(ResourceMgr.getString("d_LblFetchSize"));
        this.tfFetchSize.setName("defaultFetchSize");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.tfFetchSize, gridBagConstraints);
        this.cbAutocommit.setText("Autocommit");
        this.cbAutocommit.setHorizontalTextPosition(10);
        this.cbAutocommit.setName("autocommit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.cbAutocommit, gridBagConstraints);
        this.extendedProps.setText(ResourceMgr.getString("LblConnExtendedProps"));
        this.extendedProps.setToolTipText(ResourceMgr.getString("d_LblConnExtendedProps"));
        this.extendedProps.setHorizontalTextPosition(10);
        this.extendedProps.addMouseListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.jPanel2.add((Component)this.extendedProps, gridBagConstraints);
        this.timeoutLabel.setLabelFor(this.tfTimeout);
        this.timeoutLabel.setText(ResourceMgr.getString("LblConnTimeout"));
        this.timeoutLabel.setToolTipText(ResourceMgr.getString("d_LblConnTimeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 16, 1, 0);
        this.jPanel2.add((Component)this.timeoutLabel, gridBagConstraints);
        this.tfTimeout.setToolTipText(ResourceMgr.getString("d_LblConnTimeout"));
        this.tfTimeout.setName("connectionTimeout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.tfTimeout, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblSeconds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.fetchSizeLabel.setLabelFor(this.tfFetchSize);
        this.fetchSizeLabel.setText(ResourceMgr.getString("LblFetchSize"));
        this.fetchSizeLabel.setToolTipText(ResourceMgr.getString("d_LblFetchSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 15, 1, 0);
        this.jPanel2.add((Component)this.fetchSizeLabel, gridBagConstraints);
        this.sshConfig.setText(ResourceMgr.getString("LblSshConfig"));
        this.sshConfig.setToolTipText(ResourceMgr.getString("d_LblSshConfig"));
        this.sshConfig.setHorizontalTextPosition(10);
        this.sshConfig.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel2.add((Component)this.sshConfig, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 0, 5);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.workspaceFileLabel.setLabelFor(this.tfWorkspaceFile);
        this.workspaceFileLabel.setText(ResourceMgr.getString("LblOpenWksp"));
        this.workspaceFileLabel.setToolTipText(ResourceMgr.getString("d_LblOpenWksp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.workspaceFileLabel, gridBagConstraints);
        this.infoColor.setToolTipText(ResourceMgr.getDescription("LblInfoColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 0);
        this.jPanel3.add((Component)this.infoColor, gridBagConstraints);
        this.infoColorLabel.setHorizontalAlignment(4);
        this.infoColorLabel.setText(ResourceMgr.getString("LblInfoColor"));
        this.infoColorLabel.setToolTipText(ResourceMgr.getDescription("LblInfoColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.jPanel3.add((Component)this.infoColorLabel, gridBagConstraints);
        this.altDelimLabel.setText(ResourceMgr.getString("LblAltDelimit"));
        this.altDelimLabel.setToolTipText(ResourceMgr.getString("d_LblAltDelimit"));
        this.altDelimLabel.setCursor(new Cursor(12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 23, 1, 0);
        this.jPanel3.add((Component)this.altDelimLabel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.tfWorkspaceFile.setHorizontalAlignment(2);
        this.tfWorkspaceFile.setToolTipText(ResourceMgr.getDescription("LblOpenWksp"));
        this.tfWorkspaceFile.setName("workspaceFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.tfWorkspaceFile, gridBagConstraints);
        this.selectWkspButton.setText("...");
        this.selectWkspButton.setMaximumSize(null);
        this.selectWkspButton.setMinimumSize(null);
        this.selectWkspButton.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.selectWkspButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 6);
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.scriptDirLabel.setLabelFor(this.tfScriptDir);
        this.scriptDirLabel.setText(ResourceMgr.getString("LblEditorDefaultDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.scriptDirLabel, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.tfScriptDir.setHorizontalAlignment(2);
        this.tfScriptDir.setToolTipText(ResourceMgr.getDescription("LblWkspDefDir"));
        this.tfScriptDir.setName("defaultDirectory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.tfScriptDir, gridBagConstraints);
        this.selectScriptDirButton.setText("...");
        this.selectScriptDirButton.setMaximumSize(null);
        this.selectScriptDirButton.setMinimumSize(null);
        this.selectScriptDirButton.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel7.add((Component)this.selectScriptDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 6);
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setText(ResourceMgr.getString("LblIcon"));
        this.jLabel3.setToolTipText(ResourceMgr.getString("d_LblIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.icon.setHorizontalAlignment(2);
        this.icon.setToolTipText(ResourceMgr.getString("d_LblIcon"));
        this.icon.setName("icon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.icon, gridBagConstraints);
        this.selectIconButton.setText("...");
        this.selectIconButton.setMaximumSize(null);
        this.selectIconButton.setMinimumSize(null);
        this.selectIconButton.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.selectIconButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 4, 0, 6);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText(ResourceMgr.getString("LblMacros"));
        this.jLabel4.setToolTipText(ResourceMgr.getString("d_LblMacroFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.macroFile.setHorizontalAlignment(2);
        this.macroFile.setToolTipText(ResourceMgr.getString("d_LblMacroFile"));
        this.macroFile.setName("macroFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.macroFile, gridBagConstraints);
        this.selectMacroFileButton.setText("...");
        this.selectMacroFileButton.setMaximumSize(null);
        this.selectMacroFileButton.setMinimumSize(null);
        this.selectMacroFileButton.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel5.add((Component)this.selectMacroFileButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 4, 0, 6);
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.altDelimiter.setName("alternateDelimiterString");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.altDelimiter, gridBagConstraints);
        this.jLabel2.setText("Tags");
        this.jLabel2.setToolTipText(ResourceMgr.getString("d_LblConnTags"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.tagList.setToolTipText(ResourceMgr.getDescription("LblConnTagsInput", true));
        this.tagList.setName("tagList");
        this.tagList.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 6);
        this.jPanel3.add((Component)this.tagList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 6, 5);
        this.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.jSeparator3, gridBagConstraints);
        this.timeoutpanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 0, 5);
        this.add((Component)this.timeoutpanel, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.editConnectionScriptsButton.setText(ResourceMgr.getString("LblConnScripts"));
        this.editConnectionScriptsButton.setToolTipText(ResourceMgr.getString("d_LblConnScripts"));
        this.editConnectionScriptsButton.setHorizontalTextPosition(10);
        this.editConnectionScriptsButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.editConnectionScriptsButton, gridBagConstraints);
        this.editFilterButton.setText(ResourceMgr.getString("LblSchemaFilterBtn"));
        this.editFilterButton.setToolTipText(ResourceMgr.getString("d_LblSchemaFilterBtn"));
        this.editFilterButton.setHorizontalTextPosition(10);
        this.editFilterButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel6.add((Component)this.editFilterButton, gridBagConstraints);
        this.editVariablesButton.setText(ResourceMgr.getString("TxtVariables"));
        this.editVariablesButton.setHorizontalTextPosition(10);
        this.editVariablesButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel6.add((Component)this.editVariablesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.filler2, gridBagConstraints);
        this.testConnectionButton.setText(ResourceMgr.getString("LblTestConn"));
        this.testConnectionButton.addActionListener(formListener);
        this.jPanel6.add((Component)this.testConnectionButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 14, 10);
        this.add((Component)this.jPanel6, gridBagConstraints);
        this.groupNameLabel.setBackground(new Color(255, 255, 255));
        this.groupNameLabel.setFont(new Font("Tahoma", 1, 11));
        this.groupNameLabel.setText(ResourceMgr.getString("LblGroupName"));
        this.groupNameLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.groupNameLabel, gridBagConstraints);
        this.tfProfileName.setHorizontalAlignment(2);
        this.tfProfileName.setName("name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 5, 6, 5);
        this.add((Component)this.tfProfileName, gridBagConstraints);
    }

    private void extendedPropsMouseClicked(MouseEvent mouseEvent) {
        this.editExtendedProperties();
    }

    private void cbDriversItemStateChanged(ItemEvent itemEvent) {
        if (this.init) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            String string = null;
            DbDriver dbDriver = null;
            try {
                string = this.currentProfile.getDriverclass();
                dbDriver = (DbDriver)this.cbDrivers.getSelectedItem();
                if (this.currentProfile != null) {
                    this.currentProfile.setDriver(dbDriver);
                }
                if (string == null || !string.equals(dbDriver.getDriverClass())) {
                    this.tfURL.setText(dbDriver.getSampleUrl());
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error changing driver", exception);
            }
            this.checkOracle();
            this.checkUncommitted();
            if (dbDriver != null && !dbDriver.canReadLibrary()) {
                Frame frame = (Frame)SwingUtilities.getWindowAncestor(this).getParent();
                DbDriver dbDriver2 = dbDriver;
                EventQueue.invokeLater(() -> {
                    if (WbSwingUtilities.getYesNo(this, ResourceMgr.getString("MsgDriverLibraryNotReadable"))) {
                        DriverEditorDialog.showDriverDialog(frame, dbDriver2);
                    }
                });
            }
        }
    }

    private void editConnectionScriptsButtonActionPerformed(ActionEvent actionEvent) {
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this);
        EditConnectScriptsPanel.editScripts(dialog, this.getProfile());
        this.checkScriptsAndFilters();
    }

    private void editFilterButtonActionPerformed(ActionEvent actionEvent) {
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this);
        EditConnectionFiltersPanel.editFilter(dialog, this.getProfile());
        this.checkScriptsAndFilters();
    }

    private void tfURLFocusLost(FocusEvent focusEvent) {
        this.checkOracle();
    }

    private void editVariablesButtonActionPerformed(ActionEvent actionEvent) {
        ConnectionProfile connectionProfile = this.getProfile();
        Properties properties = connectionProfile.getConnectionVariables();
        if (properties == null) {
            properties = new Properties();
        }
        MapEditor mapEditor = new MapEditor(properties);
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this);
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(dialog, mapEditor, ResourceMgr.getString("TxtEditConnVars"), null, 0, false);
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.edit.profile.variables")) {
            validatingDialog.setSize(400, 300);
        }
        mapEditor.optimizeColumnWidths();
        validatingDialog.setVisible(true);
        if (!validatingDialog.isCancelled()) {
            connectionProfile.setConnectionVariables(mapEditor.getProperties());
            this.checkScriptsAndFilters();
        }
    }

    private void testConnectionButtonActionPerformed(ActionEvent actionEvent) {
        ConnectionGuiHelper.testConnection(this, this.getProfile());
    }

    private void sshConfigActionPerformed(ActionEvent actionEvent) {
        ConnectionProfile connectionProfile = this.getProfile();
        SshConfigPanel sshConfigPanel = new SshConfigPanel();
        sshConfigPanel.setConfig(connectionProfile.getSshConfig(), this.tfURL.getText());
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this);
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(dialog, sshConfigPanel, "SSH Configuration", null, 0, false);
        String string = "workbench.gui.edit.profile.sshconfig";
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, string)) {
            validatingDialog.pack();
            validatingDialog.setSize((int)((double)validatingDialog.getWidth() * 1.5), (int)((double)validatingDialog.getHeight() * 1.05));
        }
        WbSwingUtilities.center(validatingDialog, dialog);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, string);
        if (!validatingDialog.isCancelled()) {
            SshConfig sshConfig = sshConfigPanel.getConfig();
            connectionProfile.setSshConfig(sshConfig);
            if (sshConfig != null && sshConfigPanel.rewriteURL()) {
                UrlParser urlParser = new UrlParser(connectionProfile.getUrl());
                String string2 = urlParser.getLocalUrl(sshConfig.getLocalPort());
                this.tfURL.setText(string2);
            }
            this.checkSSHIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrivers(List<DbDriver> list) {
        if (list != null) {
            this.init = true;
            Object object = this.cbDrivers.getSelectedItem();
            try {
                Comparator comparator = (dbDriver, dbDriver2) -> StringUtil.compareStrings(dbDriver.getName(), dbDriver2.getName(), true);
                Collections.sort(list, comparator);
                this.cbDrivers.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                if (object != null) {
                    this.cbDrivers.setSelectedItem(object);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when setting new driver list", exception);
            }
            finally {
                this.init = false;
            }
        }
    }

    public void editExtendedProperties() {
        EventQueue.invokeLater(() -> {
            ConnectionPropertiesEditor.editProperties(SwingUtilities.getWindowAncestor(this), this.currentProfile);
            this.checkExtendedProps();
        });
    }

    public void selectMacroFile() {
        MacroFileSelector macroFileSelector = new MacroFileSelector();
        WbFile wbFile = macroFileSelector.selectMacroFile(this);
        if (wbFile != null) {
            String string = FileDialogUtil.getPathWithPlaceholder(wbFile);
            this.macroFile.setText(string);
            this.macroFile.setCaretPosition(0);
        }
    }

    public void selectIcon() {
        String string = Settings.getInstance().getProperty("workbench.iconfile.lastdir", null);
        File file = null;
        file = StringUtil.isNonBlank(string) ? new File(string) : Settings.getInstance().getConfigDir();
        WbFileChooser wbFileChooser = new WbFileChooser(file);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(ResourceMgr.getString("TxtFileFilterIcons"), CollectionUtil.arrayList("png", "gif"), true);
        wbFileChooser.setMultiSelectionEnabled(true);
        wbFileChooser.setFileSelectionMode(0);
        wbFileChooser.removeChoosableFileFilter(wbFileChooser.getAcceptAllFileFilter());
        wbFileChooser.addChoosableFileFilter(extensionFileFilter);
        wbFileChooser.setFileFilter(extensionFileFilter);
        int n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            File[] fileArray = wbFileChooser.getSelectedFiles();
            String string2 = "";
            String string3 = System.getProperty("path.separator");
            int n2 = 0;
            for (File file2 : fileArray) {
                WbFile wbFile = new WbFile(file2);
                if (ImageUtil.isPng(file2) || ImageUtil.isGifIcon(file2)) {
                    if (n2 > 0) {
                        string2 = string2 + string3;
                    }
                    string2 = string2 + wbFile.getFullPath();
                    ++n2;
                    continue;
                }
                String string4 = ResourceMgr.getFormattedString("ErrInvalidIcon", wbFile.getName());
                WbSwingUtilities.showErrorMessage(this, string4);
                string2 = null;
                break;
            }
            if (string2 != null) {
                this.icon.setText(string2);
                this.icon.setCaretPosition(0);
            }
            WbFile wbFile = new WbFile(wbFileChooser.getCurrentDirectory());
            Settings.getInstance().setProperty("workbench.iconfile.lastdir", wbFile.getFullPath());
        }
    }

    public void selectScriptDirectory() {
        int n;
        File file;
        String string = StringUtil.trimToNull(this.tfScriptDir.getText());
        WbFileChooser wbFileChooser = new WbFileChooser();
        wbFileChooser.setFileSelectionMode(1);
        wbFileChooser.setMultiSelectionEnabled(false);
        if (string != null && (file = new File(string)).exists()) {
            wbFileChooser.setCurrentDirectory(file);
        }
        if ((n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this))) == 0) {
            WbFile wbFile = new WbFile(wbFileChooser.getSelectedFile());
            this.tfScriptDir.setText(wbFile.getFullPath());
        }
    }

    public void selectWorkspace() {
        FileDialogUtil fileDialogUtil = new FileDialogUtil();
        String string = fileDialogUtil.getWorkspaceFilename(SwingUtilities.getWindowAncestor(this), false, true);
        if (string == null) {
            return;
        }
        this.tfWorkspaceFile.setText(string);
    }

    public void addProfileChangeListener(ProfileChangeListener profileChangeListener) {
        this.changeListener.add(profileChangeListener);
    }

    public void updateProfile() {
        WbFile object3;
        String string;
        Object object2;
        if (this.init) {
            return;
        }
        if (this.currentProfile == null) {
            return;
        }
        if (this.editors == null) {
            return;
        }
        boolean bl = false;
        if (this.currentProfile.isNew() && StringUtil.isNonEmpty((CharSequence)(object2 = this.tfWorkspaceFile.getText())) && StringUtil.isEmptyString(string = (object3 = new WbFile((String)object2)).getExtension())) {
            this.tfWorkspaceFile.setText((String)object2 + ".wksp");
        }
        for (SimplePropertyEditor simplePropertyEditor : this.editors) {
            bl = bl || simplePropertyEditor.isChanged();
            simplePropertyEditor.applyChanges();
        }
        object2 = this.getCurrentDriver();
        String string2 = this.currentProfile.getDriverName();
        string = this.currentProfile.getDriverclass();
        if (!(object2 == null || ((DbDriver)object2).getName().equals(string2) && ((DbDriver)object2).getDriverClass().equals(string))) {
            LogMgr.logDebug(new CallerInfo(){}, "Adjusting selected driver name for non-existing driver: " + this.currentProfile.getIdString());
            this.currentProfile.setDriver((DbDriver)object2);
            bl = true;
        }
        if (bl) {
            this.fireProfileChanged(this.currentProfile);
        }
    }

    public DbDriver getCurrentDriver() {
        DbDriver dbDriver = (DbDriver)this.cbDrivers.getSelectedItem();
        return dbDriver;
    }

    public ConnectionProfile getProfile() {
        this.updateProfile();
        return this.currentProfile;
    }

    private void initPropertyEditors() {
        if (this.editors == null) {
            return;
        }
        if (this.currentProfile == null) {
            return;
        }
        for (SimplePropertyEditor simplePropertyEditor : this.editors) {
            Component component = (Component)((Object)simplePropertyEditor);
            String string = component.getName();
            if (string == null) continue;
            simplePropertyEditor.setSourceObject(this.currentProfile, string);
        }
    }

    private int getFilterSize(ObjectNameFilter objectNameFilter) {
        if (objectNameFilter == null) {
            return 0;
        }
        return objectNameFilter.getSize();
    }

    private void checkPromptUsername() {
        boolean bl = this.cbxPromptUsername.isSelected();
        this.tfUserName.setEnabled(!bl);
        this.tfPwd.setEnabled(!bl);
        this.cbStorePassword.setEnabled(!bl);
    }

    private void checkSSHIcon() {
        this.sshConfig.setIcon(null);
        SshConfig sshConfig = this.getProfile().getSshConfig();
        if (sshConfig != null) {
            this.sshConfig.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        }
    }

    private void checkScriptsAndFilters() {
        boolean bl;
        boolean bl2;
        this.editConnectionScriptsButton.setIcon(null);
        this.editFilterButton.setIcon(null);
        this.editVariablesButton.setIcon(null);
        int n = this.currentProfile == null ? 0 : this.getFilterSize(this.currentProfile.getSchemaFilter());
        int n2 = this.currentProfile == null ? 0 : this.getFilterSize(this.currentProfile.getCatalogFilter());
        boolean bl3 = bl2 = n + n2 > 0;
        if (bl2) {
            this.editFilterButton.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        }
        boolean bl4 = bl = this.currentProfile == null ? false : this.currentProfile.hasConnectScript();
        if (bl) {
            this.editConnectionScriptsButton.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        }
        if (CollectionUtil.isNonEmpty(this.currentProfile.getConnectionVariables())) {
            this.editVariablesButton.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        }
    }

    private void checkExtendedProps() {
        Properties properties;
        Properties properties2 = properties = this.currentProfile == null ? null : this.currentProfile.getConnectionProperties();
        if (properties != null && properties.size() > 0) {
            this.extendedProps.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        } else {
            this.extendedProps.setIcon(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfile(ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return;
        }
        this.currentProfile = connectionProfile;
        try {
            Object object;
            this.init = true;
            this.groupNameLabel.setText(this.currentProfile.getGroup());
            this.initPropertyEditors();
            String string = connectionProfile.getDriverclass();
            DbDriver dbDriver = null;
            if (string != null) {
                object = connectionProfile.getDriverName();
                dbDriver = ConnectionMgr.getInstance().findDriverByName(string, (String)object);
            }
            this.cbDrivers.setSelectedItem(dbDriver);
            object = this.currentProfile.getInfoDisplayColor();
            this.infoColor.setSelectedColor((Color)object);
            this.checkExtendedProps();
            this.checkScriptsAndFilters();
            this.checkSSHIcon();
            this.checkOracle();
            this.checkUncommitted();
            this.checkPromptUsername();
            this.syncColor();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting profile", exception);
        }
        finally {
            this.init = false;
        }
    }

    private void checkUncommitted() {
        String string = this.getCurrentDriver() == null ? null : this.getCurrentDriver().getDriverClass();
        boolean bl = TransactionChecker.Factory.supportsTransactionCheck(string);
        if (bl && string != null) {
            this.checkOpenTrans.setEnabled(true);
            this.checkOpenTrans.setSelected(this.currentProfile.getDetectOpenTransaction());
            if (string.contains("oracle")) {
                this.checkOpenTrans.setToolTipText(ResourceMgr.getDescription("LblCheckUncommittedOra"));
            } else {
                this.checkOpenTrans.setToolTipText(ResourceMgr.getDescription("LblCheckUncommitted"));
            }
        } else {
            this.checkOpenTrans.setEnabled(false);
            this.checkOpenTrans.setSelected(false);
            this.checkOpenTrans.setToolTipText(ResourceMgr.getDescription("LblCheckUncommittedNA"));
        }
    }

    private void checkOracle() {
        String string = this.tfURL.getText();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.tfUserName);
        if (string.startsWith("jdbc:oracle:")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 6, 2, 2);
            gridBagLayout.setConstraints(this.tfUserName, gridBagConstraints);
            this.asSysDBA.setVisible(true);
            this.asSysDBA.setEnabled(true);
            this.asSysDBA.setSelected(this.currentProfile.getOracleSysDBA());
        } else {
            this.asSysDBA.setVisible(false);
            this.asSysDBA.setEnabled(false);
            this.asSysDBA.setSelected(false);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 6, 2, 5);
            gridBagLayout.setConstraints(this.tfUserName, gridBagConstraints);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.init) {
            this.fireProfileChanged(this.currentProfile);
        }
    }

    private void fireProfileChanged(ConnectionProfile connectionProfile) {
        for (ProfileChangeListener profileChangeListener : this.changeListener) {
            profileChangeListener.profileChanged(connectionProfile);
        }
    }

    private void syncColor() {
        Color color = this.infoColor.getSelectedColor();
        if (color == null) {
            this.groupNameLabel.setBackground(Color.WHITE);
            this.groupNameLabel.setForeground(Color.BLACK);
        } else {
            this.groupNameLabel.setBackground(color);
            if (GuiSettings.useContrastColor()) {
                this.groupNameLabel.setForeground(WbSwingUtilities.getContrastColor(color));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.readOnly) {
            if (this.readOnly.isSelected()) {
                this.confirmUpdates.setSelected(false);
            }
        } else if (actionEvent.getSource() == this.confirmUpdates) {
            if (this.confirmUpdates.isSelected()) {
                this.readOnly.setSelected(false);
            }
        } else if (actionEvent.getSource() == this.selectScriptDirButton) {
            this.selectScriptDirectory();
        } else if (actionEvent.getSource() == this.selectWkspButton) {
            this.selectWorkspace();
        } else if (actionEvent.getSource() == this.selectIconButton) {
            this.selectIcon();
        } else if (actionEvent.getSource() == this.selectMacroFileButton) {
            this.selectMacroFile();
        } else if (actionEvent.getSource() == this.showPassword) {
            if (this.tfPwd.getEchoChar() == '\u0000') {
                this.tfPwd.setEchoChar(this.echoChar);
                this.tfPwd.putClientProperty("JPasswordField.cutCopyAllowed", false);
            } else {
                this.tfPwd.setEchoChar('\u0000');
                this.tfPwd.putClientProperty("JPasswordField.cutCopyAllowed", true);
            }
        } else if (actionEvent.getSource() == this.infoColor && this.currentProfile != null) {
            this.currentProfile.setInfoDisplayColor(this.infoColor.getSelectedColor());
            this.syncColor();
        } else if (actionEvent.getSource() == this.cbxPromptUsername) {
            this.checkPromptUsername();
        }
    }

    @Override
    public boolean validateInput() {
        DelimiterDefinition delimiterDefinition = this.getProfile().getAlternateDelimiter();
        if (delimiterDefinition != null && delimiterDefinition.isStandard()) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrWrongAltDelim");
            return false;
        }
        return this.getProfile().isConfigured();
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener,
    MouseListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ConnectionEditorPanel.this.sshConfig) {
                ConnectionEditorPanel.this.sshConfigActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionEditorPanel.this.editConnectionScriptsButton) {
                ConnectionEditorPanel.this.editConnectionScriptsButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionEditorPanel.this.editFilterButton) {
                ConnectionEditorPanel.this.editFilterButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionEditorPanel.this.editVariablesButton) {
                ConnectionEditorPanel.this.editVariablesButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ConnectionEditorPanel.this.testConnectionButton) {
                ConnectionEditorPanel.this.testConnectionButtonActionPerformed(actionEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == ConnectionEditorPanel.this.tfURL) {
                ConnectionEditorPanel.this.tfURLFocusLost(focusEvent);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ConnectionEditorPanel.this.cbDrivers) {
                ConnectionEditorPanel.this.cbDriversItemStateChanged(itemEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ConnectionEditorPanel.this.extendedProps) {
                ConnectionEditorPanel.this.extendedPropsMouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

