/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Dialog;
import java.awt.Window;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FeedbackWindow;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.profiles.LoginPrompt;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshHostConfig;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class ConnectionGuiHelper {
    public static boolean doPrompt(Window window, ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return true;
        }
        boolean bl = connectionProfile.needsPasswordPrompt();
        boolean bl2 = connectionProfile.needsSSHPasswordPrompt();
        if (connectionProfile.getPromptForUsername()) {
            boolean bl3 = ConnectionGuiHelper.promptUsername(window, connectionProfile);
            if (bl2 && bl3) {
                return ConnectionGuiHelper.promptForSSHPassword(window, connectionProfile);
            }
            return bl3;
        }
        if (bl) {
            return ConnectionGuiHelper.promptPassword(window, connectionProfile);
        }
        if (bl2) {
            return ConnectionGuiHelper.promptForSSHPassword(window, connectionProfile);
        }
        return true;
    }

    public static boolean promptUsername(Window window, ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return false;
        }
        LoginPrompt loginPrompt = new LoginPrompt(connectionProfile.getSettingsKey());
        boolean bl = ValidatingDialog.showConfirmDialog(window, loginPrompt, ResourceMgr.getFormattedString("TxtEnterLogin", connectionProfile.getName()));
        if (!bl) {
            return false;
        }
        connectionProfile.setPassword(loginPrompt.getPassword());
        connectionProfile.setTemporaryUsername(loginPrompt.getUserName());
        return true;
    }

    public static boolean promptPassword(Window window, ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return false;
        }
        String string = connectionProfile.getName();
        String string2 = ResourceMgr.getFormattedString("MsgInputPwd", connectionProfile.getUsername());
        String string3 = WbSwingUtilities.passwordPrompt(window, string, string2);
        if (StringUtil.isEmptyString(string3)) {
            return false;
        }
        connectionProfile.setPassword(string3);
        return true;
    }

    public static boolean promptForSSHPassword(Window window, ConnectionProfile connectionProfile) {
        Object object;
        String string;
        String string2;
        if (connectionProfile == null) {
            return false;
        }
        SshHostConfig sshHostConfig = connectionProfile.getSshHostConfig();
        if (sshHostConfig == null) {
            return true;
        }
        if (sshHostConfig.getPrivateKeyFile() == null) {
            string2 = ResourceMgr.getFormattedString("MsgInputPwd", sshHostConfig.getUsername() + "@" + sshHostConfig.getHostname() + ":" + sshHostConfig.getSshPort());
            string = ResourceMgr.getFormattedString("MsgInputSshPwd", new Object[0]);
        } else {
            string = ResourceMgr.getString("MsgInputSshPassPhrase");
            object = new WbFile(sshHostConfig.getPrivateKeyFile());
            string2 = ((WbFile)object).getFileName();
        }
        object = WbSwingUtilities.passwordPrompt(window, string, string2);
        if (StringUtil.isEmptyString((CharSequence)object)) {
            return false;
        }
        sshHostConfig.setTemporaryPassword((String)object);
        return true;
    }

    public static void testConnection(JComponent jComponent, final ConnectionProfile connectionProfile) {
        final Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (!ConnectionGuiHelper.doPrompt(window, connectionProfile)) {
            return;
        }
        final FeedbackWindow feedbackWindow = new FeedbackWindow((Dialog)((JDialog)window), ResourceMgr.getString("MsgConnecting"));
        WbThread wbThread = new WbThread("ConnectionTest"){

            @Override
            public void run() {
                try {
                    WbConnection wbConnection = ConnectionMgr.getInstance().getConnection(connectionProfile, "$Connection-Test");
                    feedbackWindow.setVisible(false);
                    ConnectionMgr.getInstance().abortAll(Collections.singletonList(wbConnection));
                    WbSwingUtilities.showMessage(window, ResourceMgr.getFormattedString("MsgBatchConnectOk", connectionProfile.getUrl()));
                }
                catch (Exception exception) {
                    String string = ExceptionUtil.getDisplay(exception, false);
                    feedbackWindow.setVisible(false);
                    WbSwingUtilities.showFriendlyErrorMessage(window, ResourceMgr.getString("ErrConnectFailed"), string);
                }
                finally {
                    feedbackWindow.dispose();
                }
            }
        };
        wbThread.start();
        WbSwingUtilities.center(feedbackWindow, window);
        feedbackWindow.setVisible(true);
    }
}

