/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import workbench.db.DbDriver;

class DriverListModel
implements ListModel {
    private List<DbDriver> drivers;

    DriverListModel(List<DbDriver> list) {
        this.drivers = new ArrayList<DbDriver>(list);
        Comparator comparator = (dbDriver, dbDriver2) -> {
            if (dbDriver == null && dbDriver2 == null) {
                return 0;
            }
            if (dbDriver == null) {
                return -1;
            }
            if (dbDriver2 == null) {
                return 1;
            }
            return dbDriver.getName().compareTo(dbDriver2.getName());
        };
        Collections.sort(this.drivers, comparator);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    public Object getElementAt(int n) {
        return this.getDriver(n).getName();
    }

    public DbDriver getDriver(int n) {
        return this.drivers.get(n);
    }

    @Override
    public int getSize() {
        return this.drivers.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }

    public void addDriver(DbDriver dbDriver) {
        this.drivers.add(this.drivers.size(), dbDriver);
    }

    public void deleteDriver(int n) {
        this.drivers.remove(n);
    }

    public void putDriver(int n, DbDriver dbDriver) {
        this.drivers.set(n, dbDriver);
        n = 1;
    }

    public List<DbDriver> getValues() {
        return this.drivers;
    }
}

