/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.ConnectionMgr;
import workbench.db.DbDriver;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.profiles.DriverEditorPanel;
import workbench.gui.profiles.DriverListModel;
import workbench.gui.profiles.VetoableListSelectionModel;
import workbench.interfaces.FileActions;
import workbench.interfaces.ListSelectionControl;
import workbench.interfaces.Validator;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;

public class DriverlistEditorPanel
extends JPanel
implements FileActions,
Validator,
ListSelectionControl,
ListSelectionListener {
    private DriverListModel model;
    private JToolBar toolbar;
    private int lastIndex = -1;
    private DriverEditorPanel driverEditor;
    private JList driverList;

    public DriverlistEditorPanel() {
        this.initComponents();
        this.fillDriverList();
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.driverList);
        wbTraversalPolicy.addComponent(this.driverEditor);
        wbTraversalPolicy.setDefaultComponent(this.driverList);
    }

    private void fillDriverList() {
        this.model = new DriverListModel(ConnectionMgr.getInstance().getDrivers());
        this.driverList.setModel(this.model);
        if (this.model.getSize() > 0) {
            this.driverList.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.driverList = new JList();
        this.driverList.setSelectionModel(new VetoableListSelectionModel(this));
        this.driverEditor = new DriverEditorPanel();
        this.driverEditor.setValidator(this);
        this.setLayout(new BorderLayout());
        this.driverList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.driverList);
        this.toolbar = new WbToolbar();
        this.toolbar.setBorder(DividerBorder.BOTTOM_DIVIDER);
        this.toolbar.add(new NewListEntryAction(this));
        this.toolbar.add(new DeleteListEntryAction(this));
        this.add((Component)this.toolbar, "North");
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.driverEditor, "Center");
        this.setMinimumSize(new Dimension(200, 400));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.driverList) {
            int n;
            if (this.lastIndex > -1) {
                DbDriver dbDriver = this.driverEditor.getDriver();
                this.model.putDriver(this.lastIndex, dbDriver);
            }
            if ((n = this.driverList.getSelectedIndex()) > -1) {
                DbDriver dbDriver = this.model.getDriver(n);
                this.driverEditor.setDriver(dbDriver);
            }
            this.lastIndex = n;
        }
    }

    public DbDriver getSelectedDriver() {
        this.updateUI();
        this.driverEditor.updateDriver();
        int n = this.driverList.getSelectedIndex();
        DbDriver dbDriver = this.model.getDriver(n);
        return dbDriver;
    }

    public void selectDriver(String string) {
        if (string == null) {
            return;
        }
        try {
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                DbDriver dbDriver = this.model.getDriver(i);
                if (!dbDriver.getName().equals(string)) continue;
                this.driverList.setSelectedIndex(i);
                this.driverList.ensureIndexIsVisible(i);
                break;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting item", exception);
            this.driverList.setSelectedIndex(0);
        }
    }

    @Override
    public void deleteItem() throws Exception {
        int n = this.driverList.getSelectedIndex();
        this.driverList.clearSelection();
        this.driverEditor.reset();
        this.model.deleteDriver(n);
        if (n > this.model.getSize() - 1) {
            --n;
        }
        this.driverList.setSelectedIndex(n);
        this.driverList.repaint();
    }

    @Override
    public void newItem(boolean bl) {
        DbDriver dbDriver = bl ? this.getSelectedDriver().createCopy() : new DbDriver();
        dbDriver.setName(ResourceMgr.getString("TxtEmptyDriverName"));
        this.model.addDriver(dbDriver);
        this.selectDriver(dbDriver.getName());
        this.driverList.updateUI();
    }

    @Override
    public void saveItem() throws Exception {
        if (this.driverEditor.validateName()) {
            ConnectionMgr connectionMgr = ConnectionMgr.getInstance();
            this.driverEditor.updateDriver();
            connectionMgr.setDrivers(this.model.getValues());
            connectionMgr.saveDrivers();
        }
    }

    @Override
    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        int n = this.driverList.getSelectedIndex();
        int n2 = this.model.getValues().size();
        for (int i = 0; i < n2; ++i) {
            if (i == n || !string.equalsIgnoreCase(this.model.getDriver(i).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canChangeSelection() {
        return this.driverEditor.validateName();
    }
}

